import re
from rest_framework.views import APIView
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .models import *
from base.models import *
import math, random, datetime, pytz, string
from django.conf import settings
import requests, json
from django.contrib.auth.hashers import make_password
from django.db.models import Q
from .serializers import *
from django.http import HttpResponse, response
from rest_framework.response import Response
from django.contrib.auth import authenticate, login
from django.core.files.storage import FileSystemStorage

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

#Old one
# class addQuantity(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			if not data.get('session_token'):
# 				response['status_code']=400
# 				response['status_message']='session_token required'
# 				return Response(response)
# 			if not data.get('quanWeight'):
# 				response['status_code']=400
# 				response['status_message']='quanWeight required'
# 				return Response(response)
# 			if not data.get('quanUnit'):
# 				response['status_code']=400
# 				response['status_message']='quanUnit required'
# 				return Response(response)
# 			if not data.get('categoryId'):
# 				response['status_code']=400
# 				response['status_message']='categoryId required'
# 				return Response(response)
# 			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
# 			if not adminObjects:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)
# 			alreadyQuan=quantities.objects.filter(quanWeight=data.get('quanWeight'),quanUnit=data.get('quanUnit')).first()
# 			if alreadyQuan:
# 				response['status_code']=400
# 				response['status_message']='Quantity already exist'
# 				return Response(response)
# 			theQuantityObject=quantities.objects.create(categoryId=data.get('categoryId'),quanWeight=data.get('quanWeight'),quanUnit=data.get('quanUnit'))
# 			response['status_code']=200
# 			response['status_message']='Success'
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=400
# 			response['status_message']=str(e)
# 		return Response(response)

#New one

class addQuantity(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			if not data.get('quanWeight'):
				response['status_code']=400
				response['status_message']='quanWeight required'
				return Response(response)
			if not data.get('quanUnit'):
				response['status_code']=400
				response['status_message']='quanUnit required'
				return Response(response)
			if not data.get('categoryId'):
				response['status_code']=400
				response['status_message']='categoryId required'
				return Response(response)
			categoryObj = thecategory.objects.filter(categoryId=data.get('categoryId')).first()
			if not categoryObj:
				response['status_code']=400
				response['status_message']='Invalid categoryId'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			alreadyQuan=quantities.objects.filter(category=categoryObj,quanWeight=data.get('quanWeight'),quanUnit=data.get('quanUnit')).first()
			if alreadyQuan:
				response['status_code']=400
				response['status_message']='Quantity already exist'
				return Response(response)
			theQuantityObject=quantities.objects.create(category=categoryObj,quanWeight=data.get('quanWeight'),quanUnit=data.get('quanUnit'))
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)
#new one
class updateQuantity(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			if not data.get('id'):
				response['status_code']=400
				response['status_message']='id required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			categoryObj = thecategory.objects.filter(categoryId=data.get('categoryId')).first()
			# print('categoryObj',categoryObj)
			# alreadyQuan=quantities.objects.filter(categoryId=categoryObj,quanWeight=data.get('quanWeight'),quanUnit=data.get('quanUnit')).first()	
			# print('alreadyQuan',alreadyQuan)
			# if alreadyQuan:
			# 	response['status_code']=400
			# 	response['status_message']='Quantity already exist'
			# 	return Response(response)
			
			quanObj=quantities.objects.filter(id=data.get('id')).first()
			if quanObj:
				if data.get('categoryId'):
					quanObj.category=categoryObj
				if data.get('quanWeight'):
					quanObj.quanWeight=data.get('quanWeight')
				if data.get('quanUnit'):
					quanObj.quanUnit=data.get('quanUnit')
				quanObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)
#old one
# class updateQuantity(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			if not data.get('session_token'):
# 				response['status_code']=400
# 				response['status_message']='session_token required'
# 				return Response(response)
# 			if not data.get('id'):
# 				response['status_code']=400
# 				response['status_message']='id required'
# 				return Response(response)
# 			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
# 			if not adminObjects:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)
# 			alreadyQuan=quantities.objects.filter(quanWeight=data.get('quanWeight'),quanUnit=data.get('quanUnit')).first()
# 			if alreadyQuan:
# 				response['status_code']=400
# 				response['status_message']='Quantity already exist'
# 				return Response(response)
			
# 			quanObj=quantities.objects.filter(id=data.get('id')).first()
# 			if quanObj:
# 				if data.get('categoryId'):
# 					quanObj.categoryId=data.get('categoryId')
# 				if data.get('quanWeight'):
# 					quanObj.quanWeight=data.get('quanWeight')
# 				if data.get('categoryId'):
# 					quanObj.quanUnit=data.get('categoryId')
# 				quanObj.save()
# 			response['status_code']=200
# 			response['status_message']='Success'
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=400
# 			response['status_message']=str(e)
# 		return Response(response)


#Old One
# class getQuantities(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			if not data.get('session_token'):
# 				response['status_code']=400
# 				response['status_message']='session_token required'
# 				return Response(response)
# 			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
# 			if not adminObjects:
# 				response['status_code']=400
# 				response['status_message']='Invalid token'
# 				return Response(response)
# 			allQuantities=quantities.objects.all()
# 			theData=GetQuantitesData(allQuantities,many=True)
# 			response['status_code']=200
# 			response['status_message']='Success'
# 			response['data']=theData.data
# 			return Response(response)
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=400
# 			response['status_message']=str(e)
# 		return Response(response)

#New one
class getQuantities(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			allQuantities=quantities.objects.all()
			print('allQuantities',allQuantities)
			allData = []
			# theData = ''
			for allQuanti in allQuantities:
				theData=GetQuantitesData(allQuanti).data
				response['status_code']=200
				response['status_message']='Success'
				allData.append(theData)
				response['data'] = allData
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getStatesForOthers(APIView):
	def get(self,request):
		response={}
		try:
			data=request.data
			allStates=state.objects.all()
			allStateGetData=GetStatesData(allStates,many=True)
			response['data']=allStateGetData.data
			response['status_code']=200
			response['status_message']='All data'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)
	def post(self, request, *args, **kwargs):
		response={}
		try:
			accessKey = request.META.get('HTTP_AUTHORIZATION')
			
			if not accessKey:
				response['status_code']=400
				response['status_message']='Access Key required'
				return Response(response)
			accessKey = accessKey.replace("Token ", "")

			
			if accessKey==str(settings.MY_ACCESS_KEY):
				data=request.data
				if data.get('country'):
					theCountryOBJ=country.objects.filter(country=data.get('country')).first()
					if not theCountryOBJ:
						response['status_code']=400
						response['status_message']='invalid country'
						return Response(response)
					else:
						allStates=state.objects.filter(country=theCountryOBJ,isdisabled=False)
						allStateGetData=GetStatesData(allStates,many=True)
						response['data']=allStateGetData.data
				else:
					allStates=state.objects.filter(isdisabled=False)
					allStateGetData=GetStatesData(allStates,many=True)
					response['data']=allStateGetData.data
				response['status_code']=200
				response['status_message']='All data'
			else:
				response['status_code']=401
				response['status_message']='Unauthorized'
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getQuantitiesForOthers(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='Access Key required'
				return Response(response)
			if data.get('AccessKey')==str(settings.MY_ACCESS_KEY):
				allQuantities=quantities.objects.filter(isdisabled=False)
				theData=GetQuantitesData(allQuantities,many=True)
				response['data']=theData.data
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
			else:
				response['status_code']=401
				response['status_message']='Unauthorized'
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class addTermsAndConditionsCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('content'):
				response['status_code']=400
				response['status_message']='content required'
				return Response(response)
			try:
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/content/addTermsAndConditions/"
				payload={
					'AccessKey':str(settings.CUSTOMER_ACCESS_KEY),
					'title':data.get('title'),
					'content':data.get('content')
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addPrivacyPolicyCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('content'):
				response['status_code']=400
				response['status_message']='content required'
				return Response(response)
			try:
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/content/addPrivacyPolicy/"
				payload={
					'AccessKey':str(settings.CUSTOMER_ACCESS_KEY),
					'title':data.get('title'),
					'content':data.get('content')
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getTermsAndConditionsCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			try:
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/content/getTermsAndConditionsByAdmin/"
				payload={
					'AccessKey':str(settings.CUSTOMER_ACCESS_KEY),
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getPrivacyPolicyCustomer(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			try:
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/content/getPrivacyPolicyByAdmin/"
				payload={
					'AccessKey':str(settings.CUSTOMER_ACCESS_KEY),
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addCountry(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if not data.get('country'):
				response['status_code']=401
				response['status_message']='country required'
				return Response(response)
			if not data.get('alphacodetwo'):
				response['status_code']=401
				response['status_message']='alphacodetwo required'
				return Response(response)
			if not data.get('alphacodethree'):
				response['status_code']=401
				response['status_message']='alphacodethree required'
				return Response(response)
			theCountryObject=country.objects.filter(country=data.get('country')).first()
			if theCountryObject:
				response['status_code']=400
				response['status_message']='country already exist'
				return Response(response)
			theCountryObject=country.objects.create(country=data.get('country'),alphacodetwo=data.get('alphacodetwo'),alphacodethree=data.get('alphacodethree'))
			response['status_code']=200
			response['status_message']='country added'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getCountries(APIView):
	def get(self,request):
		response={}
		try:
			allCountries=country.objects.filter(isdisabled=False)
			allCountryGetData=GetCountryData(allCountries,many=True)
			response['data']=allCountryGetData.data
			response['status_code']=200
			response['status_message']='countries data'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if data.get('search'):
				if data.get('status'):
					if data.get("status")=='active':
						allCountries=country.objects.filter(country__icontains=data.get('search'),isdisabled=False)
					elif data.get('status')=='inactive':
						allCountries=country.objects.filter(country__icontains=data.get('search'),isdisabled=True)
					else:
						allCountries=country.objects.filter(country__icontains=data.get('search'))
				else:
					allCountries=country.objects.filter(country__icontains=data.get('search'))
			else:
				if data.get('status'):
					if data.get("status")=='active':
						allCountries=country.objects.filter(isdisabled=False)
					elif data.get('status')=='inactive':
						allCountries=country.objects.filter(isdisabled=True)
					else:
						allCountries=country.objects.all()
				else:
					allCountries=country.objects.all()
			allCountriesData=GetCountryData(allCountries,many=True)
			response['data']=allCountriesData.data
			response['status_code']=200
			response['status_message']='All data'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addState(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('stateName'):
				response['status_code']=401
				response['status_message']='stateName required'
				return Response(response)
			if not data.get('stateFullAddress'):
				response['status_code']=401
				response['status_message']='stateFullAddress required'
				return Response(response)
			if not data.get('minimumAge'):
				response['status_code']=401
				response['status_message']='minimumAge required'
				return Response(response)
			if not data.get('country'):
				response['status_code']=401
				response['status_message']='country required'
				return Response(response)
			theCountryOBJ=country.objects.filter(country=data.get('country')).first()
			if not theCountryOBJ:
				response['status_code']=400
				response['status_message']='invalid country'
				return Response(response)
			alreadyState=state.objects.filter(country=theCountryOBJ,state=data.get('stateName')).first()
			if alreadyState:
				response['status_code']=400
				response['status_message']='State already exist'
				return Response(response)
			alreadyState=state.objects.create(country=theCountryOBJ,state=data.get('stateName'),fulladdress=data.get('stateFullAddress'),minimumage=data.get('minimumAge'))
			response['status_code']=200
			response['status_message']='State Added'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getStates(APIView):
	def get(self,request):
		response={}
		try:
			data=request.data
			allStates=state.objects.filter(isdisabled=False)
			allStateGetData=GetStatesData(allStates,many=True)
			response['data']=allStateGetData.data
			response['status_code']=200
			response['status_message']='All data'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if data.get('country'):
				theCountryOBJ=country.objects.filter(country=data.get('country')).first()
				if not theCountryOBJ:
					response['status_code']=400
					response['status_message']='invalid country'
					return Response(response)
				else:
					allStates=state.objects.filter(country=theCountryOBJ)
					allStateGetData=GetStatesData(allStates,many=True)
					response['data']=allStateGetData.data
			else:
				if data.get('search'):
					if data.get('status'):
						if data.get("status")=='active':
							allStates=state.objects.filter(state__icontains=data.get('search'),isdisabled=False)
						elif data.get('status')=='inactive':
							allStates=state.objects.filter(state__icontains=data.get('search'),isdisabled=True)
						else:
							allStates=state.objects.filter(state__icontains=data.get('search'))
					else:
						allStates=state.objects.filter(state__icontains=data.get('search'))
				else:
					if data.get('status'):
						if data.get("status")=='active':
							allStates=state.objects.filter(isdisabled=False)
						elif data.get('status')=='inactive':
							allStates=state.objects.filter(isdisabled=True)
						else:
							allStates=state.objects.all()
					else:
						allStates=state.objects.all()
				# allStates=state.objects.all()
				allStateGetData=GetStatesData(allStates,many=True)
				response['data']=allStateGetData.data
			response['status_code']=200
			response['status_message']='All data'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addDistrict(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if not data.get('district'):
				response['status_code']=400
				response['status_message']='district required'
				return Response(response)
			if not data.get('districtlatitude'):
				response['status_code']=400
				response['status_message']='districtlatitude required'
				return Response(response)
			if not data.get('districtlongitude'):
				response['status_code']=400
				response['status_message']='districtlongitude required'
				return Response(response)
			if not data.get('fulladdress'):
				response['status_code']=400
				response['status_message']='fulladdress required'
				return Response(response)
			if not data.get('country'):
				response['status_code']=400
				response['status_message']='country required'
				return Response(response)
			theCountryOBJ=country.objects.filter(country=data.get('country')).first()
			if not theCountryOBJ:
				response['status_code']=400
				response['status_message']='invalid country'
				return Response(response)
			if not data.get('state'):
				response['status_code']=400
				response['status_message']='state required'
				return Response(response)
			theStateOBJ=state.objects.filter(state=data.get('state'),country=theCountryOBJ).first()
			if not theStateOBJ:
				response['status_code']=400
				response['status_message']='invalid state'
				return Response(response)

			alreadyDistrict=district.objects.filter(country=theCountryOBJ,state=theStateOBJ,district=data.get('district')).first()
			if alreadyDistrict:
				response['status_code']=400
				response['status_message']='District already exist'
				return Response(response)
			alreadyDistrict=district.objects.create(country=theCountryOBJ,state=theStateOBJ,district=data.get('district'),districtlatitude=data.get('districtlatitude'),districtlongitude=data.get('districtlongitude'),fulladdress=data.get('fulladdress'))
			response['status_code']=200
			response['status_message']='District Added'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getDistricts(APIView):
	def get(self,request):
		response={}
		try:
			allDistricts=district.objects.filter(isdisabled=False)
			allDistrictsData=GetDistrictData(allDistricts,many=True)
			response['data']=allStateGetData.data
			response['status_code']=200
			response['status_message']='All data'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			# allStates=district.objects.all()
			if data.get('search'):
				if data.get('status'):
					if data.get("status")=='active':
						allStates=district.objects.filter(district__icontains=data.get('search'),isdisabled=False)
					elif data.get('status')=='inactive':
						allStates=district.objects.filter(district__icontains=data.get('search'),isdisabled=True)
					else:
						allStates=district.objects.filter(district__icontains=data.get('search'))
				else:
					allStates=district.objects.filter(district__icontains=data.get('search'))
			else:
				if data.get('status'):
					if data.get("status")=='active':
						allStates=district.objects.filter(isdisabled=False)
					elif data.get('status')=='inactive':
						allStates=district.objects.filter(isdisabled=True)
					else:
						allStates=district.objects.all()
				else:
					allStates=district.objects.all()
			allStateGetData=GetDistrictData(allStates,many=True)
			response['data']=allStateGetData.data
			response['status_code']=200
			response['status_message']='All data'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addTermsAndConditionsCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('content'):
				response['status_code']=400
				response['status_message']='content required'
				return Response(response)
			try:
				import requests
				url = str(settings.COMPANY_ACCESS_URL)+"company/content/addTermsAndConditions/"
				payload={
					'AccessKey':str(settings.COMPANY_ACCESS_KEY),
					'title':data.get('title'),
					'content':data.get('content')
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addPrivacyPolicyCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('content'):
				response['status_code']=400
				response['status_message']='content required'
				return Response(response)
			try:
				import requests
				url = str(settings.COMPANY_ACCESS_URL)+"company/content/addPrivacyPolicy/"
				payload={
					'AccessKey':str(settings.COMPANY_ACCESS_KEY),
					'title':data.get('title'),
					'content':data.get('content')
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getTermsAndConditionsCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			try:
				import requests
				url = str(settings.COMPANY_ACCESS_URL)+"company/content/getTermsAndConditionsByAdmin/"
				payload={
					'AccessKey':str(settings.COMPANY_ACCESS_KEY),
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getPrivacyPolicyCompany(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			try:
				import requests
				url = str(settings.COMPANY_ACCESS_URL)+"company/content/getPrivacyPolicyByAdmin/"
				payload={
					'AccessKey':str(settings.COMPANY_ACCESS_KEY),
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

# =============================================================================================================================


class addTermsAndConditionsDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('content'):
				response['status_code']=400
				response['status_message']='content required'
				return Response(response)
			try:
				import requests
				url = str(settings.DRIVER_ACCESS_URL)+"driver/content/addTermsAndConditions/"
				payload={
					'AccessKey':str(settings.DRIVER_ACCESS_KEY),
					'title':data.get('title'),
					'content':data.get('content')
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addPrivacyPolicyDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('content'):
				response['status_code']=400
				response['status_message']='content required'
				return Response(response)
			try:
				import requests
				url = str(settings.DRIVER_ACCESS_URL)+"driver/content/addPrivacyPolicy/"
				payload={
					'AccessKey':str(settings.DRIVER_ACCESS_KEY),
					'title':data.get('title'),
					'content':data.get('content')
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getTermsAndConditionsDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			try:
				import requests
				url = str(settings.DRIVER_ACCESS_URL)+"driver/content/getTermsAndConditionsByAdmin/"
				payload={
					'AccessKey':str(settings.DRIVER_ACCESS_KEY),
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getPrivacyPolicyDriver(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			try:
				import requests
				url = str(settings.DRIVER_ACCESS_URL)+"driver/content/getPrivacyPolicyByAdmin/"
				payload={
					'AccessKey':str(settings.DRIVER_ACCESS_KEY),
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def addCustomerFAQ(question,answer):
	response={}
	try:
		import requests
		url = str(settings.CUSTOMER_ACCESS_URL)+"customer/content/addFAQ/"
		payload={
			'AccessKey':str(settings.CUSTOMER_ACCESS_KEY),
			'question':question,
			'answer':answer,
		}
		res = requests.request("POST", url, data=payload)
		print(res)
		return res.json()
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response

def addCompanyFAQ(question,answer):
	response={}
	try:
		import requests
		url = str(settings.COMPANY_ACCESS_URL)+"company/content/addFAQ/"
		payload={
			'AccessKey':str(settings.COMPANY_ACCESS_KEY),
			'question':question,
			'answer':answer,
		}
		res = requests.request("POST", url, data=payload)
		print(res)
		return res.json()
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response

def addDriverFAQ(question,answer):
	response={}
	try:
		import requests
		url = str(settings.DRIVER_ACCESS_URL)+"driver/content/addFAQ/"
		payload={
			'AccessKey':str(settings.DRIVER_ACCESS_KEY),
			'question':question,
			'answer':answer,
		}
		res = requests.request("POST", url, data=payload)
		print(res)
		return res.json()
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response

class addFAQ(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('question'):
				response['status_code']=400
				response['status_message']='question required'
				return Response(response)
			if not data.get('answer'):
				response['status_code']=400
				response['status_message']='answer required'
				return Response(response)
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='userType required'
				return Response(response)
			
			if data.get('userType')=='Customer':
				res=addCustomerFAQ(data.get('question'),data.get('answer'))
				return Response(res)
			elif data.get('userType')=='Company':
				res=addCompanyFAQ(data.get('question'),data.get('answer'))
				return Response(res)
			elif data.get('userType')=='Driver':
				res=addDriverFAQ(data.get('question'),data.get('answer'))
				return Response(res)
			else:
				response['status_code']=400
				response['status_message']='Invalid user type'
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def getCustomerFAQList():
	response={}
	try:
		import requests
		url = str(settings.CUSTOMER_ACCESS_URL)+"customer/content/getFAQlist/"
		payload={
			'AccessKey':str(settings.CUSTOMER_ACCESS_KEY),
		}
		res = requests.request("POST", url, data=payload)
		print(res)
		return res.json()
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response

def getCompanyFAQList():
	response={}
	try:
		import requests
		url = str(settings.COMPANY_ACCESS_URL)+"company/content/getFAQlist/"
		payload={
			'AccessKey':str(settings.COMPANY_ACCESS_KEY),
		}
		res = requests.request("POST", url, data=payload)
		print(res)
		return res.json()
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response

def getDriverFAQList():
	response={}
	try:
		import requests
		url = str(settings.DRIVER_ACCESS_URL)+"driver/content/getFAQlist/"
		payload={
			'AccessKey':str(settings.DRIVER_ACCESS_KEY),
		}
		res = requests.request("POST", url, data=payload)
		print(res)
		return res.json()
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response
	


class getFAQlist(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='userType required'
				return Response(response)

			if data.get('userType')=='Customer':
				res=getCustomerFAQList()
				return Response(res)
			elif data.get('userType')=='Company':
				res=getCompanyFAQList()
				return Response(res)
			elif data.get('userType')=='Driver':
				res=getDriverFAQList()
				return Response(res)
			else:
				response['status_code']=400
				response['status_message']='Invalid user type'
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class updateFAQ(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('faqID'):
				response['status_code']=400
				response['status_message']='faqID required'
				return Response(response)
			payload={}
			
			if data.get('question'):
				payload['question']=data.get('question')
			if data.get('answer'):
				payload['answer']=data.get('answer')
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='userType required'
				return Response(response)
			if data.get('userType')=='Customer':
				payload['AccessKey']=str(settings.CUSTOMER_ACCESS_KEY)
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/content/updateFAQ/"
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			elif data.get('userType')=='Company':
				payload['AccessKey']=str(settings.COMPANY_ACCESS_KEY)
				import requests
				url = str(settings.COMPANY_ACCESS_URL)+"company/content/updateFAQ/"
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			elif data.get('userType')=='Driver':
				payload['AccessKey']=str(settings.DRIVER_ACCESS_KEY)
				import requests
				url = str(settings.DRIVER_ACCESS_URL)+"driver/content/updateFAQ/"
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			else:
				response['status_code']=400
				response['status_message']='Invalid user type'
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def deleteCustomerFAQ(faqID):
	response={}
	try:
		import requests
		url = str(settings.CUSTOMER_ACCESS_URL)+"customer/content/deleteFAQ/"
		payload={
			'AccessKey':str(settings.CUSTOMER_ACCESS_KEY),
			'faqID':faqID,
		}
		res = requests.request("POST", url, data=payload)
		print(res)
		return res.json()
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response

def deleteCompanyFAQ(faqID):
	response={}
	try:
		import requests
		url = str(settings.COMPANY_ACCESS_URL)+"company/content/deleteFAQ/"
		payload={
			'AccessKey':str(settings.COMPANY_ACCESS_KEY),
			'faqID':faqID,
		}
		res = requests.request("POST", url, data=payload)
		print(res)
		return res.json()
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response


def deleteDriverFAQ(faqID):
	response={}
	try:
		import requests
		url = str(settings.DRIVER_ACCESS_URL)+"driver/content/deleteFAQ/"
		payload={
			'AccessKey':str(settings.DRIVER_ACCESS_KEY),
			'faqID':faqID,
		}
		res = requests.request("POST", url, data=payload)
		print(res)
		return res.json()
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response

class deleteFAQ(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('faqID'):
				response['status_code']=400
				response['status_message']='faqID required'
				return Response(response)
			
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='userType required'
				return Response(response)
			
			if data.get('userType')=='Customer':
				res=deleteCustomerFAQ(data.get('faqID'))
				return Response(res)
			elif data.get('userType')=='Company':
				res=deleteCompanyFAQ(data.get('faqID'))
				return Response(res)
			elif data.get('userType')=='Driver':
				res=deleteDriverFAQ(data.get('faqID'))
				return Response(res)
			else:
				response['status_code']=400
				response['status_message']='Invalid user type'
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getSettings(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			
			import requests
			url = str(settings.CUSTOMER_ACCESS_URL)+"customer/backend/setDriverCharges/"
			res = requests.request("GET", url)
			res = res.json()
			if res['status_code']==200:
				response['charges']=res['charges']
			else:
				response['charges']=0
			
			url2 = str(settings.STORE_ACCESS_URL)+"store/set/setRadius/"
			res2 = requests.request("GET", url2)
			res2 = res2.json()
			if res2['status_code']==200:
				response['radius']=res2['radius']
			else:
				response['radius']=0
			appObject=appinfo.objects.all().last()
			if appObject:
				theSerialData=GetAppInfoData(appObject)
				response['appInfo']=theSerialData.data
			else:
				response['appInfo']=[]
			response['status_code']=200
			response['status_message']='Settings data'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addAppInfo(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='email required'
				return Response(response)

			if not data.get('contactno'):
				response['status_code']=400
				response['status_message']='contactno required'
				return Response(response)
			
			if not data.get('address'):
				response['status_code']=400
				response['status_message']='address required'
				return Response(response)
			
			if not data.get('country'):
				response['status_code']=400
				response['status_message']='country required'
				return Response(response)

			if not data.get('state'):
				response['status_code']=400
				response['status_message']='state required'
				return Response(response)
			
			if not data.get('city'):
				response['status_code']=400
				response['status_message']='city required'
				return Response(response)
			
			appObject=appinfo.objects.all().last()
			if not appObject:
				appObject=appinfo.objects.create(email=data.get('email'))
			else:
				appObject.email=data.get('email')
			appObject.contactno=data.get('contactno')
			appObject.address=data.get('address')
			appObject.country=data.get('country')
			appObject.state=data.get('state')
			appObject.city=data.get('city')
			appObject.save()

			response['status_code']=200
			response['status_message']='App info added'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString
	
def uploadDocumentImages(image,bucket,thePath):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			print("==================================filetype===========",filetype)
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+str(filetype)
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

class freeItem(APIView):
	response={}
	def get(self,request):
		try:
			import requests
			url = str(settings.CUSTOMER_ACCESS_URL)+"customer/store/addFreeItem/"
			resd = requests.request("GET", url)
			resd = resd.json()
			# print(response.text)
			return Response(resd)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			
			if not data.get('name'):
				response['status_code']=400
				response['status_message']='name required'
				return Response(response)

			if not request.FILES.get('image'):
				response['status_code']=400
				response['status_message']='image required'
				return Response(response)
			filename=''
			image=request.FILES.get('image')
			if image:
				filename=uploadDocumentImages(image,'cannabiscustomer','documents')

			try:
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/store/addFreeItem/"
				payload={'name': data.get('name'),
						'image':filename,
				'AccessKey': str(settings.CUSTOMER_ACCESS_KEY)}
				resd = requests.request("POST", url, data=payload)
				resd = resd.json()
				# print(response.text)
				return Response(resd)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class checkStateIsValid(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('stateName'):
				response['status_code']=400
				response['status_message']='stateName required'
				return Response(response)

			if not data.get('countryName'):
				response['status_code']=400
				response['status_message']='countryName required'
				return Response(response)
			
			countryOBJ=country.objects.filter(country=data.get('countryName')).first()
			if not countryOBJ:
				response['status_code']=400
				response['status_message']='Currently we are not providing services in '+str(data.get('countryName'))
				return Response(response)
			stateOBJ=state.objects.filter(country=countryOBJ,state=data.get('stateName')).first()
			if not stateOBJ:
				response['status_code']=400
				response['status_message']='Currently we are not providing services in '+str(data.get('stateName'))
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class createNotification(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			adminObjects=theadmin.objects.all().first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Admin not found'
				return Response(response)
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='userType is required.'
				return Response(response)
			if not data.get('notificationType'):
				response['status_code']=400
				response['status_message']='notificationType is required.'
				return Response(response)
			if not data.get('userID'):
				response['status_code']=400
				response['status_message']='userID is required.'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title is required.'
				return Response(response)
			if not data.get('description'):
				response['status_code']=400
				response['status_message']='description is required.'
				return Response(response)
			notifications.objects.create(userType=data.get('userType'),notificationType=data.get('notificationType'),userID=data.get('userID'),title=data.get('title'),description=data.get('description'))
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class activeInactiveCountry(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if data.get('id'):
				try:
					theCountryOBJ=country.objects.get(id=data.get('id'))
				except Exception as e:
					print(e)
					response['status_code']=400
					response['status_message']='Invalid country id'
					return Response(response)
				if data.get('status'):
					if data.get('status')=='active':
						theCountryOBJ.isdisabled=False
						theCountryOBJ.save()
					elif data.get('status')=='inactive':
						theCountryOBJ.isdisabled=True
						theCountryOBJ.save()
					else:
						pass

					response['status_code']=200
					response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='Country id is required.'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class activeInactiveState(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if data.get('id'):
				try:
					theCountryOBJ=state.objects.get(id=data.get('id'))
				except Exception as e:
					print(e)
					response['status_code']=400
					response['status_message']='Invalid state id'
					return Response(response)
				if data.get('status'):
					if data.get('status')=='active':
						theCountryOBJ.isdisabled=False
						theCountryOBJ.save()
					elif data.get('status')=='inactive':
						theCountryOBJ.isdisabled=True
						theCountryOBJ.save()
					else:
						pass

					response['status_code']=200
					response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='State id is required.'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class activeInactiveDistrict(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if data.get('id'):
				try:
					theCountryOBJ=district.objects.get(id=data.get('id'))
				except Exception as e:
					print(e)
					response['status_code']=400
					response['status_message']='Invalid district id'
					return Response(response)
				if data.get('status'):
					if data.get('status')=='active':
						theCountryOBJ.isdisabled=False
						theCountryOBJ.save()
					elif data.get('status')=='inactive':
						theCountryOBJ.isdisabled=True
						theCountryOBJ.save()
					else:
						pass

					response['status_code']=200
					response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='District id is required.'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class activeInactiveQuantitiy(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if data.get('id'):
				try:
					theCountryOBJ=quantities.objects.get(id=data.get('id'))
				except Exception as e:
					print(e)
					response['status_code']=400
					response['status_message']='Invalid quantity id'
					return Response(response)
				if data.get('status'):
					if data.get('status')=='active':
						theCountryOBJ.isdisabled=False
						theCountryOBJ.save()
					elif data.get('status')=='inactive':
						theCountryOBJ.isdisabled=True
						theCountryOBJ.save()
					else:
						pass

					response['status_code']=200
					response['status_message']='Success'
			else:
				response['status_code']=400
				response['status_message']='Quantity id is required.'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addChatBotNewQuestion(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='Access Key is required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			if not data.get('question'):
				response['status_code']=400
				response['status_message']='question required'
				return Response(response)
			theQuestionObject=chatbotquestions.objects.filter(question=data.get('question')).first()
			if not theQuestionObject:
				chatbotquestions.objects.create(question=data.get('question'))
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getChatBotNewQuestions(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			allChatQuestions=chatbotquestions.objects.all()
			for obj in allChatQuestions:
				allData.append({'question':obj.question,
								'answer':obj.answer,
								'id':obj.id,})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addChatBotAnswerToAQuestion(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if not data.get('id'):
				response['status_code']=400
				response['status_message']='id is required'
				return Response(response)
			if not data.get('answer'):
				response['status_code']=400
				response['status_message']='answer is required'
				return Response(response)
			theObject=chatbotquestions.objects.filter(id=data.get('id')).first()
			if theObject:
				theObject.answer=data.get('answer')
				theObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getChatBotNewQuestionsToTrain(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='Access Key is required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			allChatQuestions=chatbotquestions.objects.all()
			for obj in allChatQuestions:
				if obj.answer != '':
					allData.append({'question':obj.question,
									'answer':obj.answer,
									'id':obj.id,})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class deleteTheAddedQuestion(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='Access Key is required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			
			print("DELETEING THE API")
			theDeleteData=data.get('theDeleteData')
			if theDeleteData:
				print(theDeleteData)
				for theID in theDeleteData:
					print(theID)
					theObj=chatbotquestions.objects.filter(id=int(theID)).first()
					if theObj:
						print("OBJECT FIND")
						theObj.delete()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class deleteAQuestion(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if not data.get('id'):
				response['status_code']=400
				response['status_message']='id is required'
				return Response(response)
			try:
				theObject=chatbotquestions.objects.get(id=data.get('id'))
				theObject.delete()
			except Exception as e:
				response['status_code']=400
				response['status_message']='Invalid id'
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

#old One
# class addCategory(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			if not data.get('session_token'):
# 				response['status_code']=400
# 				response['status_message']='session_token required'
# 				return Response(response)
# 			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
# 			if not adminObjects:
# 				response['status_code']=401
# 				response['status_message']='Invalid token'
# 				return Response(response)
# 			if not data.get('categoryName'):
# 				response['status_code']=400
# 				response['status_message']='name required'
# 				return Response(response)

# 			if not request.FILES.get('categoryImage'):
# 				response['status_code']=400
# 				response['status_message']='image required'
# 				return Response(response)
			
# 			import requests
# 			filename=''
# 			image=request.FILES.get('categoryImage')
# 			if image:
# 				filename=uploadDocumentImages(image,'cannabisadmin','category')
# 			url = str(settings.STORE_ACCESS_URL)+"store/products/addCategory/"
# 			payload={
# 				'categoryName':data.get('categoryName'),
# 				'categoryImage':filename,
# 			}
# 			print('payload',payload)
# 			res = requests.request("POST", url, data=payload)
# 			print(res)
# 			return Response(res.json())
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)

#New one
class addCategory(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if not data.get('categoryName'):
				response['status_code']=400
				response['status_message']='categoryName required'
				return Response(response)
			if not data.get('categoryImage'):
				response['status_code']=400
				response['status_message']='categoryImage required'
				return Response(response)
			name3LetterGift='CAT'
			
			latExtGift=thecategory.objects.all().last()
			if latExtGift:
				lastGiftId=latExtGift.categoryId
				last5NumberGift=lastGiftId[3:]
				last5NumberGift=int(last5NumberGift)
				new5NumberGift=last5NumberGift+1
				new5NumberGift=str(new5NumberGift)
				new5NumberGift = new5NumberGift.zfill(5)
				theUniqueIDGift=str(name3LetterGift)+str(new5NumberGift)
			else:
				theUniqueIDGift=str(name3LetterGift)+str('00001')
			alreadyObj=thecategory.objects.filter(categoryName=data.get('categoryName'))
			if not alreadyObj:
				theCategory=thecategory.objects.create(categoryId=theUniqueIDGift,categoryName=data.get('categoryName'))
				filename=''
				image=request.FILES.get('categoryImage')
				if image:
					filename=uploadDocumentImages(image,'cannabisadmin','category')
				theCategory.categoryImage=filename
				theCategory.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)
#new one
class updateCategory(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			# alreadyObj=thecategory.objects.filter(categoryName=data.get('categoryName'))
			theCatObject=thecategory.objects.filter(categoryId=data.get('categoryId')).first()
			if theCatObject:
				if data.get('categoryName'):theCatObject.categoryName=data.get('categoryName')
				image=request.FILES.get('categoryImage')
				if image:
					filename=uploadDocumentImages(image,'cannabisadmin','category')
					theCatObject.categoryImage=filename
				theCatObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getCategoryList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			theCatObject=thecategory.objects.all()
			for obj in theCatObject:
				theData=GetCategoryData(obj).data
				response['status_code']=200
				response['status_message']='Success'
				allData.append(theData)
				response['data'] = allData
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getActiveCategoryList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allData=[]
			theCatObject=thecategory.objects.filter(isdisabled=False)
			for obj in theCatObject:
				theData=GetCategoryData(obj).data
				response['status_code']=200
				response['status_message']='Success'
				allData.append(theData)
				response['data'] = allData
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)



#old one
# class updateCategory(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			if not data.get('session_token'):
# 				response['status_code']=400
# 				response['status_message']='session_token required'
# 				return Response(response)
# 			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
# 			if not adminObjects:
# 				response['status_code']=401
# 				response['status_message']='Invalid token'
# 				return Response(response)
			
# 			import requests
# 			# filename=''
# 			# image=request.FILES.get('categoryImage')
# 			# if image:
# 			# 	filename=uploadDocumentImages(image,'cannabisadmin','category')
# 			url = str(settings.STORE_ACCESS_URL)+"store/products/updateCategory/"
# 			payload={
# 				'categoryName':data.get('categoryName'),
# 				'categoryImage':request.FILES.get('categoryImage'),
# 				'categoryId':data.get('categoryId')
# 			}
# 			print('payload',payload)
# 			res = requests.request("POST", url, data=payload)
# 			print(res)
# 			return Response(res.json())
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)

# class getCategoryList(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
# 			if not data.get('session_token'):
# 				response['status_code']=400
# 				response['status_message']='session_token required'
# 				return Response(response)
# 			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
# 			if not adminObjects:
# 				response['status_code']=401
# 				response['status_message']='Invalid token'
# 				return Response(response)
			
# 			import requests
# 			url = str(settings.STORE_ACCESS_URL)+"store/products/getCategoryList/"
# 			res = requests.request("GET", url)
# 			print(res.json())
# 			return Response(res.json())
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)

class enableDisableCategory(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid token'
				return Response(response)
			if not data.get('categoryId'):
				response['status_code']=400
				response['status_message']='categoryId required'
				return Response(response)
			if not data.get('status'):
				response['status_code']=400
				response['status_message']='status required'
				return Response(response)
			theCatObject=thecategory.objects.filter(categoryId=data.get('categoryId')).first()
			if not theCatObject:
				response['status_code']=401
				response['status_message']='Invalid categoryId'	
			if data.get('status'):
				if data.get('status')=='active':
					theCatObject.isdisabled=False
					theCatObject.save()
				elif data.get('status')=='inactive':
					theCatObject.isdisabled=True
					theCatObject.save()
				else:
					pass
				response['status_code']=200
				response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)
#old one
# class enableDisableCategory(APIView):
# 	def post(self, request, *args, **kwargs):
# 		response={}
# 		try:
# 			data=request.data
			# if not data.get('session_token'):
			# 	response['status_code']=400
			# 	response['status_message']='session_token required'
			# 	return Response(response)
			# adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			# if not adminObjects:
			# 	response['status_code']=401
			# 	response['status_message']='Invalid token'
			# 	return Response(response)
			
# 			import requests
# 			url = str(settings.STORE_ACCESS_URL)+"store/products/enableDisableCategory/"
# 			payload={
# 				'status':data.get('status'),
# 				'categoryId':data.get('categoryId')
# 			}
# 			res = requests.request("POST", url, data=payload)
# 			print(res)
# 			return Response(res.json())
# 		except Exception as e:
# 			print(e)
# 			response['status_code']=500
# 			response['status_message']=str(e)
# 		return Response(response)

class getQuantitiesForOthersCategorySearch(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('categoryId'):
				response['status_code']=400
				response['status_message']='categoryId required'
				return Response(response)
			allCategory = thecategory.objects.filter(categoryId=data.get('categoryId')).first()
			print('allCategory',allCategory)
			allQuantities=quantities.objects.filter(category=allCategory)
			print('allQuantities',allQuantities)
			allData = []
			for quan in allQuantities:
				theData=GetQuantitesData(quan).data
				allData.append(theData)
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
			# allQuantities=quantities.objects.filter(category=data.get('categoryId'))
			# theData=GetQuantitesData(allQuantities,many=True)
			# response['data']=theData.data
			# response['status_code']=200
			# response['status_message']='Success'
			# return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)