from django.db import models
import random  
import string
from django.contrib.auth.models import User
from django.contrib.auth.models import AbstractUser
from django.utils.translation import gettext as _

class theadmin(models.Model):
	"""
	This model is used to store the information of Customer.
	"""
	userTableID = models.CharField(max_length = 100, null = True, blank = True)
	userUUID = models.CharField(max_length = 200, null = True, blank = True)
	token = models.CharField(max_length = 200, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 100, null = True, blank = True)
	totalsubscriptionearning = models.CharField(max_length = 100,default='0.0',blank = True)
	name = models.CharField(max_length = 100, null = True, blank = True)
	email = models.CharField(max_length = 100, unique = True, null = True, blank = True)
	countrycode = models.CharField(max_length = 100, null = True, blank = True)
	phone = models.CharField(max_length = 100, blank = True, null = True)
	image = models.FileField(upload_to='Profile/', blank = True, null = True)
	fcmtoken = models.CharField(max_length = 300, blank = True, null = True)
	signupOtp = models.CharField(max_length = 100, blank = True, null = True)
	signupOtpVerfied = models.BooleanField(default = False)
	emailverificationlink = models.CharField(max_length = 300, blank = True, null = True)
	emailverified = models.BooleanField(default = False)
	phoneVerifiedOtp = models.CharField(max_length = 100, blank = True, null = True)
	phoneverified = models.BooleanField(default = False)
	socialId = models.CharField(max_length = 300, blank = True, null = True)
	deviceId = models.CharField(max_length = 300, blank = True, null = True)
	deviceType = models.CharField(max_length = 300, blank = True, null = True)
	registerType = models.CharField(max_length = 300, blank = True, null = True)
	userReferalCode = models.CharField(max_length = 300, blank = True, null = True)
	referalByCode = models.CharField(max_length = 300, blank = True, null = True)
	forgotPasswordOTP = models.CharField(max_length=100,blank=True,null=True)
	accountverified = models.BooleanField(default = False)
	accountapproved = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.name)+'-'+str(self.userUniqueID))

class notifications(models.Model):
	image = models.CharField(max_length = 200, blank = True,default = '')
	userType = models.CharField(max_length = 200, blank = True,default = '')
	notificationType = models.CharField(max_length = 200, blank = True,default = '')
	userID = models.CharField(max_length = 200, blank = True,default = '')
	title = models.CharField(max_length = 50, blank = True,default = '')
	description = models.TextField(null = True, blank = True)
	created_at = models.DateField(auto_now_add = True)

	def __str__(self):
		return str(str(self.title)+'-'+str(self.userID))

class adminearning(models.Model):
	"""
	This model is used to store the information of admin subscription earning.
	"""
	earn = models.CharField(max_length = 100,default='0.0',blank = True)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.earn)+'-'+str(self.created_at))

PAYOUT_USER_TYPE = (
    ("Company", "Company"),
    ("Driver", "Driver"),
)

PAYOUT_STATUS = (
    ("Pending", "Pending"),
    ("Accepted", "Accepted"),
	("Rejected", "Rejected"),
)

class payoutStripeId(models.Model):
	payoutUserId = models.CharField(max_length = 50, blank = True,default = '')
	stripeAccountID = models.CharField(max_length = 100, blank = True,default = '')
	cardId = models.CharField(max_length = 100, blank = True,default = '')
	isComplete = models.BooleanField(default = False)
	debitCardAdded = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.payoutUserId)+'-'+str(self.stripeAccountID))

class payoutrequest(models.Model):
	payoutUserType = models.CharField(max_length = 20,choices = PAYOUT_USER_TYPE,default = 'Company')
	payoutUserId = models.CharField(max_length = 50, blank = True,default = '')
	payoutUserName = models.CharField(max_length = 50, blank = True,default = '')
	payoutUserEmail = models.CharField(max_length = 50, blank = True,default = '')
	payoutUserImage = models.CharField(max_length = 200, blank = True,default = '')
	payoutAmount = models.CharField(max_length = 50, blank = True,default = '')
	isAccepted = models.BooleanField(default = False)
	payoutStatus = models.CharField(max_length = 20,choices=PAYOUT_STATUS,default = 'Pending')
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.payoutUserType)+'-'+str(self.payoutAmount))