from rest_framework import serializers
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token

class GetadminData(serializers.ModelSerializer):
	image =  serializers.SerializerMethodField(source='get_image')

	class Meta:
		model = theadmin
		fields = ['token','userUniqueID', 'name', 'email','phone','countrycode','socialId','image','phoneverified','userReferalCode']

	def get_image(self, obj):
		return obj.image.name

class GetNotificationsData(serializers.ModelSerializer):

	class Meta:
		model = notifications
		fields = ['id','image','userType','notificationType','userID', 'title','description','created_at']