from django.contrib import admin
from django.urls import path
from django.conf.urls import url, include
from django.views.static import serve
from django.conf import settings
from django.conf.urls import handler400, handler403, handler404, handler500
from .views import *
from . import views
urlpatterns = [
   url(r'^$',Index, name='index'),
   path('createAdmin/', createAdmin.as_view(), name = 'createAdmin'),
   path('login/', Login.as_view(), name = 'Login'),
   path('forgotPassword/', forgotPassword.as_view(), name = 'forgotPassword'),
   url(r'^checkAuthentication/$', checkAuthentication.as_view(), name='checkAuthentication'),
   url(r'^forgotPasswordVerifyOtp/$', forgotPasswordVerifyOtp.as_view(), name='forgotPasswordVerifyOtp'),
   url(r'^updatePassword/$', updatePassword.as_view(), name='updatePassword'),
   url(r'^getProfile/$', getProfile.as_view(), name='getProfile'),
   url(r'^updateProfile/$', updateProfile.as_view(), name='updateProfile'),
   url(r'^changePassword/$', changePassword.as_view(), name='changePassword'),
   url(r'^logout/$', logout.as_view(), name='logout'),
   path('adminNotify/',adminNotify.as_view()),
   path('getNotifications/',getNotifications.as_view()),
   path('deleteNotification/',deleteNotification.as_view()),
   path('deleteNotificationList/',deleteNotificationList.as_view()),
   path('getComapniesEarning/',getComapniesEarning.as_view()),
   path('getDriversEarning/',getDriversEarning.as_view()),
   path('addPayoutRequests/',addPayoutRequests.as_view()),
   url(r'detailsSubmit/(?P<theId>[\w\-]+)/$',detailsSubmit.as_view(),),
   url(r'^getAllPayoutList/$', getAllPayoutList.as_view(), name='getAllPayoutList'),
   url(r'^acceptPayoutRequest/$', acceptPayoutRequest.as_view(), name='acceptPayoutRequest'),
   url(r'^rejectPayoutRequest/$', rejectPayoutRequest.as_view(), name='rejectPayoutRequest'),
   path('linkPayoutAccount/',linkPayoutAccount.as_view()),
   path('getStripeLoginLinkInCompany/',getStripeLoginLinkInCompany.as_view()),
   path('addDebitCart/',addDebitCart.as_view()),
   path('deleteDebitCart/',deleteDebitCart.as_view()),
   path('checkButtonStatus/',checkButtonStatus.as_view()),
   
   #url for superadmin filterNotification by johan bhatt
   path('filterNotifications/',filterNotifications.as_view()),



]
