from rest_framework.views import APIView
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .models import *
import math, random, datetime, pytz, string
from django.conf import settings
import requests, json
from django.contrib.auth.hashers import make_password
from django.db.models import Q
from .serializers import *
from django.http import HttpResponse, response
from rest_framework.response import Response
from django.contrib.auth import authenticate, login
from django.core.files.storage import FileSystemStorage
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import datetime

import boto
import boto.exception
import boto.sns
import pprint
import re

def setTokenInCustomer(token):
	url = str(settings.CUSTOMER_ACCESS_URL)+'customer/backend/adminLoginToken/'
	payload={'AccessKey': token}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	print("====================Customer==============",r)
	return r['status_code']

def setTokenInCompany(token):
	url = str(settings.COMPANY_ACCESS_URL)+"company/backend/adminLoginToken/"
	payload={'AccessKey': token}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	print("====================Company==============",r)
	return r['status_code']

def setTokenInDriver(token):
	url = str(settings.DRIVER_ACCESS_URL)+'driver/backend/adminLoginToken/'
	payload={'AccessKey': token}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	print("====================Driver==============",r)
	return r['status_code']

def setTokenInAdminHelpSupport(token):
	url = str(settings.AHS_ACCESS_URL)+'superadmin/support/auth/adminLoginToken/'
	payload={'AccessKey': token}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	print("====================Driver==============",r)
	return r['status_code']

def setTokenInCompanyHelpSupport(token):
	url = str(settings.CHS_ACCESS_URL)+'company/support/auth/adminLoginToken/'
	payload={'AccessKey': token}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	print("====================Driver==============",r)
	return r['status_code']

def setTokenInStore(token):
	url = str(settings.STORE_ACCESS_URL)+'store/set/adminLoginToken/'
	payload={'AccessKey': token}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	print("====================Store==============",r)
	return r['status_code']

def Index(request):
	return HttpResponse("<h4>Admin Basic Details</h4>")

def referralCode():
	try:
		Referal=''
		digits2 = "rba2cqq4skyhz7meizjk"
		for i in range(8): 
		  Referal += digits2[math.floor(random.random() * 15)]
		print(Referal)
	except Exception as e:
		print(e)
	return str(Referal)

def GernateOTP():
	digits = "0123456789"
	OTP = ""
	for i in range(4) :
		OTP += digits[math.floor(random.random() * 10)]
	return OTP

def randomStringFunction():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

class createAdmin(APIView):
	def post(self, request, *args, **kwargs):
		data=request.data
		who = request.POST.get('who')
		response={}
		if who!='Manpreet':
			response['status_code']=400
			response['status_message']='You have no authority to create user'
			return Response(response)
		try:
			userOBJ = User.objects.filter(username = data['email']).first()
			if userOBJ:
				response['status_code']=400
				response['status_message']='Email already exist.'
				return Response(response)
			userOBJ = User.objects.create_user(username = data['email'], password = data['password'])
			userObjId=userOBJ.id
			adminObj = theadmin.objects.create(userUniqueID=randomStringFunction(),userTableID=userObjId, name = data['name'],email = data['email'],registerType='Normal')
			response['status_code']=400
			response['status_message']='Sucessfully registerd'
			return Response(response)
		except Exception as e:
			response['status_code']=400
			response['status_message']=str(e)
			return Response(response)

def getToken(obj):
	userObject=User.objects.filter(id=obj.userTableID).first()
	token,status = Token.objects.get_or_create(user = userObject)
	tokenKey=token.key
	return tokenKey

class Login(APIView):

	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)
			
			if not data.get('fcmtoken'):
				fcmtoken=''
			else:
				fcmtoken=data.get('fcmtoken')
			
			if not data.get('deviceType'):
				deviceType=''
			else:
				deviceType=data.get('deviceType')

			user = authenticate(username = data.get('email'), password = data.get('password'))
			if not user:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			adminObjects=theadmin.objects.filter(userTableID=user.id).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			# payload = jwt_payload_handler(user)
			# token = jwt.encode(payload, settings.SECRET_KEY)
			# login(request, user)
			# if user is not None:
			# 	token= Token.objects.filter(user = user).first()
			# 	if token:
			# 		user.auth_token.delete()
			theToken=getToken(adminObjects)
			adminObjects.token=theToken
			adminObjects.fcmtoken=fcmtoken
			adminObjects.deviceType=deviceType
			adminObjects.save()
			theData=GetadminData(adminObjects)
			response['status_code']=200
			response['status_message']='Sucessfully login'
			response['data']=theData.data

			print(response['data']['token'])

			try:
				theResponse=setTokenInCompany(response['data']['token'])
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
			except Exception as e:
				print(e)

			try:
				theResponse=setTokenInCustomer(response['data']['token'])
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
			except Exception as e:
				print(e)

			try:
				theResponse=setTokenInDriver(response['data']['token'])
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
			except Exception as e:
				print(e)
			
			try:
				theResponse=setTokenInAdminHelpSupport(response['data']['token'])
				# if theResponse!=200:
				# 	response['status_code']=400
				# 	response['status_message']='Oops! Something went wrong'
			except Exception as e:
				print(e)
			
			try:
				theResponse=setTokenInCompanyHelpSupport(response['data']['token'])
				# if theResponse!=200:
				# 	response['status_code']=400
				# 	response['status_message']='Oops! Something went wrong'
			except Exception as e:
				print(e)

			# theResponse=setTokenInAdminHelpSupport(response['data']['token'])
			# if theResponse!=200:
			# 	response['status_code']=400
			# 	response['status_message']='Oops! Something went wrong'

			try:
				theResponse=setTokenInStore(response['data']['token'])
				if theResponse!=200:
					response['status_code']=400
					response['status_message']='Oops! Something went wrong'
			except Exception as e:
				print(e)

			

		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class forgotPassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObj = theadmin.objects.filter(email = data.get('email')).first()
			if not adminObj:
				response['status_code']=400
				response['status_message']='Email not exist'
				return Response(response)
			OTP=GernateOTP()
			adminObj.forgotPasswordOTP=OTP
			adminObj.save()
			response['status_code']=200
			response['status_message']='OTP send'
			response['OTP']=OTP
			try:
				subject='Forgot Password'
				message = render_to_string('forgotPasswordAdmin.html', {
					'name': adminObj.name,
					'otp': OTP,
				})
				from_email = settings.EMAIL_HOST_USER
				to_email = data.get('email')
				message = EmailMessage(subject, message, from_email, [to_email])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPasswordVerifyOtp(APIView):

	def post(self, request, *args, **kwargs):
		response={}
		try:
			response['status_code']=200
			response['status_message']='OTP verified'
			data=request.data
			adminObj = theadmin.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
			if not adminObj:
				response['status_code']=400
				response['status_message']='Verification Failed, OTP not matched'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class updatePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObj = theadmin.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
			if not adminObj:
				response['status_code']=400
				response['status_message']='invalid otp.'
				return Response(response)
			userObj=User.objects.filter(id=adminObj.userTableID).first()
			userObj.set_password(data['password'])
			userObj.save()
			response['status_code']=200
			response['status_message']='Password Update Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

def unique_filename(instance, filename):
    path = 'app_images'
    filetype = os.path.splitext(instance.image.name)[1]
    new_filename = "{}{}".format(uuid.uuid4().hex, filetype)
    while AppImage.objects.filter(image__contains=new_filename).exists():
        new_filename = "{}{}".format(uuid.uuid4().hex, filetype)
    instance.filename = filename
    return os.path.join(path, new_filename)

# def uploadImage(image):
# 	import os
# 	fs = FileSystemStorage(location='media/Profile/')
# 	beforename = os.path.splitext(image.name)[0]
# 	filetype = os.path.splitext(image.name)[1]
# 	beforename=beforename.replace(' ','')
# 	theName=randomStringFunctionForImage()
# 	theImageName=str(theName)+str(filetype)
# 	filename = fs.save(theImageName, image)
# 	# filename = fs.url(filename)
# 	return str('/Profile/')+filename

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def uploadImage(image):
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		bucket=str(settings.AWS_BUCKET_NAME)
		thePath='Profile'
		thePath=thePath.lower()
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
					  aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''


class getProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# userID=validateToken(data.get('session_token'))
			# if userID == '0':
			# 	response['status_code']=400
			# 	response['status_message']='Invalid Credentials1'
			# 	return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			theData=GetadminData(adminObjects)
			response['status_code']=200
			response['status_message']='Sucessfully login'
			response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class updateProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# userID=validateToken(data.get('session_token'))
			# if userID == '0':
			# 	response['status_code']=400
			# 	response['status_message']='Invalid Credentials1'
			# 	return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			if data.get('name'):
				adminObjects.name=data.get('name')
			if data.get('phone'):
				adminObjects.phone=data.get('phone')
			if data.get('countrycode'):
				adminObjects.countrycode=data.get('countrycode')
			theImage = request.FILES.get("image")
			if theImage:
				theFilename=uploadImage(theImage)
				if theFilename:
					adminObjects.image.name=theFilename
			adminObjects.save()
			response['status_code']=200
			response['status_message']='Profile update'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class changePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			tokenOBJ = Token.objects.filter(key = data.get('session_token')).first()
			if not tokenOBJ:
				response['status_code']=400
				response['status_message']='Invalid token1'
				return Response(response)
			user = User.objects.get(id = tokenOBJ.user_id)
			if not user:
				response['status_code']=400
				response['status_message']='Invalid token2'
				return Response(response)
			userObj = authenticate(username = user.username, password = data.get('oldPassword'))
			# userObj=User.objects.filter(id=adminObj.userTableID).first()
			userObj.set_password(data['newPassword'])
			userObj.save()
			response['status_code']=200
			response['status_message']='Password Update Successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class logout(APIView):
	def post(self, request, *args, **kwargs):
		try:
			data=request.data
			response={}
			tokenOBJ = Token.objects.filter(key = data.get('session_token')).first()
			if not tokenOBJ:
				response['status_code']=400
				response['status_message']='Invalid Session Token'
			userOBJ = User.objects.get(id = tokenOBJ.user_id)
			companyOBJ = theadmin.objects.filter(userTableID = userOBJ.id).first()
			if not companyOBJ:
				response['status_code']=400
				response['status_message']='Not a valid customer'
			else:
				companyOBJ.token=''
				companyOBJ.fcmtoken=''
				companyOBJ.save()
				# userOBJ.auth_token.delete()
				response['status_code']=200
				response['status_message']='Logout successfully'

				# theResponse=setTokenInCompany('LogoutAdmin')
				# if theResponse!=200:
				# 	response['status_code']=400
				# 	response['status_message']='Oops! Something went wrong'

				# theResponse=setTokenInCustomer('LogoutAdmin')
				# if theResponse!=200:
				# 	response['status_code']=400
				# 	response['status_message']='Oops! Something went wrong'

				# theResponse=setTokenInDriver(response['data']['token'])
				# if theResponse!=200:
				# 	response['status_code']=400
				# 	response['status_message']='Oops! Something went wrong'

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class checkAuthentication(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Unauthenticated'
				return Response(response)
			response['status_code']=200
			response['status_message']='Authenticated'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def sendPush(device_id, body):
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	try:
		endpoint_response = sns.create_platform_endpoint(
			platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
			token=device_id,
		)   
		endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
	except boto.exception.BotoServerError as err:
		result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
		result = result_re.search(err.message)
		if result:
			endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
		else:
			raise
	print("ARN:", endpoint_arn)
	publish_result = sns.publish(
		target_arn=endpoint_arn,
		message=json.dumps(body),
		# message_structure='json'
	)
	print("PUBLISH")
	pprint.pprint(publish_result)

class adminNotify(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data

			adminObj = theadmin.objects.all().first()
			
			if not data.get('notifyCheckType'):
				response['status_code']=400
				response['status_message']='notifyCheckType required.'
				return Response(response)
			if not data.get('body'):
				body=''
			else:
				body=data.get('body')
			
			if not data.get('image'):
				image='https://cannabisadmin.s3.amazonaws.com/logo-d+(1).png'
			else:
				image=data.get('image')
			
			if not data.get('notifyType'):
				notifyType=''
			else:
				notifyType=data.get('notifyType')
			
			if not data.get('title'):
				title=''
			else:
				title=data.get('title')

			
			if not data.get('userType'):
				userType=''
			else:
				userType=data.get('userType')
				
			
			if not data.get('userID'):
				userID=''
			else:
				userID=data.get('userID')
			
			messageBody={}
			messageBody['body']=body
			messageBody['icon']=image
			messageBody['image']=image
			messageBody['type']=notifyType
			messageBody['title']=title
			messageBody['userType']=userType
			messageBody['userID']=userID
			
			try:
				notifications.objects.create(userType=messageBody['userType'],notificationType=data.get('notifyCheckType'),userID=messageBody['userID'],title=messageBody['title'],description=messageBody['body'])
				# notifications.objects.create(userType=messageBody['userType'],userID=messageBody['userID'],image=messageBody['data']['image'],title=messageBody['title'],description=messageBody['body'])
				theReturnOfPush=sendPush(adminObj.fcmtoken,messageBody)				
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getNotifications(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			allNotifications=notifications.objects.all()
			theSerialData=GetNotificationsData(allNotifications,many=True)
			response['data']=theSerialData.data
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class deleteNotification(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('id'):
				response['status_code']=400
				response['status_message']='Notification id required'
				return Response(response)
			theNotificationObject=notifications.objects.filter(id=data.get('id')).first()
			if theNotificationObject:
				theNotificationObject.delete()
			else:
				response['status_code']=400
				response['status_message']='Invalid notification id'
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getComapniesEarning(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			try:
				url = str(settings.COMPANY_ACCESS_URL)+"company/backend/getTotalCompanyEarningForAdmin/"
				payload={'AccessKey': str(settings.COMPANY_ACCESS_KEY)}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				print("====================Company==============",r)
				return Response(r)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getDriversEarning(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			try:
				url = str(settings.DRIVER_ACCESS_URL)+"driver/earnings/getDriverEarningDataForAdmin/"
				payload={'AccessKey': str(settings.DRIVER_ACCESS_KEY)}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				print("====================Drivers==============",r)
				return Response(r)
			except Exception as e:
				response['status_code']=500
				response['status_message']=str(e)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def createStripeConnectAccount(userEmail):
	import stripe
	stripe.api_key = "sk_test_51K54oQGZOiEmnLbL5qeXEZ4OUP48eE0Id6o6OMdzyR8CPBS5gBXsxDcUSjVGzPe0yqVCABwK9M8dW79QKRqO6AKs00U60su3Pm"

	theOBJ=stripe.Account.create(
	type="express",
	country="US",
	email=str(userEmail),
	capabilities={
		"card_payments": {"requested": True},
		"transfers": {"requested": True},
	},
	business_type="individual",

	)
	print(theOBJ['id'])
	return theOBJ['id']

def createAccountUrl(accountId,userId):
	import stripe
	stripe.api_key = "sk_test_51K54oQGZOiEmnLbL5qeXEZ4OUP48eE0Id6o6OMdzyR8CPBS5gBXsxDcUSjVGzPe0yqVCABwK9M8dW79QKRqO6AKs00U60su3Pm"

	returnData=stripe.AccountLink.create(
	account=str(accountId),
	refresh_url="https://example.com/reauth",
	# return_url="https://example.com/return",
	return_url="http://18.117.53.164:8001/superadmin/auth/detailsSubmit/"+str(userId)+"/",
	type="account_onboarding",
	)
	print(returnData['url'])

	return returnData['url']


class addPayoutRequests(APIView):

	def post(self,request,*args,**kwargs):
		try:
			response={}
			data=request.data
			
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey is required'
				return Response(response)
			
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You do not have access to this api'
				return Response(response)
			
			if not data.get('payoutUserType'):
				response['status_code']=400
				response['status_message']='payoutUserType is required'
				return Response(response)
			
			if not data.get('payoutUserId'):
				response['status_code']=400
				response['status_message']='payoutUserId is required'
				return Response(response)
			
			if not data.get('payoutUserName'):
				response['status_code']=400
				response['status_message']='payoutUserName is required'
				return Response(response)
			
			if not data.get('payoutUserEmail'):
				response['status_code']=400
				response['status_message']='payoutUserEmail is required'
				return Response(response)
			
			if not data.get('payoutUserImage'):
				response['status_code']=400
				response['status_message']='payoutUserImage is required'
				return Response(response)
			
			if not data.get('payoutAmount'):
				response['status_code']=400
				response['status_message']='payoutAmount is required'
				return Response(response)
			payoutStripeIdObjects=payoutStripeId.objects.filter(payoutUserId=data.get('payoutUserId')).first()
			if not payoutStripeIdObjects:
				returnIdFromStripe=createStripeConnectAccount(data.get('payoutUserEmail'))
				theNewUrl=createAccountUrl(returnIdFromStripe,data.get('payoutUserId'))
				payoutStripeId.objects.create(payoutUserId=data.get('payoutUserId'),stripeAccountID=returnIdFromStripe)
				response['status_code']=400
				response['url']=theNewUrl
				response['status_message']='Please add your bank details'
				return Response(response)
			else:
				if payoutStripeIdObjects.isComplete:
					pass
				else:
					theNewUrl=createAccountUrl(payoutStripeIdObjects.stripeAccountID,payoutStripeIdObjects.payoutUserId)
					response['url']=theNewUrl
					response['status_code']=400
					response['status_message']='Please add your bank details'
					return Response(response)
			oneRequest=payoutrequest.objects.create(payoutUserType=data.get('payoutUserType'),payoutUserId=data.get('payoutUserId'),payoutStatus='Pending').first()
			if not oneRequest:
				payoutrequest.objects.create(payoutUserType=data.get('payoutUserType'),payoutUserId=data.get('payoutUserId'),payoutUserName=data.get('payoutUserName'),payoutUserEmail=data.get('payoutUserEmail'),payoutUserImage=data.get('payoutUserImage'),payoutAmount=data.get('payoutAmount'))
			
			else:
				response['status_code']=401
				response['status_message']='You can only request 1 payout at time.'
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			print(e)
		
		return Response(response)

class detailsSubmit(APIView):
	def get(self, request, *args, **kwargs):
		response={}
		try:
			theId = kwargs['theId']
			thePayObj=payoutStripeId.objects.filter(payoutUserId=theId).first()
			if thePayObj:
				thePayObj.isComplete=True
				thePayObj.save()
			else:
				response['status_code']=400
				response['status_message']='Oops! something went wrong'
				return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getAllPayoutList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			payoutObjects=payoutrequest.objects.all()
			allData=map(lambda x:{'payoutUserType':x.payoutUserType,'payoutUserId':x.payoutUserId,'payoutUserName':x.payoutUserName,'payoutUserEmail':x.payoutUserEmail,'payoutUserImage':x.payoutUserImage,'payoutAmount':x.payoutAmount,'payoutStatus':x.payoutStatus,}, payoutObjects)
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def makePaymentToAccount(userAccount,tamount):
	tamount=int(tamount)*10
	tamount=int(tamount)
	import stripe
	stripe.api_key = "sk_test_51K54oQGZOiEmnLbL5qeXEZ4OUP48eE0Id6o6OMdzyR8CPBS5gBXsxDcUSjVGzPe0yqVCABwK9M8dW79QKRqO6AKs00U60su3Pm"

	stripe.Transfer.create(
	amount=tamount,
	currency="usd",
	destination=str(userAccount),
	transfer_group="ORDER_95",
	)

class acceptPayoutRequest(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			
			if not data.get('payoutUserId'):
				response['status_code']=400
				response['status_message']='payoutUserId is required'
				return Response(response)
			
			payoutObjects=payoutrequest.objects.filter(payoutUserId=data.get('payoutUserId')).first()
			if payoutObjects:
				theStripeDetails=payoutStripeId.objects.filter(payoutUserId=data.get('payoutUserId')).first()
				if theStripeDetails:
					returnedData=makePaymentToAccount(theStripeDetails.stripeAccountID,payoutObjects.payoutAmount)
					payoutObjects.payoutStatus='Accepted'
					payoutObjects.isAccepted=True
					payoutObjects.save()
					response['status_code']=200
					response['status_message']='Success'
					return Response(response)
			response['status_code']=400
			response['status_message']='Oops! something went wrong'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def createAccountLoginUrl(theId):
	import stripe
	stripe.api_key = "sk_test_51K54oQGZOiEmnLbL5qeXEZ4OUP48eE0Id6o6OMdzyR8CPBS5gBXsxDcUSjVGzPe0yqVCABwK9M8dW79QKRqO6AKs00U60su3Pm"

	theObj=stripe.Account.create_login_link(
	str(theId),
	)
	return theObj['url']

class getStripeLoginLinkInCompany(APIView):

	def post(self,request,*args,**kwargs):
		try:
			response={}
			data=request.data
			
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey is required'
				return Response(response)
			
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You do not have access to this api'
				return Response(response)
			if not data.get('payoutUserId'):
				response['status_code']=400
				response['status_message']='payoutUserId is required'
				return Response(response)
				
			theObj=payoutStripeId.objects.filter(payoutUserId=data.get('payoutUserId')).first()
			if theObj:
				theStripeUserId=theObj.stripeAccountID
				loginUrl=createAccountLoginUrl(theStripeUserId)
				response['loginUrl']=loginUrl
			else:
				response['loginUrl']=''
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			print(e)
		return Response(response)

class linkPayoutAccount(APIView):

	def post(self,request,*args,**kwargs):
		try:
			response={}
			data=request.data
			
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey is required'
				return Response(response)
			
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You do not have access to this api'
				return Response(response)
			if not data.get('payoutUserId'):
				response['status_code']=400
				response['status_message']='payoutUserId is required'
				return Response(response)
			
			if not data.get('payoutUserEmail'):
				response['status_code']=400
				response['status_message']='payoutUserEmail is required'
				return Response(response)
			
			payoutStripeIdObjects=payoutStripeId.objects.filter(payoutUserId=data.get('payoutUserId')).first()
			if not payoutStripeIdObjects:
				returnIdFromStripe=createStripeConnectAccount(data.get('payoutUserEmail'))
				theNewUrl=createAccountUrl(returnIdFromStripe,data.get('payoutUserId'))
				payoutStripeId.objects.create(payoutUserId=data.get('payoutUserId'),stripeAccountID=returnIdFromStripe)
				response['status_code']=200
				response['url']=theNewUrl
				response['status_message']='Please add your bank details'
				return Response(response)
			else:
				if payoutStripeIdObjects.isComplete:
					response['url']=''
				else:
					theNewUrl=createAccountUrl(payoutStripeIdObjects.stripeAccountID,payoutStripeIdObjects.payoutUserId)
					response['url']=theNewUrl
					response['status_code']=200
					response['status_message']='Please add your bank details'
					return Response(response)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			print(e)
		return Response(response)

class rejectPayoutRequest(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			
			if not data.get('payoutUserId'):
				response['status_code']=400
				response['status_message']='payoutUserId is required'
				return Response(response)
			
			payoutObjects=payoutrequest.objects.filter(payoutUserId=data.get('payoutUserId')).first()
			if payoutObjects:
				theStripeDetails=payoutStripeId.objects.filter(payoutUserId=data.get('payoutUserId')).first()
				if theStripeDetails:
					payoutObjects.payoutStatus='Rejected'
					payoutObjects.save()
					response['status_code']=200
					response['status_message']='Success'
					return Response(response)
			response['status_code']=400
			response['status_message']='Oops! something went wrong'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def addCardOfConnectedAccount(customerAccId,cardToken):
	import stripe
	stripe.api_key = "sk_test_51K54oQGZOiEmnLbL5qeXEZ4OUP48eE0Id6o6OMdzyR8CPBS5gBXsxDcUSjVGzPe0yqVCABwK9M8dW79QKRqO6AKs00U60su3Pm"

	theObj=stripe.Account.create_external_account(
	str(customerAccId),
	external_account=str(cardToken),
	)

	return theObj['id']

class addDebitCart(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			# if not adminObjects:
			# 	response['status_code']=400
			# 	response['status_message']='Invalid Credentials'
			# 	return Response(response)
			
			if not data.get('payoutUserId'):
				response['status_code']=400
				response['status_message']='payoutUserId is required'
				return Response(response)
			
			if not data.get('cardToken'):
				response['status_code']=400
				response['status_message']='cardToken is required'
				return Response(response)
			
			theStripeDetails=payoutStripeId.objects.filter(payoutUserId=data.get('payoutUserId')).first()
			if theStripeDetails:
				cardId=addCardOfConnectedAccount(theStripeDetails.stripeAccountID,data.get('cardToken'))
				theStripeDetails.cardId=cardId
				theStripeDetails.debitCardAdded=True
				theStripeDetails.save()
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
			response['status_code']=400
			response['status_message']='Oops! something went wrong'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def deleteCardOfConnectedAccount(stripeId,cardId):
	import stripe
	stripe.api_key = "sk_test_51K54oQGZOiEmnLbL5qeXEZ4OUP48eE0Id6o6OMdzyR8CPBS5gBXsxDcUSjVGzPe0yqVCABwK9M8dW79QKRqO6AKs00U60su3Pm"

	stripe.Account.delete_external_account(
	str(stripeId),
	str(cardId),
	)

class deleteDebitCart(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			# if not adminObjects:
			# 	response['status_code']=400
			# 	response['status_message']='Invalid Credentials'
			# 	return Response(response)
			
			if not data.get('cardId'):
				response['status_code']=400
				response['status_message']='cardId is required'
				return Response(response)
			
			theStripeDetails=payoutStripeId.objects.filter(payoutUserId=data.get('payoutUserId'),cardId=data.get('cardId')).first()
			if theStripeDetails:
				cardId=deleteCardOfConnectedAccount(theStripeDetails.stripeAccountID,data.get('cardId'))
				theStripeDetails.cardId=''
				theStripeDetails.debitCardAdded=False
				theStripeDetails.save()
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
			response['status_code']=400
			response['status_message']='Oops! something went wrong'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def getCardFromStripe(accountId,cardId):
	allData={}
	import stripe
	stripe.api_key = "sk_test_51K54oQGZOiEmnLbL5qeXEZ4OUP48eE0Id6o6OMdzyR8CPBS5gBXsxDcUSjVGzPe0yqVCABwK9M8dW79QKRqO6AKs00U60su3Pm"

	theObj=stripe.Account.retrieve_external_account(
	str(accountId),
	str(cardId),
	)
	print(theObj['id'])
	print(theObj['exp_month'])
	print(theObj['exp_year'])
	print(theObj['exp_month'])
	print(theObj['last4'])
	allData['exp_month']=theObj['exp_month']
	allData['exp_year']=theObj['exp_year']
	allData['last4']=theObj['last4']

	return allData

class checkButtonStatus(APIView):

	def post(self,request,*args,**kwargs):
		try:
			response={}
			data=request.data
			
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey is required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You do not have access to this api'
				return Response(response)
			if not data.get('userId'):
				response['status_code']=400
				response['status_message']='userId is required'
				return Response(response)
			if not data.get('userEmail'):
				response['status_code']=400
				response['status_message']='userEmail is required'
				return Response(response)
			
			payoutStripeIdObjects=payoutStripeId.objects.filter(payoutUserId=data.get('userId')).first()
			if payoutStripeIdObjects:
				if payoutStripeIdObjects.isComplete:
					if payoutStripeIdObjects.debitCardAdded:
						allData=getCardFromStripe(payoutStripeIdObjects.stripeAccountID,payoutStripeIdObjects.cardId)
						response['cardData']=allData
						response['debitCardAdded']=True
					else:
						response['cardData']={}
						response['debitCardAdded']=False
					response['accountLinked']=True
					response['status_code']=200
					response['status_message']='Success'
					return Response(response)
				else:
					response['cardData']={}
					response['accountLinked']=False
					response['debitCardAdded']=False
					response['status_code']=200
					response['status_message']='Success'
					return Response(response)
			else:
				response['cardData']={}
				response['accountLinked']=False
				response['debitCardAdded']=False
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
			print(e)
		return Response(response)

class deleteNotificationList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
				
			if not data.get('idlist'):
				response['status_code']=400
				response['status_message']='Notification id required'
				return Response(response)
			theidLists=data.get('idlist')
			for l in theidLists:
				theNotificationObject=notifications.objects.filter(id=l).first()
				if theNotificationObject:
					theNotificationObject.delete()

			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)



#filtering notifications for superadmin by Johan bhatti
class filterNotifications(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			session_token = data.get('session_token')
			if not data.get('session_token'):
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			start_date = data.get('start_date', None)
			end_date = data.get('end_date', None)
			if start_date is not None and start_date != '':
				pass
			else:	
				response['status_code'] = 400
				response['status_message'] = 'start date required'
				return Response(response)
			
			if end_date is None or end_date == '':
				from datetime import timedelta
				end_date = datetime.date.today() + timedelta(days=1)
	
			allNotifications=notifications.objects.filter(created_at__range=(start_date, end_date))
			
			theSerialData=GetNotificationsData(allNotifications,many=True)
			response['data']=theSerialData.data
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

