from os import stat
from django.http import response
from rest_framework.views import APIView
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from base.models import *
import math, random, datetime, pytz, string
from django.conf import settings
import requests, json
from django.db.models import Q
from base.serializers import *
from rest_framework.response import Response
from django.contrib.auth import authenticate, login


import random as r
def otpgen():
    otp=""
    for i in range(4):
        otp+=str(r.randint(1,9))
    print ("Your One Time Password is ")
    print (otp)
    return otp

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
		if user:
			returnId=user.id
	return returnId

class getDashboardData(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			# userID=validateToken(data.get('session_token'))
			# if userID == '0':
			# 	response['status_code']=400
			# 	response['status_message']='Invalid Credentials1'
			# 	return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			theFinalValue=[]
			theSeries=[]
			for a in range(1,12):
				theTemp=otpgen()
				theTemp=int(theTemp)
				theName='Feb'
				theName=str(theName)
				theSeries.append({'value':theTemp,
					              'name':theName,})
			theSeries2=[]
			for a in range(1,12):
				theTemp=otpgen()
				theTemp=int(theTemp)
				theName='Jan'
				theName=str(theName)
				theSeries2.append({'value':theTemp,
					              'name':theName,})

			theFinalValue.append({'name':'Revenue',
				                  'series':theSeries})

			theFinalValue.append({'name':'Profit',
				                  'series':theSeries2})
			# theRides=[]
			# for b in range(1,10):
			# 	theRides.append({'orderID':'ORD4521',
			# 		            'customer':'Manpewwt',
			# 		            'driver':'unkno',
			# 		            'status':'pending',
			# 		            'orderTotal':'455',})
			
			# from datetime import date
			# today = date.today()
			# orderRequests=[]
			# for b in range(1,10):
			# 	orderRequests.append({'orderID':'ORD4521',
			# 			            'customer':'Manpewwt',
			# 			            'date':today,
			# 			            'orderTotal':'455',})

			theEarningSeries=[]
			import datetime as ddd
			import dateutil.relativedelta
			for er in range(0,6):
				d = ddd.datetime.now()
				print(d.month,d.year)
				d2 = d - dateutil.relativedelta.relativedelta(months=er)
				print(d2.month,d2.year)
				theDateValue=d2.strftime("%b, %Y")
				allEarningsObjects=adminearning.objects.filter(Q(created_at__month=d2.month) & Q(created_at__year=d2.year))
				totalEarn=float(0)
				for aeo in allEarningsObjects:
					totalEarn=float(totalEarn)+float(aeo.earn)
				totalEarn="{:.2f}".format(totalEarn)
				theEarningSeries.append({'value':totalEarn,
				                      'name':theDateValue,})
			totalCustomer=0
			theUserSeries=[]
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+'customer/backend/totalCustomer/'
				payload={'AccessKey': data.get('session_token'),}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				totalCustomer=r['count']
				theUserSeries=r['theUserSeries']
			except Exception as e:
				print(e)

			totalCompanies=0
			try:
				url = str(settings.COMPANY_ACCESS_URL)+'company/backend/totalCompanies/'
				payload={'AccessKey': data.get('session_token'),}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				totalCompanies=r['count']
			except Exception as e:
				print(e)

			totalDrivers=0
			try:
				url = str(settings.DRIVER_ACCESS_URL)+'driver/backend/totalDrivers/'
				payload={'AccessKey': data.get('session_token'),}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				totalDrivers=r['count']
			except Exception as e:
				print(e)
			
			totalOrders=0
			totalRevenue=float(0)
			theRides=[]
			orderRequests=[]
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+'customer/order/getOrdersCountForAdmin/'
				payload={'AccessKey': str(settings.CUSTOMER_ACCESS_KEY),}
				apiResponse = requests.request("POST", url,data=payload)
				r=apiResponse.json()
				totalOrders=r['count']
				totalRevenue=r['totalOrderEarnings']
				theRides=r['data']
				orderRequests=r['data']
			except Exception as e:
				print(e)

			response['theRides']=theRides
			response['orderRequests']=orderRequests
			# response['graph1']=theFinalValue
			response['theUserSeries']=theUserSeries
			response['theEarningSeries']=theEarningSeries
			# response['theEarningSeries']=theEarningSeries
			response['totalOrders']=totalOrders
			response['totalDrivers']=totalDrivers
			response['totalUsers']=totalCustomer
			response['totalCompanies']=totalCompanies
			response['totalEarnings']=adminObjects.totalsubscriptionearning
			response['status_code']=200
			response['status_message']='Dashboard Data'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def notifyThirdPartyUser(url,notificationType,title,message):
	payload={'AccessKey': 'N8OT6I2F4YA4D4M4I6N3',
	         'notificationType': notificationType,
	         'title': title,
	         'message': message,}
	apiResponse = requests.request("POST", url,data=payload)
	r=apiResponse.json()
	return r

def sendCustomerEmailNotfications(sessionToken,title,message):
	url = str(settings.CUSTOMER_ACCESS_URL)+"customer/backend/sendEmailNotificationsToCustomers/"
	payload={'AccessKey': sessionToken,
	'title': title,
	'message': message
	}
	response = requests.request("POST", url,data=payload)
	return response.json()

def sendCompanyEmailNotfications(sessionToken,title,message):
	url = str(settings.COMPANY_ACCESS_URL)+"company/backend/sendEmailNotificationsToCompanies/"
	payload={'AccessKey': sessionToken,
	'title': title,
	'message': message
	}
	response = requests.request("POST", url,data=payload)
	return response.json()

def sendDriverEmailNotfications(sessionToken,title,message):
	url = str(settings.DRIVER_ACCESS_URL)+"driver/backend/sendEmailNotificationsToDrivers/"
	payload={'AccessKey': sessionToken,
	'title': title,
	'message': message
	}
	response = requests.request("POST", url,data=payload)
	return response.json()



def sendCustomerPUSHNotfications(sessionToken,title,message):
	url = str(settings.CUSTOMER_ACCESS_URL)+"customer/backend/sendPushNotificationsToCustomers/"
	payload={'AccessKey': sessionToken,
	'title': title,
	'message': message
	}
	response = requests.request("POST", url,data=payload)
	return response.json()

def sendCompanyPUSHNotfications(sessionToken,title,message):
	print("=1=")
	url = str(settings.COMPANY_ACCESS_URL)+"company/backend/sendPushNotificationsToCompanies/"
	print(url)
	payload={'AccessKey': sessionToken,
	'title': title,
	'message': message
	}
	print("=2=")
	response = requests.request("POST", url,data=payload)
	# print("=3=")
	# print(response)
	print(response.json)
	return response.json()

def sendDriverPUSHNotfications(sessionToken,title,message):
	url = str(settings.DRIVER_ACCESS_URL)+"driver/backend/sendPushNotificationsToDrivers/"
	print('url',url)
	payload={'AccessKey': sessionToken,
	'title': title,
	'message': message
	}
	response = requests.request("POST", url,data=payload)
	return response.json()

class sendNotification(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='User type required'
				return Response(response)
			if not data.get('notificationType'):
				response['status_code']=400
				response['status_message']='Notification type required'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='Title required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='Message required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)

			if data.get('notificationType')=='email':
				if data.get('userType')=='Customer':
					sendCustomerEmailNotfications(data.get('session_token'),data.get('title'),data.get('message'))
				elif data.get('userType')=='Company':
					sendCompanyEmailNotfications(data.get('session_token'),data.get('title'),data.get('message'))
				elif data.get('userType')=='Driver':
					sendDriverEmailNotfications(data.get('session_token'),data.get('title'),data.get('message'))
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
			else:
				print("==Push In==")
				if data.get('userType')=='Customer':
					print("==Customer==")
					sendCustomerPUSHNotfications(data.get('session_token'),data.get('title'),data.get('message'))
				elif data.get('userType')=='Company':
					print("==Company==")
					sendCompanyPUSHNotfications(data.get('session_token'),data.get('title'),data.get('message'))
				elif data.get('userType')=='Driver':
					print("==Driver==")
					sendDriverPUSHNotfications(data.get('session_token'),data.get('title'),data.get('message'))
				response['status_code']=200
				response['status_message']='Success'
				return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class getDriversCompletedOrdersList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='Session token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			
			if not data.get('driverID'):
				response['status_code']=400
				response['status_message']='driverID is required'
				return Response(response)

			try:
				url = str(settings.DRIVER_ACCESS_URL)+"/driver/earnings/getEarningListOfADriverForAdmin/"
				payload={'AccessKey': str(settings.DRIVER_ACCESS_KEY),
				        'driverID':str(data.get('driverID'))}
				theRes = requests.request("POST", url,data=payload)
				return Response(theRes.json())
			except Exception as e:
				response['status_code']=400
				response['status_message']=str(e)
				print(e)
	
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def createCSVOrders(allOrders):
	import csv
	rows=[]
	fields = ['User Id', 'User Type', 'User Name', 'User Email', 'Requested Amount', 'Payout Status']
	for order in allOrders:
		innerRow=[]
		innerRow.append(order['payoutUserId'])
		innerRow.append(order['payoutUserType'])
		innerRow.append(order['payoutUserName']) 
		innerRow.append(order['payoutUserEmail']) 
		innerRow.append(order['payoutAmount'])
		innerRow.append(order['payoutStatus'])
		rows.append(innerRow)
	fname=randomStringFunctionForImage()
	filename = "/var/www/html/superadmin/media/Reports/payouts_"+str(fname)+".csv"
	url=str(settings.WEB_BASE_URL)+"media/Reports/payouts_"+str(fname)+".csv"
	with open(filename, 'w') as csvfile:
		csvwriter = csv.writer(csvfile) 
		csvwriter.writerow(fields)
		csvwriter.writerows(rows)
	return url

def createJson(obj):
	print("==object Call==")
	return {'payoutUserType':obj.payoutUserType,
			'payoutUserId':obj.payoutUserId,
			'payoutUserName':obj.payoutUserName,
			'payoutUserEmail':obj.payoutUserEmail,
			'payoutUserImage':obj.payoutUserImage,
			'payoutAmount':obj.payoutAmount,
			'payoutStatus':obj.payoutStatus,
			}

class getPayoutReports(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token is required'
				return Response(response)
				
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)

			if not data.get('userType'):
				userType='All'
			elif data.get('userType')=='All':
				userType='All'
			else:
				userType=data.get('userType')
			
			if not data.get('filterType'):
				status='All'
			elif data.get('filterType')=='All':
				status='All'
			else:
				status=data.get('filterType')
			
			if userType=='All':
				if status=='All':
					payoutObjects=payoutrequest.objects.all()
				else:
					payoutObjects=payoutrequest.objects.filter(payoutStatus=status)
			else:
				if status=='All':
					payoutObjects=payoutrequest.objects.filter(payoutUserType=userType)
				else:
					payoutObjects=payoutrequest.objects.filter(payoutUserType=userType,payoutStatus=status)
			if not payoutObjects:
				response['status_code']=400
				response['status_message']='No records found'
				return Response(response)
			allData=map(lambda x:{'payoutUserType':x.payoutUserType,'payoutUserId':x.payoutUserId,'payoutUserName':x.payoutUserName,'payoutUserEmail':x.payoutUserEmail,'payoutUserImage':x.payoutUserImage,'payoutAmount':x.payoutAmount,'payoutStatus':x.payoutStatus,}, payoutObjects)
			downloadLink=createCSVOrders(allData)
			response['downloadLink']=downloadLink
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)



