from rest_framework.views import APIView
from rest_framework.response import Response
from base.models import *
from .models import *
import datetime
from django.conf import settings
import json
from django.db.models import Q

class addCoupon(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)

			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('couponname'):
				response['status_code']=400
				response['status_message']='couponname required'
				return Response(response)
			if not data.get('couponcode'):
				response['status_code']=400
				response['status_message']='couponcode required'
				return Response(response)
			if not data.get('coupondescription'):
				response['status_code']=400
				response['status_message']='coupondescription required'
				return Response(response)
			if not data.get('discounttype'):
				response['status_code']=400
				response['status_message']='discounttype required'
				return Response(response)
			if not data.get('discount'):
				response['status_code']=400
				response['status_message']='discount required1'
				return Response(response)
			if not data.get('minimumamount'):
				response['status_code']=400
				response['status_message']='minimumamount required'
				return Response(response)
			if not data.get('maximumuse'):
				response['status_code']=400
				response['status_message']='maximumuse required'
				return Response(response)
			if not data.get('expirydate'):
				response['status_code']=400
				response['status_message']='expirydate required'
				return Response(response)
			
			try:
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/discount/addCoupon/"
				payload={
					'AccessKey':str(settings.CUSTOMER_ACCESS_KEY),
					'couponname':data.get('couponname'),
					'couponcode':data.get('couponcode'),
					'coupondescription':data.get('coupondescription'),
					'discounttype':data.get('discounttype'),
					'discount':data.get('discount'),
					'minimumamount':data.get('minimumamount'),
					'maximumuse':data.get('maximumuse'),
					'expirydate':data.get('expirydate'),
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class getCouponList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)

			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			
			try:
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/discount/getCouponListForAdmin/"
				payload={
					'AccessKey':str(settings.CUSTOMER_ACCESS_KEY),
				}
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class updateCoupon(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)

			if not data.get('couponcode'):
				response['status_code']=400
				response['status_message']='couponcode required'
				return Response(response)
			payload={}
			payload['AccessKey']=str(settings.CUSTOMER_ACCESS_KEY)
			payload['couponcode']=data.get('couponcode')

			if data.get('couponname'):
				payload['couponname']=data.get('couponname')
			if data.get('coupondescription'):
				payload['coupondescription']=data.get('coupondescription')
			if data.get('discounttype'):
				payload['discounttype']=data.get('discounttype')
			if data.get('discount'):
				payload['discount']=data.get('discount')
			if data.get('minimumamount'):
				payload['minimumamount']=data.get('minimumamount')
			if data.get('maximumuse'):
				payload['maximumuse']=data.get('maximumuse')
			if data.get('expirydate'):
				payload['expirydate']=data.get('expirydate')

			try:
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/discount/updateCoupon/"
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)

class deleteCoupon(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)

			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=401
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('couponcode'):
				response['status_code']=400
				response['status_message']='couponcode required'
				return Response(response)
			payload={}
			payload['AccessKey']=str(settings.CUSTOMER_ACCESS_KEY)
			payload['couponcode']=data.get('couponcode')

			try:
				import requests
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/discount/deleteCoupon/"
				res = requests.request("POST", url, data=payload)
				print(res)
				return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
			return Response(response)