from django.db import models
from ckeditor.fields import RichTextField 

USER_CHOICE = (
    ("1", "Customer"),
    ("2", "Company"),
    ("3", "Driver"),
    ("4", "Store"),
)

class plan(models.Model):
	userType = models.CharField(max_length = 20,choices = USER_CHOICE,default = '1')
	price = models.CharField(max_length = 50, null = True, blank = True)
	planName = models.CharField(max_length = 50, null = True, blank = True)
	planID = models.CharField(max_length = 25, null = True, blank = True)
	planDurationDays = models.CharField(max_length = 25, null = True, blank = True)
	description = models.TextField(blank = True)
	htmlDescription = RichTextField(default='')
	trialDurationDays = models.CharField(max_length = 25, null = True, blank = True)
	isActive = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.planName)+'-'+str(self.planID)+'-'+str(self.id))

class planmodule(models.Model):

	plan = models.ForeignKey(plan, on_delete=models.CASCADE)
	module = models.TextField(blank = True, null = True)

	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.plan))

class listmodule(models.Model):
	name = models.CharField(max_length = 50,default='List' ,null = True, blank = True)
	theData = models.TextField(blank = True, null = True)
	created_at = models.DateTimeField(auto_now_add = True)
	def __str__(self):
		return str(str(self.name))