from rest_framework import serializers
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
import json
class GetModuleData(serializers.ModelSerializer):
	class Meta:
		model = planmodule
		fields = ['module']

class GetPlanData(serializers.ModelSerializer):
	moduleData =  serializers.SerializerMethodField(source='get_moduleData')
	
	class Meta:
		model = plan
		fields = ['userType','price', 'planName', 'planID','planDurationDays','description','trialDurationDays','isActive','moduleData','htmlDescription']
	
	def get_moduleData(self, obj):
		moduleObject=planmodule.objects.filter(plan=obj).first()
		return json.loads(moduleObject.module)