from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from base.models import *
from .models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .serializers import *
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
import json
from django.conf import settings

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

def randomNumber():
	str1 = ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

class addPlan(APIView):
	def get(self,request):
		response={}
		response['status_code']=200
		response['status_message']='Add Plan'
		return Response(response)
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if not data.get('planName'):
				response['status_code']=400
				response['status_message']='Plan name required'
				return Response(response)

			if not data.get('planPrice'):
				response['status_code']=400
				response['status_message']='Plan price required'
				return Response(response)

			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='User type required'
				return Response(response)

			if not data.get('planDuration'):
				response['status_code']=400
				response['status_message']='Plan duration required'
				return Response(response)

			if not data.get('planDescription'):
				response['status_code']=400
				response['status_message']='Plan description required'
				return Response(response)
			if not data.get('planHTMLDescription'):
				response['status_code']=400
				response['status_message']='Plan HTML description required'
				return Response(response)

			if not data.get('trialDuration'):
				response['status_code']=400
				response['status_message']='Trial duration required'
				return Response(response)
			if not data.get('moduleData'):
				response['status_code']=400
				response['status_message']='Module data required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			ifExist=plan.objects.filter(planName=data.get('planName')).first()
			if ifExist:
				response['status_code']=400
				response['status_message']='Plan name already in use'
				return Response(response)
			thePlan=plan.objects.create(planName=data.get('planName'))
			firstThree=data.get('planName')[0:3]
			planIDString=randomNumber()
			firstThree=firstThree.upper()
			planIDString=str(firstThree)+str(planIDString)
			if thePlan:
				thePlan.planID=planIDString
				thePlan.price=data.get('planPrice')
				thePlan.userType=data.get('userType')
				thePlan.planDurationDays=data.get('planDuration')
				thePlan.description=data.get('planDescription')
				thePlan.htmlDescription=data.get('planHTMLDescription')
				thePlan.trialDurationDays=data.get('trialDuration')
				thePlan.isActive=True
				thePlan.save()

				emptyJson='{"data":[]}'
				theObj=planmodule.objects.filter(plan=thePlan).first()
				if not theObj:
					theObj=planmodule.objects.create(plan=thePlan,module=emptyJson)
				theJson=json.loads(theObj.module)
				theList=theJson['data']
				theList=[]
				# print(data.get('data'))
				theGetJson=data.get('moduleData')
				print("theGetJson==========",theGetJson)
				print(type(theGetJson))
				theDataOfList=json.loads(theGetJson)
				print("after----------------------------------")
				print(theDataOfList)
				print(type(theDataOfList))
				theDataOfList=theDataOfList['data']
				for i in theDataOfList:
					print(i)
					print(i['Module']['name'])
					print(i['Module']['value'])
					tempJson={}
					tempJson.update({'name':i['Module']['name'],
					            'value':i['Module']['value']})
					theList.append(tempJson)

				theJson['data']=theList
				theObj.module=json.dumps(theJson)
				theObj.save()
				response['data']=theJson
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updatePlan(APIView):
	def get(self,request):
		response={}
		response['status_code']=200
		response['status_message']='Update Plan'
		return Response(response)
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan ID required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			thePlan=plan.objects.filter(planID=data.get('planID')).first()
			if thePlan:
				if data.get('planPrice'):
					thePlan.price=data.get('planPrice')
				if data.get('userType'):
					thePlan.userType=data.get('userType')
				if data.get('planDuration'):
					thePlan.planDurationDays=data.get('planDuration')
				if data.get('planDescription'):
					thePlan.description=data.get('planDescription')
				if data.get('trialDuration'):
					thePlan.trialDurationDays=data.get('trialDuration')
				if data.get('planHTMLDescription'):
					thePlan.htmlDescription=data.get('planHTMLDescription')
				thePlan.save()

				emptyJson='{"data":[]}'
				theObj=planmodule.objects.filter(plan=thePlan).first()
				if not theObj:
					theObj=planmodule.objects.create(plan=thePlan,module=emptyJson)
				theJson=json.loads(theObj.module)
				theList=theJson['data']
				theList=[]
				# print(data.get('data'))
				theGetJson=data.get('moduleData')
				print("theGetJson==========",theGetJson)
				print(type(theGetJson))
				theGetJson=str(theGetJson)
				theDataOfList=json.loads(theGetJson)
				print("after----------------------------------")
				print(theDataOfList)
				print(type(theDataOfList))
				theDataOfList=theDataOfList['data']
				for i in theDataOfList:
					print(i)
					print(i['Module']['name'])
					print(i['Module']['value'])
					tempJson={}
					tempJson.update({'name':i['Module']['name'],
					            'value':i['Module']['value']})
					theList.append(tempJson)

				theJson['data']=theList
				theObj.module=json.dumps(theJson)
				theObj.save()
				response['data']=theJson
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class enableDisablePlan(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan ID required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			thePlan=plan.objects.filter(planID=data.get('planID')).first()
			if thePlan:
				if data.get('status') == True:
					thePlan.isActive=True
				else:
					thePlan.isActive=False
				thePlan.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def getPlanList():
	response={}
	try:
		allObj=plan.objects.all()
		theData=GetPlanData(allObj,many=True)
		response['status_code']=200
		response['status_message']='Success'
		response['data']=theData.data
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
	return Response(response)

def getPlanListFunctionFilter(theType):
	response={}
	try:
		allObj=plan.objects.filter(userType=theType,isActive=True)
		theData=GetPlanData(allObj,many=True)
		response['status_code']=200
		response['status_message']='Success'
		response['data']=theData.data
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
	return Response(response)

class getPlanListForAll(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='User type required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			return getPlanListFunctionFilter(data.get('userType'))
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getPlanListByAdmin(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			return getPlanList()
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)	

def viewPlan(thePlanID):
	response={}
	try:
		theObj=plan.objects.filter(planID=thePlanID).first()
		theData=GetPlanData(theObj)
		response['status_code']=200
		response['status_message']='Success'
		response['data']=theData.data
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
	return Response(response)

def viewPlanFunctionFilter(thePlanID,theType):
	response={}
	try:
		theObj=plan.objects.filter(planID=thePlanID,userType=theType).first()
		print('theObj',theObj)
		theData=GetPlanData(theObj)
		response['status_code']=200
		response['status_message']='Success'
		response['data']=theData.data
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
	return Response(response)

def viewPlanFunctionFilterForList(thePlanID,theType):
	response={}
	try:
		theObj=plan.objects.filter(planID=thePlanID,userType=theType).first()
		theData=GetPlanData(theObj)
		return theData.data
	except Exception as e:
		print(e)
		return ''

class viewPlanByAdmin(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan ID required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			return viewPlan(data.get('planID'))
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class viewPlanForAll(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan ID required'
				return Response(response)
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='User type required'
				return Response(response)
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='Access key required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			return viewPlanFunctionFilter(data.get('planID'),data.get('userType'))
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getModule(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			theObj=listmodule.objects.get(name='List')
			theJson=json.loads(theObj.theData)
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theJson
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addInModuleList(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			theObj=listmodule.objects.get(name='List')
			theJson=json.loads(theObj.theData)
			if data.get('type')=='boolean' or data.get('type') == 'int':
				pass
			else:
				response['status_code']=400
				response['status_message']='Not a valid type'
				return Response(response)
			theList=theJson['data']
			tempJson={}
			tempJson2={}
			tempJson.update({'name':data.get('name'),
				            'UIname':data.get('UIname'),
				            'type':data.get('type'),})
			tempJson2.update({'Module':tempJson})
			if tempJson2 not in theList:
				theList.append(tempJson2)
			theJson['data']=theList
			theObj.theData=json.dumps(theJson)
			theObj.save()

			allBeforePlans=planmodule.objects.all()
			for abp in allBeforePlans:
				theLoopJson=json.loads(abp.module)
				theLoopList=theLoopJson['data']
				if data.get('type')=='boolean':
					theLoopList.append({'name':data.get('name'),
						                'value':'False',})
				else:
					theLoopList.append({'name':data.get('name'),
						                'value':'0',})
				theLoopJson['data']=theLoopList
				abp.module=json.dumps(theLoopJson)
				abp.save()
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theJson
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addModule(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan ID required'
				return Response(response)
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			thePlanObj=plan.objects.filter(planID=data.get('planID')).first()
			if not thePlanObj:
				response['status_code']=400
				response['status_message']='Not a valid plan ID'
				return Response(response)
			emptyJson='{"data":[]}'
			theObj=planmodule.objects.filter(plan=thePlanObj).first()
			if not theObj:
				theObj=planmodule.objects.create(plan=thePlanObj,module=emptyJson)
			theJson=json.loads(theObj.module)
			theList=theJson['data']

			tempJson={}
			tempJson.update({'name':data.get('name'),
				            'value':data.get('value'),})
			if tempJson not in theList:
				theList.append(tempJson)

			# theList.append({'name':data.get('name'),
			# 	            'value':data.get('value'),})
			theJson['data']=theList
			theObj.module=json.dumps(theJson)
			theObj.save()
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theJson
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateModule(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			adminObjects=theadmin.objects.filter(token=data.get('session_token')).first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials2'
				return Response(response)
			thePlanObj=plan.objects.filter(planID=data.get('planID')).first()
			if not thePlanObj:
				response['status_code']=400
				response['status_message']='Not a valid plan ID'
				return Response(response)
			theObj=planmodule.objects.filter(plan=thePlanObj).first()
			if not theObj:
				response['status_code']=400
				response['status_message']='Not have any module'
				return Response(response)

			theJson=json.loads(theObj.module)
			theList=theJson['data']

			for jsn in theList:
				if jsn['name'] == data.get('name'):
					jsn['value']=data.get('value')
					break
			theJson['data']=theList
			theObj.module=json.dumps(theJson)
			theObj.save()
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theJson
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getModuleList(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			theObj=listmodule.objects.get(name='List')
			theJson=json.loads(theObj.theData)
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theJson
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class viewPlanWithIDListForAll(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		print("djv")
		try:
			allData=[]
			print("==1==")
			data=request.data

			theList=data.get('planID')
			print("===========================>",theList)
			theList=json.loads(theList)
			print("--------------------------->",theList)



			if not data.get('planID'):
				response['status_code']=400
				response['status_message']='Plan ID required'
				return Response(response)
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='User type required'
				return Response(response)
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='Access key required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			print("==4==")
			for i in theList:
				theReturnData=viewPlanFunctionFilterForList(i['planID'],data.get('userType'))
				if theReturnData!='':
					allData.append(theReturnData)
			response['status']=200
			response['status_message']='Success'
			response['data']=allData
			return Response(response)
			# return viewPlanFunctionFilter(data.get('planID'),data.get('userType'))
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class viewPlanListDataForRenew(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			allData=[]
			data=request.data

			print("1")
			if not data.get('planData'):
				response['status_code']=400
				response['status_message']='planData required'
				return Response(response)
			print("2")
			theData=data.get('planData')
			theData=json.loads(theData)
			print("3")
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='User type required'
				return Response(response)
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='Access key required'
				return Response(response)
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			for i in theData:
				theReturnData=viewPlanFunctionFilterForList(i['planID'],data.get('userType'))
				if theReturnData!='':
					allData.append({'theReturnPlanData':theReturnData,
					                'planID':i['planID'],
									'planObjectID':i['planObjectID'],
									'renewType':i['renewType'],
									'otherPlanObjectID':i['otherPlanObjectID']})
			response['status_code']=200
			response['status_message']='Success'
			response['data']=allData
			return Response(response)
			# return viewPlanFunctionFilter(data.get('planID'),data.get('userType'))
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addSubscriptionEarning(APIView):
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') != str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='You dont have access.'
				return Response(response)
			adminObjects=theadmin.objects.all().first()
			if not adminObjects:
				response['status_code']=400
				response['status_message']='Admin not found'
				return Response(response)
			if not data.get('amount'):
				response['status_code']=400
				response['status_message']='purchase amount is required.'
				return Response(response)
			totalAmount=float(data.get('amount'))+float(adminObjects.totalsubscriptionearning)
			totalAmount="{:.2f}".format(totalAmount)
			adminObjects.totalsubscriptionearning=str(totalAmount)
			adminObjects.save()
			adminearning.objects.create(earn=data.get('amount'))
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)