from django.db import models
from django.db.models.fields.related import ForeignKey

ROLE_ASSIGNED = [
    ('Admin', 'Admin'),
    ('Company', 'Company'),
]

class supportroles(models.Model):
	supportRole = models.CharField(max_length = 50, null = True, blank = True)
	supportType = models.CharField(max_length=15,choices=ROLE_ASSIGNED,default='Admin',)
	isdeleted = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.supportRole)+'-'+str(self.supportType))

class team(models.Model):
	role= models.ForeignKey(supportroles, on_delete=models.CASCADE,default='',null=True)
	name = models.CharField(max_length = 50, null = True, blank = True)
	teamID = models.CharField(max_length = 25, null = True, blank = True)
	latitude = models.FloatField(max_length = 20, blank = True, null = True)
	longitude = models.FloatField(max_length = 20, blank = True, null = True)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.name)+'-'+str(self.teamID))

class staff(models.Model):
	role= models.ForeignKey(supportroles, on_delete=models.CASCADE,default='',null=True)
	team= models.ForeignKey(team, on_delete=models.CASCADE,default='',null=True)
	token = models.CharField(max_length = 50, null = True, blank = True)
	userTableID = models.CharField(max_length = 10, null = True, blank = True)
	userUniqueID = models.CharField(max_length = 25, null = True, blank = True)
	name = models.CharField(max_length = 20, null = True, blank = True)
	email = models.CharField(max_length = 30, unique = True, null = True, blank = True)
	countrycode = models.CharField(max_length = 10, null = True, blank = True)
	phone = models.CharField(max_length = 15, blank = True, null = True)
	image = models.CharField(max_length = 200, null = True, blank = True)
	teamID = models.CharField(max_length = 25, null = True, blank = True)
	forgotPasswordOTP = models.CharField(max_length=20,blank=True,null=True)
	fcmtoken = models.CharField(max_length = 300, blank = True, null = True,default = '')
	deviceType = models.CharField(max_length = 300, blank = True, null = True,default = '')
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.name)+'-'+str(self.userUniqueID))

class superadminaccess(models.Model):
	theId = models.CharField(max_length = 10,unique = True, null = True, blank = True)
	token = models.CharField(max_length = 50, null = True, blank = True)
	def __str__(self):
		return str(str(self.token))


class notifications(models.Model):
	staff=ForeignKey(staff,on_delete=models.CASCADE,null=True)
	image = models.CharField(max_length = 200,null = True,default = '')
	title = models.CharField(max_length = 50,null = True,default = '')
	description = models.TextField(null = True)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.staff)+'-'+str(self.title))

from .signals import *