from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import *
from django.conf import settings


def sendPush(device_id, body):
	import json
	import boto
	import boto.exception
	import boto.sns
	import pprint
	import re
	region = [r for r in boto.sns.regions() if r.name==u'us-east-1'][0]
	sns = boto.sns.SNSConnection(
		aws_access_key_id=str(settings.AWS_ACCESS_KEY_ID),
		aws_secret_access_key=str(settings.AWS_SECRET_ACCESS_KEY),
		region=region,
	)
	try:
		print("device id",device_id)
		endpoint_response = sns.create_platform_endpoint(
			platform_application_arn='arn:aws:sns:us-east-1:432363816440:app/GCM/Cannabis',
			token=device_id,
		)   
		endpoint_arn = endpoint_response['CreatePlatformEndpointResponse']['CreatePlatformEndpointResult']['EndpointArn']
	except boto.exception.BotoServerError as err:
		print("if error ", err)
		result_re = re.compile(r'Endpoint(.*)already', re.IGNORECASE)
		result = result_re.search(err.message)
		if result:
			endpoint_arn = result.group(0).replace('Endpoint ','').replace(' already','')
		else:
			raise
	print("ARN:", endpoint_arn)
	publish_result = sns.publish(
		target_arn=endpoint_arn,
		message=json.dumps(body),
		# message_structure='json'
	)
	print("PUBLISH")
	pprint.pprint(publish_result)

@receiver(post_save, sender=notifications)
def send_push_notifications(sender, instance, created, **kwargs):
	if created:
		if instance.staff.fcmtoken != '':sendPush(instance.staff.fcmtoken,{'body':instance.description,'title':instance.title})