from rest_framework import response
from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from .models import *
import requests
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
from .serializers import *
import datetime
from django.template.loader import render_to_string
from django.core.mail import EmailMessage
import math, random, datetime, pytz, string
from django.conf import settings


class checkAuth(APIView):
	'Class designed to check auth'
	def __init__(self,request):
		self.response={}
		self.data=request.data		
		if not self.data.get('session_token'):
			self.response['status_code']=400
			self.response['status_code']='Session Token required'
			return Response(self.response)
		tokenOBJ = Token.objects.filter(key = self.data.get('session_token')).first()
		print('tokenOBJ',tokenOBJ)
		if tokenOBJ:
			user = User.objects.get(id = tokenOBJ.user_id)
			print('user==',user)
			if not user:
				self.response['status_code']=400
				self.response['status_message']='User not exist'
				return Response(self.response)
			else:
				self.staffObj=staff.objects.filter(token=self.data.get('session_token')).first()
				print('staffffff',self.staffObj)
				if not self.staffObj:
					self.response['status_code']=400
					self.response['status_message']='Staff not exist'
					return Response(self.response)
		else:
			self.response['status_code']=400
			self.response['status_message']='Invalid sesssion token'
			return Response(self.response)

def GernateOTP():
	digits = "0123456789"
	OTP = ""
	for i in range(4) :
		OTP += digits[math.floor(random.random() * 10)]
	return OTP

def randomStringFunctionForImage():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(8)))
	str1 += ''.join((random.choice(string.digits) for x in range(4)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def uploadDocumentImages(image,thePath):
	bucket='cannabisadminsupport'
	import os
	import boto3
	from botocore.exceptions import NoCredentialsError
	try:
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
                      aws_secret_access_key=SECRET_KEY)
		try:
			filetype = os.path.splitext(image.name)[1]
			print("==================================filetype===========",filetype)
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+str(filetype)
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			return filename
		except FileNotFoundError as e:
			print("The file was not found")
			return ''
		except NoCredentialsError:
			print("Credentials not available")
			return ''
	except Exception as e:
		print(e)
		return ''

class login(APIView):
	def get(self,request):
		response={}
		response['status_code']=200
		response['status_message']='Welcome'
		return Response(response)
	def post(self,request,*args,**kwargs):
		response={}
		try:
			data=request.data

			if not data.get('email'):
				response['status_code']=400
				response['status_message']='Email required'
				return Response(response)
			if not data.get('password'):
				response['status_code']=400
				response['status_message']='Password required'
				return Response(response)
			if not data.get('fcmtoken'):
				fcmtoken=''
			else:
				fcmtoken=data.get('fcmtoken')
			
			if not data.get('deviceType'):
				deviceType=''
			else:
				deviceType=data.get('deviceType')

			user = authenticate(username = data.get('email'), password = data.get('password'))
			if not user:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			staffObject=staff.objects.filter(userTableID=user.id).first()
			if not staffObject:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			token,status = Token.objects.get_or_create(user = user)
			if token:
				token.delete()
			token,status = Token.objects.get_or_create(user = user)
			tokenKey=token.key
			staffObject.token=tokenKey
			staffObject.fcmtoken=fcmtoken
			staffObject.deviceType=deviceType
			staffObject.save()
			theData=GetStaffData(staffObject)
			response['status_code']=200
			response['status_message']='Done'
			response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			staffOBJ = staff.objects.filter(email = data.get('email')).first()
			if not staffOBJ:
				response['status_code']=400
				response['status_message']='Email not exist'
				return Response(response)
			OTP=GernateOTP()
			staffOBJ.forgotPasswordOTP=OTP
			staffOBJ.save()
			try:
				message = render_to_string('forgotPasswordEmail.html', {
					'name': staffOBJ.name,
					'otp': otp,
				})
				from_email = settings.EMAIL_HOST_USER
				to_email = data.get('email')
				message = EmailMessage(subject, message, from_email, [to_email])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)
			response['status_code']=200
			response['status_message']='OTP send on Your Mail'
			response['OTP']=OTP

		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class forgotPasswordVerifyOtp(APIView):

	def post(self, request, *args, **kwargs):
		response={}
		try:
			response['status_code']=200
			response['status_message']='OTP verified'
			data=request.data
			staffObj = staff.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
			if not staffObj:
				response['status_code']=400
				response['status_message']='OTP not matched'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updatePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			staffObj = staff.objects.filter(email = data.get('email'),forgotPasswordOTP=data.get('otp')).first()
			if not staffObj:
				response['status_code']=400
				response['status_message']='Invalid OTP'
				return Response(response)
			userObj=User.objects.filter(id=staffObj.userTableID).first()
			userObj.set_password(data.get('password'))
			userObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

def uploadImage(image):
	fs = FileSystemStorage()
	filename = fs.save(image.name, image)
	filename = fs.url(filename)
	return filename

class getProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			userID=validateToken(data.get('session_token'))
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			staffObjects=staff.objects.filter(userTableID=userID).first()
			if not staffObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			theData=GetStaffData(staffObjects)
			response['status_code']=200
			response['status_message']='Success'
			response['data']=theData.data
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)


class updateProfile(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			userID=validateToken(data.get('session_token'))
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			staffObjects=staff.objects.filter(userTableID=userID).first()
			if not staffObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if data.get('name'):
				staffObjects.name=data.get('name')
			if data.get('phone'):
				staffObjects.phone=data.get('phone')
			if data.get('countrycode'):
				staffObjects.countrycode=data.get('countrycode')
			# theImage = request.FILES.get("image")
			# if theImage:
			# 	filename=uploadDocumentImages(theImage,'Profile')
			# 	adminObjects.image=filename
			staffObjects.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class changePassword(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			tokenOBJ = Token.objects.filter(key = data.get('session_token')).first()
			if not tokenOBJ:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			user = User.objects.get(id = tokenOBJ.user_id)
			if not user:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			userObj = authenticate(username = user.username, password = data.get('oldPassword'))
			userObj.set_password( data.get('newPassword'))
			userObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class logout(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			tokenOBJ = Token.objects.filter(key = data.get('session_token')).first()
			if not tokenOBJ:
				response['status_code']=400
				response['status_message']='Invalid Token'
				return Response(response)
			userOBJ = User.objects.get(id = tokenOBJ.user_id)
			staffObj = staff.objects.filter(userTableID = userOBJ.id).first()
			if not staffObj:
				response['status_code']=400
				response['status_message']='Not a valid User'
			else:
				staffObj.token=''
				staffObj.save()
				userOBJ.auth_token.delete()
				response['status_code']=200
				response['status_message']='Logout'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class adminLoginToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			theAccess=superadminaccess.objects.filter(theId='1').first()
			if not theAccess:
				theAccess=superadminaccess.objects.create(theId='1')
			theAccess.token=data.get('AccessKey')
			theAccess.save()
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class adminLogoutToken(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			theAccess=superadminaccess.objects.filter(theId='1').first()
			if not theAccess:
				theAccess=superadminaccess.objects.create(theId='1')
			theAccess.token='A4D5M8I6N3L3O5G2O0U8T'
			theAccess.save()
			response['status_code']=200
			response['status_message']='Done'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def randomStringFunction():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
	str1 += ''.join((random.choice(string.digits) for x in range(6)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

def randomStringFunctionSmall():
	str1 = ''.join((random.choice(string.ascii_letters) for x in range(4)))
	str1 += ''.join((random.choice(string.digits) for x in range(2)))
	sam_list = list(str1)
	random.shuffle(sam_list)
	finalString = ''.join(sam_list)
	return finalString

class addStaff(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			userOBJ = User.objects.filter(username = data.get('email')).first()
			if userOBJ:
				response['status_code']=400
				response['status_message']='Email already exist.'
				return Response(response)
			if not data.get('role'):
				response['status_code']=400
				response['status_message']='role is required'
				return Response(response)
			theRoleObj=supportroles.objects.filter(supportRole=data.get('role')).first()
			if not theRoleObj:
				response['status_code']=400
				response['status_message']='Invalid role type'
				return Response(response)
			if not data.get('teamID'):
				response['status_code']=400
				response['status_message']='teamID required'
				return Response(response)
			if not request.FILES.get('image'):
				response['status_code']=400
				response['status_message']='image required'
				return Response(response)
			thePassword=randomStringFunction()
			theTeamObject=team.objects.filter(teamID=data.get('teamID')).first()
			if not theTeamObject:
				response['status_code']=400
				response['status_message']='Invalid team id'
				return Response(response)
			userOBJ = User.objects.create_user(username = data.get('email'), password = thePassword)
			userObjId=userOBJ.id

			beforeNameOfUser=data.get('name')
			name3Letter=beforeNameOfUser[0:3]
			name3Letter=name3Letter.upper()
			latExt=staff.objects.all().last()
			if latExt:
				lastId=latExt.userUniqueID
				last5Number=lastId[3:]
				last5Number=int(last5Number)
				new5Number=last5Number+1
				new5Number=str(new5Number)
				new5Number = new5Number.zfill(5)
				theUniqueID=str(name3Letter)+str(new5Number)
			else:
				theUniqueID=str(name3Letter)+str('00001')
			# theUniqueID=randomStringFunction()
			adminObj = staff.objects.create(team=theTeamObject,role=theRoleObj,userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'),email = data.get('email'),phone = data.get('phone'),countrycode = data.get('countrycode'))
			staffImage=request.FILES.get('image')
			if staffImage:
				filename=uploadDocumentImages(staffImage,'Profile')
				adminObj.image=filename
				adminObj.save()
			try:
				subject='Welcome'
				message = render_to_string('informStaffEmail.html', {
					'name': data.get('name'),
					'email': data.get('email'),
					'password': str(thePassword),
				})
				from_email = settings.EMAIL_HOST_USER
				to_email = data.get('email')
				message = EmailMessage(subject, message, from_email, [to_email])
				message.content_subtype = 'html'
				message.send()
			except Exception as e:
				print(e)

			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addTeam(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			if not data.get('role'):
				response['status_code']=400
				response['status_message']='role required.'
				return Response(response)
			theRoleObj=supportroles.objects.filter(supportRole=data.get('role')).first()
			if not theRoleObj:
				response['status_code']=400
				response['status_message']='Invalid role type'
				return Response(response)
			# theTeamID=randomStringFunctionSmall()
			beforeNameOfUser=data.get('name')
			name3Letter=beforeNameOfUser[0:3]
			name3Letter=name3Letter.upper()
			latExt=team.objects.all().last()
			if latExt:
				lastId=latExt.teamID
				last5Number=lastId[3:]
				last5Number=int(last5Number)
				new5Number=last5Number+1
				new5Number=str(new5Number)
				new5Number = new5Number.zfill(5)
				theTeamID=str(name3Letter)+str(new5Number)
			else:
				theTeamID=str(name3Letter)+str('00001')
			adminObj = team.objects.create(role=theRoleObj,name=data.get('name'),teamID=theTeamID)
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateStaff(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			userOBJ = User.objects.filter(username = data.get('email')).first()
			if userOBJ:
				response['status_code']=400
				response['status_message']='Email already exist.'
				return Response(response)
			
			adminObj=staff.objects.filter(userUniqueID=data.get('staffID')).first()

			# adminObj = Staff.objects.create(userUniqueID=theUniqueID,userTableID=userObjId, name = data.get('name'),email = data.get('email'),phone = data.get('phone'),countrycode = data.get('countrycode'))
			
			if data.get('teamID'):
				teamObj = team.objects.filter(teamID=data.get('teamID')).first()
				if teamObj:
					adminObj.teamID=data.get('teamID')
			if data.get('name'):
				adminObj.name=data.get('name')
			if data.get('phone'):
				adminObj.phone=data.get('phone')
			if data.get('countrycode'):
				adminObj.countrycode=data.get('countrycode')
			staffImage=request.FILES.get('image')
			if staffImage:
				filename=uploadDocumentImages(staffImage,'Profile')
				adminObj.image=filename
				adminObj.save()
			if data.get('role'):
				theRoleObj=supportroles.objects.filter(supportRole=data.get('role')).first()
				if theRoleObj:
					adminObj.role=theRoleObj
			if data.get('teamID'):
				theTeamObject=team.objects.filter(teamID=data.get('teamID')).first()
				if theTeamObject:
					adminObj.team=theTeamObject
			adminObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateTeam(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			
			adminObj = team.objects.filter(teamID=data.get('teamID')).first()
			if adminObj:
				if data.get('name'):
					adminObj.name=data.get('name')
				if data.get('role'):
					theRoleObj=supportroles.objects.filter(supportRole=data.get('role')).first()
					if theRoleObj:
						adminObj.role=theRoleObj
				adminObj.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class getTeamList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			isTheDisabled='ALL'
			if data.get('filterStaus'):
				if data.get('filterStaus')=='Enable':
					isTheDisabled=False
				else:
					isTheDisabled=True
			else:
				isTheDisabled='ALL'
			if data.get('search'):
				if isTheDisabled=='ALL':
					allTeamsObject = team.objects.filter(name__icontains=data.get('search'))
				else:
					allTeamsObject = team.objects.filter(name__icontains=data.get('search'),isdisabled=isTheDisabled)
			else:
				if isTheDisabled=='ALL':
					allTeamsObject = team.objects.all()
				else:
					allTeamsObject = team.objects.filter(isdisabled=isTheDisabled)
			teamsData=GetTeamData(allTeamsObject,many=True)
			response['data']=teamsData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getTeam(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			teamObject = team.objects.filter(teamID=data.get('teamID')).first()
			if not teamObject:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			teamData=GetTeamData(teamObject)
			response['data']=teamData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getStaffList(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			isTheDisabled='ALL'
			if data.get('filterStaus'):
				if data.get('filterStaus')=='Enable':
					isTheDisabled=False
				else:
					isTheDisabled=True
			else:
				isTheDisabled='ALL'
			if data.get('search'):
				if isTheDisabled=='ALL':
					allStaffObject = staff.objects.filter(name__icontains=data.get('search'))
				else:
					allStaffObject = staff.objects.filter(name__icontains=data.get('search'),isdisabled=isTheDisabled)
			else:
				if isTheDisabled=='ALL':
					allStaffObject = staff.objects.all()
				else:
					allStaffObject = staff.objects.filter(isdisabled=isTheDisabled)

			# allStaffObject = Staff.objects.all()
			staffData=GetStaffData(allStaffObject,many=True)
			response['data']=staffData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getStaffPerson(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			staffObject = staff.objects.filter(userUniqueID=data.get('staffID')).first()
			if not staffObject:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			staffData=GetStaffData(staffObject)
			response['data']=staffData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addRole(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			if not data.get('supportRole'):
				response['status_code']=400
				response['status_message']='supportRole name required.'
				return Response(response)
			if not data.get('supportType'):
				response['status_code']=400
				response['status_message']='supportType required.'
				return Response(response)
			print("==1==")
			try:
				import requests
				print("==2==")
				url2 = str(settings.CHS_ACCESS_URL)+"company/support/auth/addRole/"
				payload2={
					'AccessKey':str(data.get('AccessKey')),
					'supportRole':data.get('supportRole'),
					'supportType':data.get('supportType'),
				}
				res2 = requests.request("POST", url2, data=payload2)
				print(res2)
				res2=res2.json()
				if res2['status_code']==200:
					pass
				else:
					response['status_code']=400
					response['status_message']='Oops! something went wrong'
					return Response(response)
				# response['status_code']=200
				# response['status_message']='Role Added'
				# return Response(response)
				# return Response(res.json())
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
			roleObject = supportroles.objects.create(supportRole=data.get('supportRole'),supportType=data.get('supportType'))
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class updateRole(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			if not data.get('supportRole'):
				response['status_code']=400
				response['status_message']='supportRole name required.'
				return Response(response)
			payload2={}
			payload2['AccessKey']=str(data.get('AccessKey'))
			payload2['supportRole']=str(data.get('supportRole'))
			if data.get('supportRoleUpdatedName'):
				payload2['supportRoleUpdatedName']=data.get('supportRoleUpdatedName')
			if data.get('supportType'):
				payload2['supportType']=data.get('supportType')
			
			print("==1==")
			try:
				import requests
				print("==2==")
				url2 = str(settings.CHS_ACCESS_URL)+"company/support/auth/updateRole/"
				res2 = requests.request("POST", url2, data=payload2)
				print(res2)
				res2=res2.json()
				print("==3==")
				print(res2)
				if res2['status_code']==200:
					pass
				else:
					response['status_code']=400
					response['status_message']='Oops! something went wrong'
					return Response(response)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)

			roleObject = supportroles.objects.filter(supportRole=data.get('supportRole')).first()
			if not roleObject:
				response['status_code']=400
				response['status_message']='invalid role selection.'
				return Response(response)
			if data.get('supportRoleUpdatedName'):
				roleObject.supportRole=data.get('supportRoleUpdatedName')
			if data.get('supportType'):
				roleObject.supportType=data.get('supportType')
			roleObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


class getRole(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			allRoles=[]
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			allRolesObject = supportroles.objects.all()
			for alR in allRolesObject:
				allRoles.append({'id':alR.id,
					             'supportRole':alR.supportRole,
				                 'supportType':alR.supportType,
								 'isdisabled':alR.isdisabled,})
			response['data']=allRoles
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)
	
class getTeamsByRole(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			if not data.get('role'):
				response['status_code']=400
				response['status_message']='role required.'
				return Response(response)
			theRoleObject = supportroles.objects.filter(supportRole=data.get('role')).first()
			allTeamsObject = team.objects.filter(role=theRoleObject)
			teamsData=GetTeamData(allTeamsObject,many=True)
			response['data']=teamsData.data
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class activeInactiveStaff(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			staffObject = staff.objects.filter(userUniqueID=data.get('staffID')).first()
			if not staffObject:
				response['status_code']=400
				response['status_message']='No data found'
				return Response(response)
			if data.get('status')=='active':
				staffObject.isdisabled=False
			else:
				staffObject.isdisabled=True
			staffObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class activeInactiveRole(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			if not data.get('id'):
				response['status_code']=400
				response['status_message']='Role id is required.'
				return Response(response)
			try:
				staffRoleObject = supportroles.objects.get(id=data.get('id'))
			except Exception as e:
				response['status_code']=500
				response['status_message']='Invalid role id'
				return Response(response)
			if data.get('status')=='active':
				staffRoleObject.isdisabled=False
			else:
				staffRoleObject.isdisabled=True
			staffRoleObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class activeInactiveTeam(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			if data.get('AccessKey') is None:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			theAccess=superadminaccess.objects.filter(theId='1',token=data.get('AccessKey')).first()
			if not theAccess:
				response['status_code']=400
				response['status_message']='You dont have access to this api.'
				return Response(response)
			if not data.get('teamID'):
				response['status_code']=400
				response['status_message']='teamID is required.'
				return Response(response)
			try:
				supportTeamObject = team.objects.get(teamID=data.get('teamID'))
			except Exception as e:
				response['status_code']=500
				response['status_message']='Invalid team id'
				return Response(response)
			if data.get('status')=='active':
				supportTeamObject.isdisabled=False
			else:
				supportTeamObject.isdisabled=True
			supportTeamObject.save()
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

from django.db.models import Q
from tickets.models import *
class getDashboardData(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		try:
			data=request.data
			userID=validateToken(data.get('session_token'))
			if userID == '0':
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			staffObjects=staff.objects.filter(userTableID=userID).first()
			if not staffObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)

			allTickets=tickets.objects.filter(staff=staffObjects).count()
			closeTickets=tickets.objects.filter(staff=staffObjects,status='CLOSED').count()
			inProgressTickets=tickets.objects.filter(staff=staffObjects).exclude(status='CLOSED').count()

			response['allTickets']=allTickets
			response['closeTickets']=closeTickets
			response['inProgressTickets']=inProgressTickets

			theTicketSeries=[]
			import datetime as ddd
			import dateutil.relativedelta
			for er in range(0,6):
				d = ddd.datetime.now()
				print(d.month,d.year)
				d2 = d - dateutil.relativedelta.relativedelta(months=er)
				print(d2.month,d2.year)
				theDateValue=d2.strftime("%b, %Y")
				monthlyTicketCount=tickets.objects.filter(Q(created_at__month=d2.month) & Q(created_at__year=d2.year) & Q(staff=staffObjects)).count()
				theTicketSeries.append({'value':monthlyTicketCount,
				                         'name':theDateValue,})
			recent10Tickets=tickets.objects.filter(staff=staffObjects).order_by('-id')[0:10]



			allUserIds = [tic.userID for tic in recent10Tickets]
			try:
				payload={}
				payload['AccessKey']=str(settings.CUSTOMER_ACCESS_KEY)
				payload['listData']=allUserIds
				url = str(settings.CUSTOMER_ACCESS_URL_OLD)+"customer/backend/getCustomerDetailsBySupport/"
				res = requests.request("POST",url,data=payload)
				res = res.json()
				# return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=501
				response['status_message']=str(e)
				return Response(response)
			# print("res['data]",res['data'])


			ticketData=[]
			for tic in recent10Tickets:
				name=''
				image=''
				if res['data']:
					for innerRow in res['data']:
						if innerRow['id']==tic.userID:
							name=innerRow['name']
							image=innerRow['image']
							break
				ticketData.append({'supportRole':tic.role.supportRole,
				                'supportType':tic.role.supportType,
								'userID':tic.userID,
								'userType':tic.userType,
								'orderID':tic.orderID,
								'ticketID':tic.ticketID,
								'status':tic.status,
								'date':tic.created_at,
								'userName':name,
								'userImage':image,
								})
			response['recent10Tickets']=ticketData
			response['theTicketSeries']=theTicketSeries
			response['status_code']=200
			response['status_message']='Success'
		except Exception as e:
			print(e)
			response['status_code']=400
			response['status_message']=str(e)
		return Response(response)

class addNotification(checkAuth):
	def __init__(self):
		pass
	def post(self, request, *args, **kwargs):
		super(addNotification,self).__init__(request)
		if self.response:return Response(response)
		try:
			if not self.data.get('title'):
				self.response['status_code']=400
				self.response['status_code']='title is required'
				return Response(self.response)
			elif not self.data.get('message'):
				self.response['status_code']=400
				self.response['status_code']='message is required'
				return Response(self.response)
			notifications.objects.create(title=self.data.get('title'),description=self.data.get('message'))
			self.response['status_code']=200
			self.response['status_message']='Success'
		except Exception as e:
			print(e)
			self.response['status_code']=400
			self.response['status_message']=str(e)
		return Response(self.response)

class getNotifications(checkAuth):
	def __init__(self):
		pass
	def post(self,request,*args,**kwargs):
		super(getNotifications,self).__init__(request)
		if self.response:return Response(response)
		try:
			allNotificationObjects=notifications.objects.filter(staff=self.staffObj)
			allData=map(lambda x:{'id':x.id,'title':x.title,'description':x.description,'date':x.created_at},allNotificationObjects)
			self.response['data']=allData
			self.response['status_code']=200
			self.response['status_message']='Success'
		except Exception as e:
			print(e)
			self.response['status_code']=400
			self.response['status_message']=str(e)
		return Response(self.response)


# delete staff notificationLis in bulk by Johan bhatti
class deleteNotificationList(checkAuth):
	def __init__(self):
		pass
	def post(self,request,*args,**kwargs):
		super(deleteNotificationList,self).__init__(request)
		if self.response:return Response(response)
		try:
			
			allNotificationObjects=notifications.objects.filter(staff=self.staffObj)
			for deleteId in self.data.get('idlist'):		
				notification = allNotificationObjects.filter(id=deleteId)
				if notification:
						notification.delete()
			self.response['status_code']=200
			self.response['status_message']='Success'		
		except Exception as e:
			print(e)
			self.response['status_code']=400
			self.response['status_message']=str(e)
		return Response(self.response)


# delete staff notification by Johan bhatti
class deleteNotification(checkAuth):
	def __init__(self):
		pass
	def post(self,request,*args,**kwargs):
		super(deleteNotification,self).__init__(request)
		if self.response:return Response(response)
		try:
			allNotificationObjects=notifications.objects.filter(staff=self.staffObj)
			notificationObj = allNotificationObjects.filter(id = self.data.get('id'))
			if notificationObj:
					notificationObj.delete()
					self.response['status_code']=200
					self.response['status_message']='Success'
			else:
				self.response['status_code']=404
				self.response['status_message']='Not Found'			
		except Exception as e:
			print(e)
			self.response['status_code']=400
			self.response['status_message']=str(e)
		return Response(self.response)


#its for filter  date notification
class filterNotifications(APIView):
	def post(self, request, *args, **kwargs):
		response={}
		data = request.data
		try:
			allData=[]
			session_token = request.META.get('HTTP_AUTHORIZATION')
			start_date = data.get('start_date',None)
			end_date = data.get('end_date', None)
			if start_date is not None and start_date != '':
				pass
			else:	
				response['status_code'] = 400
				response['status_message'] = 'start date required'
				return Response(response)
			
			if end_date is None or end_date == '':
				from datetime import timedelta
				end_date = datetime.date.today() + timedelta(days=1)
			if not session_token:
				if not data.get('session_token'):
					response['status_code']=400
					response['status_message']='Session token required'
					return Response(response)
				session_token=data.get('session_token')
			else:
				session_token = session_token.replace("Token ", "")

			userID=validateToken(session_token)
			compObjects=staff.objects.filter(userTableID=userID).first()
			if not compObjects:
				response['status_code']=400
				response['status_message']='Invalid token'
				return Response(response)
			
			allNotifications = notifications.objects.filter(staff=compObjects, created_at__range=(start_date, end_date))
			# allNotifications = companynotifications.objects.filter(companyID=compObjects.userUniqueID, created_at__range=[start_date, end_date])
			# allNotifications = companynotifications.objects.filter(companyID=compObjects.userUniqueID, created_at__range= [start_date, end_date])
			# allNotifications=companynotifications.objects.filter(created_at__gte=start_date, created_at__lte = end_date)
			for n in allNotifications:
				allData.append({
								'id':n.id,
								'title':n.title,
								'image':n.image,
								'description':n.description,
								'date':n.created_at,
								})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Success'
			return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)


