from django.db import models

# Create your models here.
from django.db import models
from base.models import *

MESSAGE_BY = [
    ('ME', 'ME'),
    ('SUPPORT', 'SUPPORT'),
]

TICKET_STATUS = [
    ('PENDING', 'PENDING'),
    ('INPROGRESS', 'INPROGRESS'),
	('CLOSED', 'CLOSED'),
]

MESSAGE_TYPE = [
    ('TEXT', 'TEXT'),
    ('IMAGE', 'IMAGE'),
]

class tickets(models.Model):
	role= models.ForeignKey(supportroles, on_delete=models.CASCADE,default='',null=True)
	team= models.ForeignKey(team, on_delete=models.CASCADE,default='',null=True)
	staff= models.ForeignKey(staff, on_delete=models.CASCADE,default='',null=True)
	title = models.CharField(max_length = 50, null = True, blank = True)
	ticketID = models.CharField(max_length = 25, null = True, blank = True)
	userID = models.CharField(max_length = 25, null = True, blank = True)
	userType = models.CharField(max_length = 25, null = True, blank = True)
	orderID = models.CharField(max_length = 25, null = True, blank = True)
	latitude = models.FloatField(max_length = 20, blank = True, null = True)
	longitude = models.FloatField(max_length = 20, blank = True, null = True)
	status = models.CharField(max_length=20,choices=TICKET_STATUS,default='PENDING',)
	isAssigned = models.BooleanField(default = False)
	isdisabled = models.BooleanField(default = False)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.ticketID)+'-'+str(self.title))

class ticketchat(models.Model):
	ticket = models.ForeignKey(tickets, on_delete=models.CASCADE,default='',null=True)
	message = models.TextField()
	messageBy = models.CharField(max_length=20,choices=MESSAGE_BY,default='ME',)
	messageType = models.CharField(max_length=20,choices=MESSAGE_TYPE,default='TEXT',)
	isdeleted = models.BooleanField(default = False)
	created_at = models.DateTimeField(auto_now_add = True)

	def __str__(self):
		return str(str(self.ticket)+'-'+str(self.messageBy))