from django.shortcuts import render
from django.template.defaultfilters import first
import requests
# Create your views here.
from rest_framework.views import APIView
from rest_framework.response import Response
from django.contrib.auth import login,authenticate
from .models import *
from base.models import *
from django.contrib.auth.models import User
from rest_framework.authtoken.models import Token
import datetime
import math, random, datetime, pytz, string
from django.conf import settings

def GernateOTP():
	digits = "0123456789"
	OTP = ""
	for i in range(4) :
		OTP += digits[math.floor(random.random() * 10)]
	return OTP

class getRoleByCustomer(APIView):
	def get(self, request):
		response={}
		try:
			allRoles=[]
			allRolesObject = supportroles.objects.filter(isdisabled=False)
			for alR in allRolesObject:
				allRoles.append({'supportRole':alR.supportRole,
								 'supportType':alR.supportType})
			response['data']=allRoles
			response['status_code']=200
			response['status_message']='All Roles'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def gernateTicketID():
	import random, string
	import datetime
	dt=datetime.datetime.now()
	yr=dt.year
	strDate=str(yr)
	strLetters = ''.join((random.choice(string.ascii_letters) for x in range(4)))
	strNumbers = ''.join((random.choice(string.digits) for x in range(2)))
	strLetters=strLetters.upper()
	finalString=strDate+strLetters+str(strNumbers)
	return finalString

class addTicketByCustomer(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Invalid access key'
				return Response(response)
			if not data.get('supportRole'):
				response['status_code']=400
				response['status_message']='supportRole required'
				return Response(response)
			if not data.get('supportType'):
				response['status_code']=400
				response['status_message']='supportType required'
				return Response(response)
			if not data.get('title'):
				response['status_code']=400
				response['status_message']='title required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='message required'
				return Response(response)
			
			if not data.get('messageType'):
				response['status_code']=400
				response['status_message']='messageType required'
				return Response(response)

			if not data.get('userID'):
				response['status_code']=400
				response['status_message']='userID required'
				return Response(response)
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='userType required'
				return Response(response)

			# if not data.get('orderID'):
			# 	response['status_code']=400
			# 	response['status_message']='orderID required'
			# 	return Response(response)
			if not data.get('longitude'):
				response['status_code']=400
				response['status_message']='longitude required'
				return Response(response)
			if not data.get('latitude'):
				response['status_code']=400
				response['status_message']='latitude required'
				return Response(response)
			if data.get('orderID'):
				theOrderID=data.get('orderID')
			else:
				theOrderID=''
			theRole = supportroles.objects.filter(supportRole=data.get('supportRole'),supportType=data.get('supportType')).first()
			if not theRole:
				response['status_code']=400
				response['status_message']='Invalid role'
				return Response(response)
			ticketID=gernateTicketID()
			lat=data.get('latitude')
			lng=data.get('longitude')
			distanceInMiles=310
			# query="SELECT * FROM (SELECT id, name, (3959 * acos(cos(radians("+str(lat)+")) * cos(radians(latitude)) * cos(radians(longitude) - radians("+str(lng)+")) + sin(radians("+str(lat)+")) * sin(radians(latitude)))) AS distance FROM base_team) AL WHERE latitude >= "+str(lat)+" OR longitude >= "+str(lng)+" AND latitude <= "+str(lat)+" OR longitude <= "+str(lng)+" ORDER BY distance LIMIT 3;"
			query="SELECT * FROM (SELECT id, name, (3959 * acos(cos(radians("+str(lat)+")) * cos(radians(latitude)) * cos(radians(longitude) - radians("+str(lng)+")) + sin(radians("+str(lat)+")) * sin(radians(latitude)))) AS distance FROM base_team) AS distances WHERE distance < "+str(distanceInMiles)+" ORDER BY distance OFFSET 0 LIMIT 20;"
			queryset = team.objects.raw(query)
			if not queryset:
				response['status_code']=400
				response['status_message']='Oops! currently we have not any active support team nearby your location.'
				return Response(response)
			theData=[i for i in queryset if i.role==theRole]
			# theTeam=theData[0]

			theTeam=''
			for theteamOBJ in theData:
				allStaffObjects=staff.objects.filter(role=theRole,team=theteamOBJ)
				if allStaffObjects:
					theTeam=theteamOBJ
					break
			
			if theTeam!='' and allStaffObjects:
				pass
			else:
				response['status_code']=400
				response['status_message']='Oops! currently we have not any active staff member for your ticket role.'
				return Response(response)

			theTicket=tickets.objects.create(team=theTeam,ticketID=ticketID,role=theRole,title=data.get('title'),userID=data.get('userID'),userType=data.get('userType'),orderID=theOrderID,latitude=lat,longitude=lng)
			ticketchat.objects.create(ticket=theTicket,message=data.get('message'),messageBy='ME',messageType=data.get('messageType'))
			
			# allStaffObjects=staff.objects.filter(role=theRole,team=theTeam)
			theMainStaffID=''
			allTicketCount=0
			checkingFirst=True
			for staffO in allStaffObjects:
				ticketCount=tickets.objects.filter(staff=staffO).count()
				if checkingFirst==True:
					theMainStaffID=staffO.userUniqueID
					allTicketCount=ticketCount
					checkingFirst==True
				if ticketCount==0:
					theMainStaffID=staffO.userUniqueID
					break
				else:
					if allTicketCount>ticketCount:
						theMainStaffID=staffO.userUniqueID
						allTicketCount=ticketCount
			
			finalStaffObject=staff.objects.filter(userUniqueID=theMainStaffID).first()
			if finalStaffObject:
				theTicket.staff=finalStaffObject
				theTicket.isAssigned=True
				theTicket.save()
				notifications.objects.create(staff=finalStaffObject,title='New Ticket',description='A new ticket has been assigned to you')
			response['status_code']=200
			response['status_message']='Ticket created successfully'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getTicketByCustomer(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Invalid access key'
				return Response(response)
			if not data.get('userID'):
				response['status_code']=400
				response['status_message']='userID required'
				return Response(response)
			if not data.get('userType'):
				response['status_code']=400
				response['status_message']='userType required'
				return Response(response)
			allData=[]
			allTickets=tickets.objects.filter(userID=data.get('userID'),userType=data.get('userType'))
			for tic in allTickets:
				theDate=tic.created_at
				import datetime
				theDate=theDate.strftime("%b %d, %Y")
				allData.append({'supportRole':tic.role.supportRole,
				                'supportType':tic.role.supportType,
								'title':tic.title,
								'userID':tic.userID,
								'userType':tic.userType,
								'orderID':tic.orderID,
								'ticketID':tic.ticketID,
								'status':tic.status,
								'date':theDate,
								'created_at':tic.created_at,
								})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Ticket list'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getTicketChatByCustomer(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Invalid access key'
				return Response(response)
			if not data.get('ticketID'):
				response['status_code']=400
				response['status_message']='ticketID required'
				return Response(response)
			allData=[]
			tic=tickets.objects.filter(ticketID=data.get('ticketID')).first()
			chatData=[]
			allChats=ticketchat.objects.filter(ticket=tic)
			for ch in allChats:
				chatData.append({'messageBy':ch.messageBy,
				                 'messageType':ch.messageType,
				                 'message':ch.message,
								 'messageType':ch.messageType,})
			allData.append({'supportRole':tic.role.supportRole,
							'supportType':tic.role.supportType,
							'title':tic.title,
							'userID':tic.userID,
							'userType':tic.userType,
							'orderID':tic.orderID,
							'status':tic.status,
							'chat':chatData,
							})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Ticket Data'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class addMessageByCustomer(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('AccessKey'):
				response['status_code']=400
				response['status_message']='AccessKey required'
				return Response(response)
			
			if data.get('AccessKey')!=str(settings.MY_ACCESS_KEY):
				response['status_code']=400
				response['status_message']='Invalid access key'
				return Response(response)
			if not data.get('ticketID'):
				response['status_code']=400
				response['status_message']='ticketID required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='message required'
				return Response(response)
			
			if not data.get('messageType'):
				response['status_code']=400
				response['status_message']='messageType required'
				return Response(response)
			allData=[]
			tic=tickets.objects.filter(ticketID=data.get('ticketID')).first()
			if not tic:
				response['status_code']=400
				response['status_message']='Invalid ticket'
				return Response(response)
			chatData=[]
			theChat=ticketchat.objects.create(ticket=tic,messageBy='ME',message=data.get('message'),messageType=data.get('messageType'))
			allChats=ticketchat.objects.filter(ticket=tic)
			for ch in allChats:
				chatData.append({'messageBy':ch.messageBy,
				                 'message':ch.message,
								 'messageType':ch.messageType,})
			allData.append({'supportRole':tic.role.supportRole,
							'supportType':tic.role.supportType,
							'title':tic.title,
							'userID':tic.userID,
							'userType':tic.userType,
							'orderID':tic.orderID,
							'status':tic.status,
							'chat':chatData,
							})
			if tic.staff:notifications.objects.create(staff=tic.staff,title='New Message',description='A new message has been added by customer on '+str(tic.ticketID)+' ticket')
			response['data']=allData
			response['status_code']=200
			response['status_message']='Ticket Data'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

def validateToken(theToken):
	returnId='0'
	tokenOBJ = Token.objects.filter(key = theToken).first()
	if tokenOBJ:
		user = User.objects.get(id = tokenOBJ.user_id)
	if user:
		returnId=user.id
	return returnId

class getTicketsBySupport(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			staffObjects=staff.objects.filter(token=data.get('session_token')).first()
			if not staffObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			allData=[]
			allTickets=tickets.objects.filter(team=staffObjects.team,isAssigned=False)

			allUserIds = [tic.userID for tic in allTickets]
			tempJSON={'list':allUserIds}
			try:
				payload={}
				payload['AccessKey']=str(settings.CUSTOMER_ACCESS_KEY)
				payload['listData']=tempJSON
				url = str(settings.CUSTOMER_ACCESS_URL_OLD)+"customer/backend/getCustomerDetailsBySupport/"
				res = requests.request("POST",url,data=payload)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
			
			for tic in allTickets:
				for innerRow in res['data']:
					name=''
					image=''
					if innerRow['id']==tic.userID:
						name=tic.name
						image=tic.image

				allData.append({'supportRole':tic.role.supportRole,
				                'supportType':tic.role.supportType,
								'userID':tic.userID,
								'userName':name,
								'title':tic.title,
								'userImage':image,
								'userType':tic.userType,
								'orderID':tic.orderID,
								'ticketID':tic.ticketID,
								'status':tic.status,
								'date':tic.created_at,
								})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Ticket list'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getTicketsDetailsBySupport(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			staffObjects=staff.objects.filter(token=data.get('session_token')).first()
			if not staffObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('ticketID'):
				response['status_code']=400
				response['status_message']='ticketID required'
				return Response(response)
			allData=[]
			chatData=[]
			tic=tickets.objects.filter(team=staffObjects.team,ticketID=data.get('ticketID')).first()
			allChats=ticketchat.objects.filter(ticket=tic)
			for ch in allChats:
				chatData.append({'messageBy':ch.messageBy,
				                 'message':ch.message,
								 'messageType':ch.messageType,
								 'date':ch.created_at,})
			
			allUserIds=[]
			allUserIds.append(tic.userID)
			try:
				payload={}
				payload['AccessKey']=str(settings.CUSTOMER_ACCESS_KEY)
				payload['listData']=allUserIds
				url = str(settings.CUSTOMER_ACCESS_URL_OLD)+"customer/backend/getCustomerDetailsBySupport/"
				res = requests.request("POST",url,data=payload)
				res=res.json()
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
			
			name=''
			image=''
			if res['data'][0]['id']==tic.userID:
				name=res['data'][0]['name']
				image=res['data'][0]['image']
			allData.append({'supportRole':tic.role.supportRole,
							'supportType':tic.role.supportType,
							'title':tic.title,
							'userID':tic.userID,
							'userType':tic.userType,
							'orderID':tic.orderID,
							'status':tic.status,
							'chat':chatData,
							'date':tic.created_at,
							'userName':name,
							'userImage':image,
							})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Ticket Data'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class replyOnTicketBySupport(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			staffObjects=staff.objects.filter(token=data.get('session_token')).first()
			if not staffObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('ticketID'):
				response['status_code']=400
				response['status_message']='ticketID required'
				return Response(response)
			if not data.get('message'):
				response['status_code']=400
				response['status_message']='message required'
				return Response(response)
			
			if not data.get('messageType'):
				response['status_code']=400
				response['status_message']='messageType required'
				return Response(response)
			allData=[]
			tic=tickets.objects.filter(ticketID=data.get('ticketID')).first()
			if not tic:
				response['status_code']=400
				response['status_message']='Invalid ticket'
				return Response(response)
			chatData=[]
			theChat=ticketchat.objects.create(ticket=tic,messageBy='SUPPORT',message=data.get('message'),messageType=data.get('messageType'))
			allChats=ticketchat.objects.filter(ticket=tic)
			for ch in allChats:
				chatData.append({'messageBy':ch.messageBy,
				                 'messageType':ch.messageType,
				                 'message':ch.message,
								 'messageType':ch.messageType,})
			allData.append({'supportRole':tic.role.supportRole,
							'supportType':tic.role.supportType,
							'title':tic.title,
							'userID':tic.userID,
							'userType':tic.userType,
							'orderID':tic.orderID,
							'status':tic.status,
							'chat':chatData,
							})
			try:
				url = str(settings.CUSTOMER_ACCESS_URL)+"customer/backend/sendPushNotificationsFromOthers/"
				theToken=str(settings.CUSTOMER_ACCESS_KEY)
				payload={'AccessKey':theToken,
						 'title':'New Message',
						 'message':'You have recevied a new message from support team.'}
				apiResponse = requests.request("POST", url, data=payload)
				r=apiResponse.json()
			except Exception as e:
				print(e)
			response['data']=allData
			response['status_code']=200
			response['status_message']='Ticket Data'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class changeStatusOfTicketBySupport(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			staffObjects=staff.objects.filter(token=data.get('session_token')).first()
			if not staffObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			if not data.get('ticketID'):
				response['status_code']=400
				response['status_message']='ticketID required'
				return Response(response)
			if not data.get('status'):
				response['status_code']=400
				response['status_message']='status required'
				return Response(response)
			allData=[]
			tic=tickets.objects.filter(ticketID=data.get('ticketID')).first()
			if not tic:
				response['status_code']=400
				response['status_message']='Invalid ticket'
				return Response(response)
			if data.get('status')=='Accept':
				tic.status='INPROGRESS'
				# tic.isAssigned=True
				# tic.staff=staffObjects
				tic.save()
			elif data.get('status')=='Close':
				tic.status='CLOSED'
				tic.save()
				try:
					url = str(settings.CUSTOMER_ACCESS_URL)+"customer/backend/sendPushNotificationsFromOthers/"
					theToken=str(settings.CUSTOMER_ACCESS_KEY)
					payload={'AccessKey':theToken,
							'title':'Ticket Closed',
							'message':'Your ticket has been closed by support team.'}
					apiResponse = requests.request("POST", url, data=payload)
					r=apiResponse.json()
				except Exception as e:
					print(e)

			else:
				response['status_code']=400
				response['status_message']='Invalid status'
				return Response(response)
			response['status_code']=200
			response['status_message']='Status change'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

class getMyTicketsBySupport(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			staffObjects=staff.objects.filter(token=data.get('session_token')).first()
			if not staffObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			allData=[]
			if not data.get('search') or data.get('search')=='':
				if not data.get('status'):
					allTickets=tickets.objects.filter(team=staffObjects.team,staff=staffObjects)
				else:
					allTickets=tickets.objects.filter(team=staffObjects.team,staff=staffObjects,status=data.get('status'))
			else:
				if not data.get('status'):
					allTickets=tickets.objects.filter(ticketID__icontains=data.get('search'),team=staffObjects.team,staff=staffObjects)
				else:
					allTickets=tickets.objects.filter(ticketID__icontains=data.get('search'),team=staffObjects.team,staff=staffObjects,status=data.get('status'))
			
			allUserIds = [tic.userID for tic in allTickets]
			print("allUSERIDS",allUserIds)
			print("allTickets",allTickets)
			tempJSON={'list':allUserIds}
			try:
				payload={}
				payload['AccessKey']=str(settings.CUSTOMER_ACCESS_KEY)
				payload['listData']=allUserIds
				url = str(settings.CUSTOMER_ACCESS_URL_OLD)+"customer/backend/getCustomerDetailsBySupport/"
				res = requests.request("POST",url,data=payload)
				res = res.json()
				# return Response(res)
			except Exception as e:
				print(e)
				response['status_code']=501
				response['status_message']=str(e)
				return Response(response)
			print("res['data]",res['data'])
			for tic in allTickets:
				name=''
				image=''
				for innerRow in res['data']:
					if innerRow['id']==tic.userID:
						name=innerRow['name']
						image=innerRow['image']
						break

				allData.append({'supportRole':tic.role.supportRole,
				                'supportType':tic.role.supportType,
								'userID':tic.userID,
								'userName':name,
								'userImage':image,
								'userType':tic.userType,
								'orderID':tic.orderID,
								'ticketID':tic.ticketID,
								'status':tic.status,
								'date':tic.created_at,
								'title':tic.title,
								})
			response['data']=allData
			response['status_code']=200
			response['status_message']='Ticket list'
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)

import random,string
def randomStringFunctionForImage():
  str1 = ''.join((random.choice(string.ascii_letters) for x in range(10)))
  str2 = ''.join((random.choice(string.digits) for x in range(6)))
  str2=str2.lower()
  str1=str1+str2
  sam_list = list(str1)
  random.shuffle(sam_list)
  finalString = ''.join(sam_list)
  return finalString

def uploadMessageImage(image):
	import os
	import boto3
	response={}
	from botocore.exceptions import NoCredentialsError
	try:
		ACCESS_KEY=str(settings.AWS_ACCESS_KEY_ID)
		SECRET_KEY=str(settings.AWS_SECRET_ACCESS_KEY)
		s3 = boto3.client('s3', aws_access_key_id=ACCESS_KEY,
                      aws_secret_access_key=SECRET_KEY)
		try:
			bucket='cannabisadminsupport'
			thePath='messagemedia'
			filetype = os.path.splitext(image.name)[1]
			imageName=randomStringFunctionForImage()
			thePath=thePath+'/'+imageName+'.'+filetype
			thePath=thePath.replace('..','.')
			thePath=str(thePath)
			theFile=s3.upload_fileobj(image,bucket,thePath)
			print("Upload Successful")
			filename=str(settings.AWS_BUCKET_URL_1)+str(bucket)+str(settings.AWS_BUCKET_URL_2)+thePath
			response['status_code']=200
			response['status_message']='Image uploded'
			response['imageUrl']=filename
			return response
		except FileNotFoundError as e:
			print("The file was not found")
			response['status_code']=400
			response['status_message']='The file was not found'
			return response
		except NoCredentialsError as e:
			print("Credentials not available")
			response['status_code']=400
			response['status_message']='Credentials not available'
			return response
	except Exception as e:
		print(e)
		response['status_code']=500
		response['status_message']=str(e)
		return response

class uploadMessageAttachment(APIView):
	def post(self, request, *args , **kwargs):
		response={}
		try:
			data=request.data
			if not data.get('session_token'):
				response['status_code']=400
				response['status_message']='session_token required'
				return Response(response)
			staffObjects=staff.objects.filter(token=data.get('session_token')).first()
			if not staffObjects:
				response['status_code']=400
				response['status_message']='Invalid Credentials'
				return Response(response)
			image=request.FILES.get('image')
			if not image:
				response['status_code']=400
				response['status_message']='image required'
				return Response(response)
			try:
				theReturnJson=uploadMessageImage(image)
				return Response(theReturnJson)
			except Exception as e:
				print(e)
				response['status_code']=500
				response['status_message']=str(e)
				return Response(response)
		except Exception as e:
			response['status_code']=500
			response['status_message']=str(e)
		return Response(response)