# from email import message
# from django.shortcuts import render
from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
from .models import *
# from datetime import datetime, timedelta, date
from django.conf import settings
# from .authentication import authenticated
# from django.contrib.auth.models import User
from .models import User
from rest_framework_simplejwt.tokens import RefreshToken
from passlib.hash import django_pbkdf2_sha256 as handler
from django.template.loader import render_to_string
from django.core import mail
# from django.core.mail import EmailMultiAlternatives
import math, random, pytz, string
# from django.contrib import messages
# import jwt
# from django.core.files.storage import FileSystemStorage
# import os
# import ast
# from django.db.models import Q
# from pyfcm import FCMNotification
# from .serializers import *
# from django.views.generic import TemplateView
# from admin_panel.models import ContentManagement,OnBoardingData,AdminNotifications
# from trainer.models import *
# from trainer.serializers import *
# from .functions import *
# from django.utils.timesince import timesince
# from rest_framework import viewsets
# from admin_panel.models import DiscoverMainCategory,DiscoverSubCategory
# from trainer.serializers import *
# from rest_framework_simplejwt.authentication import JWTAuthentication
# from rest_framework.permissions import IsAuthenticated
# import os
# from twilio.rest import Client
from django.conf import settings
# from twilio.jwt.access_token import AccessToken
# from twilio.jwt.access_token.grants import ChatGrant
# import json
import stripe
# from decouple import config



class Register(APIView):
	def post(self, request):
		try:
			data = request.data
			full_name = data.get('full_name')
			email = data.get('email')
			email=email.lower()
			print(email)
			password = data.get('password')
			

			# Input validation
			if not email or not full_name or not password:
				return Response({"message": 'All required fields must be provided'}, status=status.HTTP_400_BAD_REQUEST)

			# Password hashing
			new_password = handler.hash(password)

			# Check if the email is already registered
			app_user_obj = User.objects.filter(email=email).first()
			if app_user_obj:
				return Response({"message": "The email is already registered"}, status=status.HTTP_409_CONFLICT)
			else:

				# Create User instance
				the_otp=random.randrange(1000, 9999, 5)
				app_user_obj = User.objects.create(
					full_name=full_name,
					email=email,
					password=new_password,
					otp=the_otp
				)

				# UserNotifications.objects.create(message="You have received your referral bonus successfully", notification_type="referral_bonus", app_user=app_user_obj)

				# Email verification
				app_user_obj.otp = the_otp
				app_user_obj.save()
				subject = "Verify Account"
				html_message = render_to_string('email_verification.html', {'otp': the_otp})
				plain_message = html_message
				from_email = settings.EMAIL_HOST_USER
				to = email
				# mail.send_mail(subject, plain_message, from_email, [to], html_message=html_message)

				try:
					mail.send_mail(subject, plain_message, from_email, [to], html_message=html_message)
				except Exception as email_error:
					return Response({"message": "Your account has been created, but we encountered an issue sending the verification email. Please contact support for assistance."}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

				# Admin notification
				# AdminNotifications.objects.create(message=full_name + ' has been successfully registered with us.', type='app_user_register')

			return Response({"message": 'You have been successfully registered with us. Please verify your email.'})
		except Exception as e:
			return Response({"message": str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class SocialLogin(APIView):
	def post(self, request):
		try:
			data = request.data
			provider_id = data.get('provider_id')
			email = data.get('email')
			full_name = data.get('full_name')
			social_id = data.get('social_id')
			device_type = data.get('device_type')
			fcm_token = data.get('fcm_token')

			if not provider_id or not social_id:
				return Response({'message': 'Provider and social_id are required.'}, status=status.HTTP_400_BAD_REQUEST)
			if not full_name:
				return Response({'message': 'full_name is required'}, status=status.HTTP_400_BAD_REQUEST)
			if not email:
				return Response({'message': 'email is required'}, status=status.HTTP_400_BAD_REQUEST)
			if not social_id:
				return Response({'message': 'email is required'}, status=status.HTTP_400_BAD_REQUEST)
			if not device_type:
				return Response({'message': 'device_type is required'}, status=status.HTTP_400_BAD_REQUEST)
			if not fcm_token:
				return Response({'message': 'fcm_token is required'}, status=status.HTTP_400_BAD_REQUEST)

			# Check if social account already exists in the database
			app_user_obj = User.objects.filter(social_id=social_id).first()
			if not app_user_obj:
				# If social account not found, create a new one
				app_user_obj = User.objects.create(full_name=full_name, social_id=social_id,
					  provider_id=provider_id,email=email,device_type=device_type,fcm_token=fcm_token)

			# Issue tokens (refresh token and access token) for the authenticated user
			refresh_token = RefreshToken.for_user(app_user_obj)

			allData={'id':app_user_obj.id,
					'full_name':app_user_obj.full_name,
					'email':app_user_obj.email,
					'is_profile_completed':app_user_obj.is_profile_completed,
					'refresh': str(refresh_token),
					'access': str(refresh_token.access_token),
				   }

			return Response({'message': 'Success', 'data': allData})
		except Exception as e:
			return Response({'message': str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)



class OtpVerification(APIView):
	def post(self,request):
		try:
			data=request.data
			email = data.get('email')
			otp = data.get('otp')
			if not email:
				return Response({"message":'email is required'},status=status.HTTP_400_BAD_REQUEST)
			if not otp:
				return Response({"message":'otp is required'},status=status.HTTP_400_BAD_REQUEST)
			try:
				app_user_obj = User.objects.get(email=email,otp=otp)
			except Exception as e:
				return Response({"message":'Invalid otp','data':{}},status=status.HTTP_400_BAD_REQUEST)
			
			stripe.api_key = "sk_test_ui9wRiY8QFwIw8q5M5xhubGP"
			create_data=stripe.Customer.create(
			name=app_user_obj.full_name,
			email=app_user_obj.email,
			)
			app_user_obj.stripe_id = create_data['id']
			app_user_obj.email_verified = True
			app_user_obj.save()
			refresh_token = RefreshToken.for_user(app_user_obj)
			allData={'id':app_user_obj.id,
				'full_name':app_user_obj.full_name,
				'email':app_user_obj.email,
				'is_profile_completed':app_user_obj.is_profile_completed,
				'refresh': str(refresh_token),
				'access': str(refresh_token.access_token),
				}
			# AdminNotifications.objects.create(message = "A new user "+ app_user_obj.full_name +" has been registered successfully with us.",type = "user_registered")
			# return Response({"message":'Success','data':allData})
		except Exception as e:
			return Response({"message":str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class LoginUser(APIView):
	def post(self,request):
		try:
			data = request.data
			email = data.get('email')
			email=email.lower()
			password = data.get('password')
			# fcm_token = data.get('fcm_token')
			# device_type = data.get('device_type')
			if not email:
				return Response({"message":'email is required'},status=status.HTTP_400_BAD_REQUEST)
			if not password:
				return Response({"message":'password is required'},status=status.HTTP_400_BAD_REQUEST)
			user  = User.objects.filter(email=email).count()
			if user == 0:
				return Response({"message":'This email does not exist in our database, please register'},status=status.HTTP_404_NOT_FOUND)
			app_user_obj  = User.objects.filter(email=email,status=True,end_date__isnull=True).first()
			if not app_user_obj:
				return Response({"message":'Your account has not been activated, Please contact to admin.'},status=status.HTTP_401_UNAUTHORIZED)
			check_password = app_user_obj.password
			check = handler.verify(password,check_password)

			# if check:
			# 	if app_user_obj.email_verified == False:
			# 		# Email verification
			# 		the_otp=random.randrange(1000, 9999, 5)
			# 		app_user_obj.otp = the_otp
			# 		app_user_obj.save()
			# 		subject = "Verify Account"
			# 		html_message = render_to_string('email_verification.html', {'otp': the_otp})
			# 		plain_message = html_message
			# 		from_email = settings.EMAIL_HOST_USER
			# 		to = email
			# 		# mail.send_mail(subject, plain_message, from_email, [to], html_message=html_message)

			# 		try:
			# 			mail.send_mail(subject, plain_message, from_email, [to], html_message=html_message)
			# 		except Exception as email_error:
			# 			return Response({"message": "Failed to send the verification email. Please try again later."}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

			# 		return Response({"message":'Please verify your email first'},status=status.HTTP_400_BAD_REQUEST)
			# 	# app_user_obj.fcm_token = fcm_token
			# 	# app_user_obj.device_type  =device_type
			# 	# app_user_obj.save()
			refresh_token = RefreshToken.for_user(app_user_obj)
			allData={'id':app_user_obj.id,
				'full_name':app_user_obj.full_name,
				'email':app_user_obj.email,
				'is_profile_completed':app_user_obj.is_profile_completed,
				'refresh': str(refresh_token),
				'access': str(refresh_token.access_token),
				}
			return Response({"message":'Login Successfully','data':allData})
			# else:
			# 	return Response({"message":'Invalid password'},status=status.HTTP_401_UNAUTHORIZED)
		except Exception as e:
			return Response({"message":str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)


class ForgetPassword(APIView):
	def post(self,request):
			try:
				data = request.data
				email = data.get('email')
				if not email:
					return Response({"message":'Email is required'})
				user  = User.objects.filter(email=email).count()
				if user == 0:
					return Response({"message":'This email does not exist in our database, please enter the valid email address.'},status=status.HTTP_404_NOT_FOUND)
				app_user_obj  = User.objects.filter(email=email).first()
				if app_user_obj:
					the_otp=random.randrange(1000, 9999, 5)
					app_user_obj.otp = the_otp
					app_user_obj.save()
					subject = 'Forgot Password'
					html_message = render_to_string('forget_password_email.html', {'otp': the_otp})
					plain_message = html_message
					from_email = settings.EMAIL_HOST_USER
					to = email
					# mail.send_mail(subject, plain_message, from_email, [to], html_message=html_message)

					try:
						mail.send_mail(subject, plain_message, from_email, [to], html_message=html_message)
					except Exception as email_error:
						return Response({"message": "Failed to send the verification email. Please try again later."}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)

					return Response({"message":'Reset password otp has been sent to your email address.'})
				else:
					return Response({"message":'Email not exists'})

			except Exception as e:
				print(e)
				return Response({"message":str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)



class ForgetPasswordVerification(APIView):
	def post(self,request):
		try:
			data=request.data
			email = data.get('email')
			otp = data.get('otp')
			if not email:
				return Response({"message":'email is required'},status=status.HTTP_400_BAD_REQUEST)
			if not otp:
				return Response({"message":'otp is required'},status=status.HTTP_400_BAD_REQUEST)

			app_user_obj = User.objects.filter(email=email,otp=otp).first()
			if not app_user_obj:
				return Response({"message":'Invalid otp','data':{}},status=status.HTTP_400_BAD_REQUEST)

			return Response({"message":'Success'})
		except Exception as e:
			return Response({"message":str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)

class SetForgetPassword(APIView):
	def post(self,request):
		try:
			data=request.data
			email = data.get('email')
			new_password = data.get('new_password')
			otp = data.get('otp')
			if not new_password:
				return Response({"message":'new_password is required'},status=status.HTTP_400_BAD_REQUEST)
			if not email:
				return Response({"message":'email is required'},status=status.HTTP_400_BAD_REQUEST)
			if not otp:
				return Response({"message":'otp is required'},status=status.HTTP_400_BAD_REQUEST)

			app_user_obj = User.objects.filter(email=email,otp=otp).first()
			encrypt_password = handler.hash(new_password)
			if app_user_obj:
				app_user_obj.password = encrypt_password
				app_user_obj.otp = None
				app_user_obj.save()
				return Response({"message":'Success'})
			else:
				return Response({"message":'Something went wrong'},status=status.HTTP_400_BAD_REQUEST)
		except Exception as e:
			return Response({"message":str(e)},status=status.HTTP_500_INTERNAL_SERVER_ERROR)

# Create your views here.
