from django.conf import settings
from rest_framework.routers import DefaultRouter, SimpleRouter

from verify_trusted.common.api.viewsets import MetaViewSet
from verify_trusted.companies.api.viewsets import (
    CompanyCategoryViewSet,
    CompanyURLLookUpViewSet,
    CompanyViewSet,
    SourceSocialViewSet,
)
from verify_trusted.companies.api.viewsets.changelog import (
    CompanyHistoryViewSet,
    ReviewHistoryViewSet,
)
from verify_trusted.companies.api.viewsets.payment import CompanyPaymentViewSet
from verify_trusted.companies.api.viewsets.plan import AdminPlanViewSet, PlanViewSet
from verify_trusted.companies.api.viewsets.review import ReviewViewSet
from verify_trusted.reviews.api.viewsets import (
    AdminPlatformViewSet,
    PlatformViewSet,
    ReviewSourceHistoryViewSet,
    ReviewSourceViewSet,
)
from verify_trusted.users.api.views import (
    AdminUserViewSet,
    CurrentUserViewSet,
    UserRegistrationViewSet,
)
from verify_trusted.users.api.views.admin import AdminCompanyViewSet
from verify_trusted.widgets.api.viewsets import SealViewSet, WidgetViewSet
from django.urls import path

router = DefaultRouter() if settings.DEBUG else SimpleRouter()
# User
router.register('me', CurrentUserViewSet)
router.register('payment', CompanyPaymentViewSet)

# Admin
router.register('admin/users', AdminUserViewSet)
router.register('admin/platforms', AdminPlatformViewSet)
router.register('admin/plans', AdminPlanViewSet)

router.register('users/register', UserRegistrationViewSet)
router.register('reviews', ReviewViewSet)
router.register('source-social', SourceSocialViewSet)
router.register('platforms', PlatformViewSet)
router.register('review-sources', ReviewSourceViewSet)
router.register('widgets', WidgetViewSet)
router.register('seal', SealViewSet)
router.register('plans', PlanViewSet)

# Companies
# Lookup by `pk` & `url`
router.register('companies', CompanyViewSet)
router.register('companies', CompanyURLLookUpViewSet)
router.register('company-changelogs', CompanyHistoryViewSet, basename='changelog')
router.register(
    'review-source-changelogs',
    ReviewSourceHistoryViewSet,
    basename='review-source-changelog',
)
router.register('review-changelogs', ReviewHistoryViewSet, basename='review-changelog')
router.register('admin/companies', AdminCompanyViewSet)
router.register('all-categories', CompanyCategoryViewSet)


# About, Terms of use, etc.
router.register('meta', MetaViewSet, basename='meta')

urlpatterns = [
    # ... other URL patterns ...
    path("company", CompanyURLLookUpViewSet.as_view({"get": "get_companies_by_urls"})),
    path("company/reviews", CompanyURLLookUpViewSet.as_view({"get": "get_company_reviews_by_urls"})),
    path("company/review-source", CompanyURLLookUpViewSet.as_view({"get": "get_company_review_sources_by_urls"})),
]

app_name = 'api'
urlpatterns += router.urls
