from django.conf import settings
from django.conf.urls import url
from django.conf.urls.static import static
from django.contrib import admin
from django.contrib.sitemaps.views import index, sitemap
from django.urls import include, path
from django.views import defaults as default_views
from django.views.decorators.cache import cache_page
from django.views.generic import TemplateView
from drf_yasg import openapi
from drf_yasg.views import get_schema_view
from rest_framework import permissions
from rest_framework_simplejwt.views import TokenBlacklistView, TokenRefreshView

from verify_trusted.common.sitemap import CompanySiteMap, custom_index
from verify_trusted.companies.api.viewsets.stripe import stripe_webhook_view
from verify_trusted.users.api.views import test_welcome_email, user_verify_email, send_reminder
from verify_trusted.users.api.views.me import contact_view,shopify_url_view,check_shopify_url_view,logout_shopify_url_view,purchase_plan_url_view,recurring_plan_url_view
from verify_trusted.users.views import user_token_obtain_pair_view
from verify_trusted.widgets.api.viewsets import SealViewSet, WidgetViewSet
from verify_trusted.companies.api.viewsets.plan import AdminSubscriptionViewSet


schema_view = get_schema_view(
    openapi.Info(
        title="Snippets API",
        default_version='v1',
        description="Test description",
        terms_of_service="https://www.google.com/policies/terms/",
        contact=openapi.Contact(email="contact@snippets.local"),
        license=openapi.License(name="BSD License"),
    ),
    public=True,
    permission_classes=(permissions.AllowAny,),
)

sitemaps = {'company': CompanySiteMap}

# def trigger_error(request):
#     division_by_zero = 1 / 0

urlpatterns = [
    path("", TemplateView.as_view(template_name="pages/home.html"), name="home"),
    path(
        "checkout/",
        TemplateView.as_view(template_name="pages/checkout.html"),
        name="checkout",
    ),
    # path('sentry-debug/', trigger_error),
    path(
        "about/", TemplateView.as_view(template_name="pages/about.html"), name="about"
    ),
    # Django Admin, use {% url 'admin:index' %}
    path(settings.ADMIN_URL, admin.site.urls),
    # User management
    path("users/", include("verify_trusted.users.urls", namespace="users")),
    path("accounts/", include("allauth.urls")),
    # Your stuff: custom urls includes go here
]
urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
# Swagger
if not settings.IS_PRODUCTION:
    # Disable Swagger in production
    urlpatterns += [
        url(
            r'^swagger(?P<format>\.json|\.yaml)$',
            schema_view.without_ui(cache_timeout=0),
            name='schema-json',
        ),
        url(
            r'^swagger/$',
            schema_view.with_ui('swagger', cache_timeout=0),
            name='schema-swagger-ui',
        ),
        url(
            r'^redoc/$',
            schema_view.with_ui('redoc', cache_timeout=0),
            name='schema-redoc',
        ),
    ]

# API URLS
urlpatterns += [
    # API base url
    path('api/widgets/<int:company_id>/', WidgetViewSet.as_view({'get': 'get_widget'})),
    path('api/widgets/<int:company_id>/demo/', WidgetViewSet.as_view({'get': 'demo'})),
    path('api/seal/<int:company_id>/', SealViewSet.as_view({'get': 'get_seal'})),
    path("api/", include("config.api_router")),
    # JWT
    path('api/auth/token/', user_token_obtain_pair_view, name='token_obtain_pair'),
    path('api/auth/token/refresh/', TokenRefreshView.as_view(), name='token_refresh'),
    path('api/auth/logout/', TokenBlacklistView.as_view(), name='token_blacklist'),

    # shopify
    path('api/add-shopify-url/',view=shopify_url_view,name="add-shopify-url"),
    path('api/check-shopify-url/',view=check_shopify_url_view,name="check-shopify-url"),
    path('api/logout-shopify/',view=logout_shopify_url_view,name="logout-shopify"),
    path('api/purchase-plan/',view=purchase_plan_url_view,name="purchase-plan"),
    path('api/recurring-plan/',view=recurring_plan_url_view,name="recurring-plan"),
    

    path(
        'api/password_reset/',
        include('django_rest_passwordreset.urls', namespace='password_reset'),
    ),
    path('api/auth/email-verify/', view=user_verify_email, name="email-verify"),
    path(
        'api/auth/test-welcome-email/',
        view=test_welcome_email,
        name="test-welcome-email",
    ),path(
        'api/auth/send-reminder-email/',
        view=send_reminder,
        name="send-reminder-email",
    ),
    path(
        'api/contact-view/',
        view=contact_view,
        name="contact-view",
    ),
    path(
        'api/admin/update-company-subscription',
        AdminSubscriptionViewSet.as_view({'post': 'change_subscription_due_date'})
    ),
    path(
        'api/stripe-webhook-view/',
        view=stripe_webhook_view,
        name="stripe-webhook-view",
    ),
    # Sitemap
    url(
        r'^sitemap\.xml$',
        cache_page(2592000)(custom_index),
        {'sitemaps': sitemaps},
        name='django.contrib.sitemaps.views.index',
    ),
    url(
        r'^sitemap-(?P<section>.+)\.xml$',
        cache_page(2592000)(sitemap),
        {'sitemaps': sitemaps},
        name='django.contrib.sitemaps.views.sitemap',
    ),
]

if settings.DEBUG:
    # This allows the error pages to be debugged during development, just visit
    # these url in browser to see how these error pages look like.
    urlpatterns += [
        path(
            "400/",
            default_views.bad_request,
            kwargs={"exception": Exception("Bad Request!")},
        ),
        path(
            "403/",
            default_views.permission_denied,
            kwargs={"exception": Exception("Permission Denied")},
        ),
        path(
            "404/",
            default_views.page_not_found,
            kwargs={"exception": Exception("Page not Found")},
        ),
        path("500/", default_views.server_error),
    ]
    if "debug_toolbar" in settings.INSTALLED_APPS:
        import debug_toolbar

        urlpatterns = [path("__debug__/", include(debug_toolbar.urls))] + urlpatterns
