from django.db.models import Count, Q
from django_filters import rest_framework as filters, IsoDateTimeFromToRangeFilter

from verify_trusted.blogs.models import Blog


class BlogFilter(filters.FilterSet):
    title = filters.CharFilter(method='title_filter')
    category = filters.CharFilter(method='category_filter')
    status = filters.CharFilter(field_name='status')
    date = IsoDateTimeFromToRangeFilter(field_name='date_create')

    class Meta:
        model = Blog
        fields = []

    def title_filter(self, queryset, name, value):
        queryset = queryset.filter(title__icontains=value)
        return queryset

    def category_filter(self, queryset, name, value):
        queryset = queryset.filter(category__id=value)
        return queryset

    def status_filter(self, queryset, name, value):
        queryset = queryset.filter(status=value)
        return queryset


