# Generated by Django 3.1.13 on 2022-07-05 06:40

import django.contrib.postgres.indexes
import django.contrib.postgres.search
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='PostCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=250, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='PostTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=250, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='Blog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('title', models.CharField(db_index=True, max_length=200, unique=True)),
                ('first_letter', models.CharField(blank=True, db_index=True, help_text='First letter of name', max_length=1, null=True)),
                ('summary', models.TextField(blank=True, null=True)),
                ('body', models.TextField(blank=True, null=True)),
                ('status', models.IntegerField(choices=[(0, 'Draft'), (1, 'Publish')], default=0)),
                ('date_create', models.DateTimeField(auto_now=True)),
                ('date_modify', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False)),
                ('search_vector', django.contrib.postgres.search.SearchVectorField(blank=True, editable=False, null=True)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='category', to='blogs.postcategory')),
                ('tags', models.ManyToManyField(blank=True, to='blogs.PostTag')),
            ],
            options={
                'verbose_name_plural': 'Blog',
                'ordering': ['-date_create'],
            },
        ),
        migrations.AddIndex(
            model_name='blog',
            index=django.contrib.postgres.indexes.GinIndex(fields=['search_vector'], name='blogs_blog_search__6b9ce8_gin'),
        ),
    ]
