from django.template.loader import render_to_string
from rest_framework.decorators import action
from rest_framework.permissions import AllowAny
from rest_framework.renderers import StaticHTMLRenderer
from rest_framework.request import Request
from rest_framework.response import Response
from rest_framework.serializers import Serializer
from rest_framework.viewsets import GenericViewSet


class MetaViewSet(GenericViewSet):
    serializer_class = Serializer
    permission_classes = [AllowAny]
    filter_backends = None
    renderer_classes = [
        StaticHTMLRenderer,
    ]

    @action(detail=False, methods=['GET'])
    def about(self, request: Request, *args, **kwargs):  # noqa
        rendered = render_to_string('common/about.html')
        return Response(rendered)

    @action(detail=False, methods=['GET'], url_path='terms-of-service')
    def terms_of_service(self, request: Request, *args, **kwargs):  # noqa
        rendered = render_to_string('common/terms_of_service.html')
        return Response(rendered)
