from datetime import datetime

from drf_yasg import openapi

from verify_trusted.companies.models import Payment

source_ids_param = openapi.Parameter(
    'sources',
    openapi.IN_QUERY,
    description='Review Source IDs',
    type=openapi.TYPE_ARRAY,
    items=openapi.Items(type=openapi.TYPE_INTEGER),
)

platform_ids_param = openapi.Parameter(
    'platforms',
    openapi.IN_QUERY,
    description='Platform IDs',
    type=openapi.TYPE_ARRAY,
    items=openapi.Items(type=openapi.TYPE_INTEGER),
)

is_company_profile = openapi.Parameter(
    'is_company_profile',
    openapi.IN_QUERY,
    description='Is company profile',
    type=openapi.TYPE_BOOLEAN,
    required=True,
)

is_select_all = openapi.Parameter(
    'is_select_all',
    openapi.IN_QUERY,
    description='Is select all reviews',
    type=openapi.TYPE_BOOLEAN,
    required=True,
)
is_active_param= openapi.Parameter(
    'is_active_param',
    openapi.IN_QUERY,
    description='Review is active or not',
    type=openapi.TYPE_BOOLEAN,
    required=True,
)


rating_param = openapi.Parameter(
    'rating_star',
    openapi.IN_QUERY,
    description='Rating Star',
    type=openapi.TYPE_ARRAY,
    items=openapi.Items(type=openapi.TYPE_INTEGER),
)

start_date_param = openapi.Parameter(
    'start_date',
    openapi.IN_QUERY,
    description='Start Date',
    type=openapi.TYPE_STRING,
)

end_date_param = openapi.Parameter(
    'end_date',
    openapi.IN_QUERY,
    description='End Date',
    type=openapi.TYPE_STRING,
)

currency_param = openapi.Parameter(
    'currency',
    openapi.IN_QUERY,
    description='Currency',
    type=openapi.TYPE_STRING,
)

company_name_param = openapi.Parameter(
    'company_name_param',
    openapi.IN_QUERY,
    description='Company name',
    type=openapi.TYPE_STRING,
)

company_id_param = openapi.Parameter(
    'company_id_param',
    openapi.IN_QUERY,
    description='Company id',
    type=openapi.TYPE_INTEGER,
)

# (Before, After) time filter
date_before_param = openapi.Parameter(
    'date_before',
    openapi.IN_QUERY,
    description='DateTime before (using `toISOString()` method)',
    type=openapi.TYPE_STRING,
    format=openapi.FORMAT_DATETIME,
    example=datetime.now().isoformat(),
)

date_after_param = openapi.Parameter(
    'date_after',
    openapi.IN_QUERY,
    description='DateTime after (using `toISOString()` method)',
    type=openapi.TYPE_STRING,
    format=openapi.FORMAT_DATETIME,
    example=datetime.now().isoformat(),
)

status_param = openapi.Parameter(
    'status',
    openapi.IN_QUERY,
    description='Status',
    type=openapi.TYPE_STRING,
    enum=Payment.Status.values,
)
