from rest_framework.mixins import ListModelMixin
from rest_framework.permissions import AllowAny, IsAdminUser
from rest_framework.viewsets import GenericViewSet, ModelViewSet

from verify_trusted.companies.api.serializers import PlanSerializer, SubscriptionCompanySerializer
from verify_trusted.companies.models import Plan
from drf_yasg.utils import swagger_auto_schema
from rest_framework.decorators import action
from rest_framework.parsers import JSONParser
from verify_trusted.companies.models import Company, Subscription
from django.http import JsonResponse
from rest_framework import status



class AdminPlanViewSet(ModelViewSet):
    queryset = Plan.objects.all()
    serializer_class = PlanSerializer
    permission_classes = [IsAdminUser]


class PlanViewSet(ListModelMixin, GenericViewSet):
    queryset = Plan.objects.all()
    serializer_class = PlanSerializer
    permission_classes = [AllowAny]

class AdminSubscriptionViewSet(GenericViewSet):
    permission_classes = [IsAdminUser]

    @swagger_auto_schema(
        request_body=SubscriptionCompanySerializer,
    )
    def change_subscription_due_date(self, request, *args, **kwargs):
        data = JSONParser().parse(request)
        company_id = data['company_id']
        due_date = data['due_date']
        company = Company.objects.get(pk=company_id)
        if company is not None:
            subscription = Subscription.objects.filter(company=company).first()
            subscription.due_date = due_date
            subscription.save()
            return JsonResponse({"message": "Update due_date success"}, status=status.HTTP_200_OK)
        return JsonResponse({"message": "Company email not found!"}, status=status.HTTP_400_BAD_REQUEST)
        
