# Generated by Django 3.1.13 on 2022-01-14 08:06

from django.conf import settings
import django.contrib.postgres.search
from django.db import migrations, models
import django.db.models.deletion
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('companies', '0041_review_url'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalCompany',
            fields=[
                (
                    'id',
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name='ID'
                    ),
                ),
                ('name', models.CharField(max_length=500)),
                ('category', models.CharField(blank=True, max_length=550, null=True)),
                (
                    'category_main',
                    models.CharField(blank=True, max_length=250, null=True),
                ),
                ('email', models.TextField(blank=True, null=True)),
                ('phone', models.CharField(blank=True, max_length=250, null=True)),
                ('logo', models.TextField(blank=True, max_length=100, null=True)),
                (
                    'url',
                    models.CharField(
                        blank=True, db_index=True, max_length=250, null=True
                    ),
                ),
                ('url_display', models.CharField(max_length=250)),
                ('address', models.CharField(blank=True, max_length=950, null=True)),
                ('about', models.TextField(blank=True, null=True)),
                (
                    'reviews_count',
                    models.IntegerField(blank=True, default=None, null=True),
                ),
                ('average_rating', models.FloatField(blank=True, default=0, null=True)),
                ('domain', models.CharField(blank=True, max_length=500, null=True)),
                ('crawled_at', models.DateTimeField(blank=True, null=True)),
                (
                    'last_review_date',
                    models.CharField(blank=True, max_length=250, null=True),
                ),
                ('opening', models.JSONField(blank=True, null=True)),
                ('last_synced_at', models.DateTimeField(blank=True, null=True)),
                ('new_reviews', models.IntegerField(blank=True, null=True)),
                ('owner_ceo', models.CharField(blank=True, max_length=2425, null=True)),
                ('id_business', models.CharField(blank=True, max_length=33, null=True)),
                (
                    'headquarters',
                    models.CharField(blank=True, max_length=445, null=True),
                ),
                (
                    'years_onsite',
                    models.CharField(blank=True, max_length=45, null=True),
                ),
                ('years', models.CharField(blank=True, max_length=45, null=True)),
                (
                    'business_type',
                    models.CharField(blank=True, max_length=425, null=True),
                ),
                (
                    'accreditation',
                    models.CharField(blank=True, max_length=245, null=True),
                ),
                ('other', models.JSONField(blank=True, null=True)),
                ('last_http_status', models.IntegerField(blank=True, null=True)),
                ('one_year', models.BooleanField(default=True)),
                ('ssl_status', models.BooleanField(default=True)),
                ('is_verified', models.BooleanField(db_index=True, default=False)),
                ('map', models.JSONField(blank=True, null=True)),
                (
                    'search_vector',
                    django.contrib.postgres.search.SearchVectorField(
                        blank=True, editable=False, null=True
                    ),
                ),
                (
                    'history_id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                (
                    'history_type',
                    models.CharField(
                        choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')],
                        max_length=1,
                    ),
                ),
                (
                    'history_user',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                'verbose_name': 'historical company',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
