# Generated by Django 3.1.13 on 2022-02-17 07:05

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('companies', '0062_sourcesocial_display_order'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalSourceSocial',
            fields=[
                (
                    'id',
                    models.IntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name='ID'
                    ),
                ),
                ('name', models.CharField(max_length=50)),
                ('url', models.CharField(blank=True, max_length=255, null=True)),
                ('logo', models.CharField(blank=True, max_length=255, null=True)),
                ('display_order', models.IntegerField(blank=True, null=True)),
                (
                    'history_id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                (
                    'history_type',
                    models.CharField(
                        choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')],
                        max_length=1,
                    ),
                ),
                (
                    'history_user',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                'verbose_name': 'historical source social',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
