from django.db.models.signals import post_save
from django.dispatch import receiver

from verify_trusted.companies.models import Company


@receiver(post_save, sender=Company)
def update_job_search_vector(sender, instance: Company, created, **kwargs):
    """
    Automatically update `search_vector` field of Company
    """
    name = instance.name
    first_letter = name[:1]
    Company.objects.filter(id=instance.id).update(
        search_vector=Company.get_search_vector(),
        first_letter=first_letter,
    )
