from django.contrib.sitemaps import ping_google

from config import celery_app
from verify_trusted.companies.export import ExportUserIntoExcelTask


@celery_app.task()
def ping_google_task(sitemap_url=None):
    ping_google(sitemap_url)


@celery_app.task(bind=True, base=ExportUserIntoExcelTask, time_limit=10000, soft_time_limit=10000)
def export_company_task(self, query_params):
    return super(type(self), self).export(query_params)
