from datetime import datetime

from drf_yasg import openapi

from verify_trusted.companies.history_types import HistoryType
from verify_trusted.reviews.models import Platform

name_param = openapi.Parameter(
    'name',
    openapi.IN_QUERY,
    description='Platform name',
    type=openapi.TYPE_STRING,
)

access_token  = openapi.Parameter(
    'access_token',
    openapi.IN_QUERY,
    description='Access token',
    type=openapi.TYPE_STRING,
)

page_id = openapi.Parameter(
    'page_id',
    openapi.IN_QUERY,
    description='Page ID',
    type=openapi.TYPE_STRING,
)

is_add = openapi.Parameter(
    'is_add',
    openapi.IN_QUERY,
    description='Is Add',
    type=openapi.TYPE_BOOLEAN,
)


is_popular_param = openapi.Parameter(
    'is_popular',
    openapi.IN_QUERY,
    description='Is Popular',
    type=openapi.TYPE_BOOLEAN,
)

status_param = openapi.Parameter(
    'status',
    openapi.IN_QUERY,
    description='Status',
    type=openapi.TYPE_STRING,
    enum=Platform.Status.values,
)

logo_param = openapi.Parameter(
    'logo',
    openapi.IN_QUERY,
    description='Logo',
    type=openapi.TYPE_FILE,
)

company_name_param = openapi.Parameter(
    'company_name',
    openapi.IN_QUERY,
    description='Company name',
    type=openapi.TYPE_STRING,
)

history_type_param = openapi.Parameter(
    'type',
    openapi.IN_QUERY,
    description='Changelog type',
    type=openapi.TYPE_STRING,
    enum=[
        HistoryType.CREATED,
        HistoryType.CHANGED,
        HistoryType.DELETED,
    ],
)

date_before_param = openapi.Parameter(
    'date_before',
    openapi.IN_QUERY,
    description='DateTime before (using `toISOString()` method)',
    type=openapi.TYPE_STRING,
    format=openapi.FORMAT_DATETIME,
    example=datetime.now().isoformat(),
)

date_after_param = openapi.Parameter(
    'date_after',
    openapi.IN_QUERY,
    description='DateTime after (using `toISOString()` method)',
    type=openapi.TYPE_STRING,
    format=openapi.FORMAT_DATETIME,
    example=datetime.now().isoformat(),
)

company_param = openapi.Parameter(
    'company',
    openapi.IN_QUERY,
    description='Company id',
    type=openapi.TYPE_INTEGER,
)
