from django.db.models import Subquery

from config import celery_app
from verify_trusted.companies.models import Company
from verify_trusted.crawlers.angi.crawler import AngiCrawler
from verify_trusted.crawlers.bbb.crawler import BBBCrawler
from verify_trusted.crawlers.checkatrade.crawler import CheckatradeCrawler
from verify_trusted.crawlers.googlemap.crawler import GoogleMapCrawler
from verify_trusted.crawlers.facebook.crawler import FacebookCrawler
from verify_trusted.crawlers.homeadvisor.crawler import HomeAdvisorCrawler
from verify_trusted.crawlers.trustpilot.crawler import TrustpilotCrawler
from verify_trusted.crawlers.yelp.crawler import YelpCrawler
# from verify_trusted.crawlers.tasks import remove_duplicate_reviews_task
from verify_trusted.reviews.models import ReviewSource


@celery_app.task()
def sync_reviews_task(review_source_id, access_token=None, page_id=None, is_add=False):
    review_source: ReviewSource = ReviewSource.objects.get(id=review_source_id)
    platform = review_source.platform
    if platform.name.lower() == 'yelp':
        print(platform.name)
        crawler = YelpCrawler()
        crawler.sync_reviews(review_source, is_add)
    elif platform.name.lower() == 'trustpilot.com':
        print(platform.name)
        crawler = TrustpilotCrawler()
        crawler.sync_reviews(review_source, is_add)
    elif platform.name.lower() == 'checkatrade':
        print(platform.name)
        crawler = CheckatradeCrawler()
        crawler.sync_reviews(review_source, is_add)
    elif platform.name.lower() == 'homeadvisor':
        print(platform.name)
        crawler = HomeAdvisorCrawler()
        crawler.sync_reviews(review_source, is_add)
    elif platform.name.lower() == 'angi':
        print(platform.name)
        crawler = AngiCrawler()
        crawler.sync_reviews(review_source, is_add)
    elif platform.name.lower() == 'bbb':
        print(platform.name)
        crawler = BBBCrawler()
        crawler.sync_reviews(review_source, is_add)
    elif platform.name.lower() == 'facebook':
        print(platform.name)
        crawler = FacebookCrawler()
        crawler.sync_reviews(review_source, access_token, page_id, is_add)
    elif platform.name.lower() == 'google':
        print(platform.name)
        crawler = GoogleMapCrawler()
        crawler.sync_reviews(review_source)
    else:
        print(platform.name)
        review_source.sync_status = ReviewSource.SyncStatus.NOT_SYNC
        review_source.save()
    # if is_sync:
    #     review_source.average_rating = None
    #     review_source.reviews_count = None
    #     review_source.save()
    # task = remove_duplicate_reviews_task.s(review_source)
    # task.apply_async()
    company_id = review_source.company.id
    Company.objects.filter(id=company_id).update(
        average_rating=Subquery(
            Company.objects.filter(id=company_id).with_avg_rating().values('cal_average_rating')[:1]),

        reviews_count=Subquery(
            Company.objects.filter(id=company_id).with_reviews_count().values('cal_reviews_count')[:1])
    )
