from django.db.models import Sum
from rest_framework.pagination import PageNumberPagination

from verify_trusted.utils.paginations import FastPageNumberPagination


class CompanyResultsSetPagination(FastPageNumberPagination):
    page_size = 20
    page_size_query_param = 'page_size'
    max_page_size = 100
class BlogResultsSetPagination(FastPageNumberPagination):
    page_size = 20
    page_size_query_param = 'page_size'
    max_page_size = 100

class CompanyHistoryResultsSetPagination(PageNumberPagination):
    page_size = 20
    page_size_query_param = 'page_size'
    max_page_size = 100


class UserResultsSetPagination(PageNumberPagination):
    page_size = 20
    page_size_query_param = 'page_size'
    max_page_size = 100


class ReviewResultsSetPagination(FastPageNumberPagination):
    page_size = 20
    page_size_query_param = 'page_size'
    max_page_size = 100


class ReviewHistoryResultsSetPagination(PageNumberPagination):
    page_size = 20
    page_size_query_param = 'page_size'
    max_page_size = 100


class PaymentResultsSetPagination(PageNumberPagination):
    page_size = 20
    page_size_query_param = 'page_size'
    max_page_size = 100

    def paginate_queryset(self, queryset, request, view=None):
        self.total_amount = queryset.aggregate(total_amount=Sum('price_to_usd'))[
            'total_amount'
        ]
        return super(PaymentResultsSetPagination, self).paginate_queryset(
            queryset, request, view
        )

    def get_paginated_response(self, data):
        paginated_response = super(
            PaymentResultsSetPagination, self
        ).get_paginated_response(data)
        paginated_response.data['total_amount'] = self.total_amount
        return paginated_response


class AllCategoriesResultsSetPagination(FastPageNumberPagination):
    page_size = 20
    page_size_query_param = 'page_size'
    max_page_size = 100

    def get_paginated_response(self, data):
        paginated_response = super(
            AllCategoriesResultsSetPagination, self
        ).get_paginated_response(data)
        if paginated_response.data['next'] is None:
            paginated_response.data['results'].append({'category_main': 'Others'})
        return paginated_response
