from drf_yasg import openapi

name_param = openapi.Parameter(
    'name',
    openapi.IN_QUERY,
    description='Company name',
    type=openapi.TYPE_STRING,
)

first_letter_param = openapi.Parameter(
    'first_letter',
    openapi.IN_QUERY,
    description='First letter',
    type=openapi.TYPE_STRING,
    maxLength=1,
)

url_param = openapi.Parameter(
    'url',
    openapi.IN_QUERY,
    description='Company url',
    type=openapi.TYPE_STRING,
    required=True
)

username_param = openapi.Parameter(
    'name',
    openapi.IN_QUERY,
    description='Username',
    type=openapi.TYPE_STRING,
)

domain_param = openapi.Parameter(
    'domain',
    openapi.IN_QUERY,
    description='Company domain',
    type=openapi.TYPE_STRING,
)

category_param = openapi.Parameter(
    'category',
    openapi.IN_QUERY,
    description='Category',
    type=openapi.TYPE_STRING,
)

category_main_param = openapi.Parameter(
    'category_main',
    openapi.IN_QUERY,
    description='Category main',
    type=openapi.TYPE_STRING,
)

user_param = openapi.Parameter(
    'user',
    openapi.IN_QUERY,
    description='User',
    type=openapi.TYPE_STRING,
)

is_verified_param = openapi.Parameter(
    'is_verified',
    openapi.IN_QUERY,
    description='Is Verified',
    type=openapi.TYPE_BOOLEAN,
)

platform_param = openapi.Parameter(
    'platform',
    openapi.IN_QUERY,
    description='Platform',
    type=openapi.TYPE_ARRAY,
    items=openapi.Items(type=openapi.TYPE_INTEGER),
    required=False,
)

email_config_param = openapi.Parameter(
    'email',
    required=True,
    in_=openapi.IN_QUERY,
    description='Email',
    type=openapi.TYPE_STRING,
)

# ip = openapi.Parameter(
#     'ip',
#     required=True,
#     in_=openapi.IN_QUERY,
#     description='ip',
#     type=openapi.TYPE_STRING,
# )

photo_param = openapi.Parameter(
    'photo',
    required=True,
    in_=openapi.IN_QUERY,
    description='Photo',
    type=openapi.TYPE_FILE,
)

assign_param = openapi.Parameter(
    'is_assign',
    required=False,
    in_=openapi.IN_QUERY,
    description='Assign',
    type=openapi.TYPE_BOOLEAN,
)

company_param = openapi.Parameter(
    'company',
    required=False,
    in_=openapi.IN_QUERY,
    description='Company',
    type=openapi.TYPE_INTEGER,
)

company_review_param = openapi.Parameter(
    'company',
    required=True,
    in_=openapi.IN_QUERY,
    description='Company review',
    type=openapi.TYPE_INTEGER,
)

start_date_param = openapi.Parameter(
    'start_date',
    openapi.IN_QUERY,
    description='Start Date',
    type=openapi.TYPE_STRING,
    required=True,
)

end_date_param = openapi.Parameter(
    'end_date',
    openapi.IN_QUERY,
    description='End Date',
    type=openapi.TYPE_STRING,
    required=True,
)

token_param = openapi.Parameter(
    'token',
    openapi.IN_QUERY,
    description='Token',
    type=openapi.TYPE_STRING,
    required=True,
)

author_param = openapi.Parameter(
    'author',
    openapi.IN_QUERY,
    description='Author',
    type=openapi.TYPE_STRING,
)

has_reviews_param = openapi.Parameter(
    'has_reviews',
    openapi.IN_QUERY,
    description='Has reviews',
    type=openapi.TYPE_BOOLEAN,
    default=False,
)

has_email_param = openapi.Parameter(
    'has_email_company',
    openapi.IN_QUERY,
    description='Has email',
    type=openapi.TYPE_BOOLEAN,
    default=True,
)

rating_star_param = openapi.Parameter(
    'rating_star',
    openapi.IN_QUERY,
    description='Rating Star',
    type=openapi.TYPE_INTEGER,
)
