from django.contrib.auth import get_user_model
from rest_framework import serializers

from verify_trusted.utils.validators import (
    IncludeDigitValidator,
    IncludeLowercaseValidator,
    IncludeUppercaseValidator,
)

User = get_user_model()


class ChangePasswordSerializer(serializers.Serializer):
    old_password = serializers.CharField(
        required=True,
        error_messages={
            'blank': 'MSG007',
        },
    )
    new_password = serializers.CharField(
        required=True,
        write_only=True,
        min_length=6,
        validators=[
            IncludeDigitValidator(message='MSG009'),
            IncludeLowercaseValidator(message='MSG010'),
            IncludeUppercaseValidator(message='MSG011'),
        ],
        error_messages={
            'blank': 'MSG007',
            'min_length': 'MSG008',
        },
    )

    class Meta:
        model = User
        fields = ('old_password', 'new_password')
