from django.contrib.auth import get_user_model
from django.db.models.signals import post_save
from django.dispatch import receiver

from verify_trusted.users.models import Profile

User = get_user_model()


@receiver(post_save, sender=User)
def handle_user_post_save(sender, instance: User, created, **kwargs):
    if created:
        # Create default user profile
        Profile.objects.create(user=instance)
