from functools import cached_property

from django.core.paginator import Paginator
from rest_framework.pagination import PageNumberPagination


class FastPaginator(Paginator):  # https://stackoverflow.com/a/47357445
    @cached_property
    def count(self):
        # only select 'id' for counting, much cheaper
        return self.object_list.values('id').count()


class FastPageNumberPagination(PageNumberPagination):
    django_paginator_class = FastPaginator
