import uuid

from django.db import models

from verify_trusted.companies.models import Company, Review


# Create your models here.
class Widget(models.Model):
    class OrderBy(models.TextChoices):
        NEWER = 'NEWER'
        RANDOM = 'RANDOM'
        TOP_RATING = 'TOP_RATING'

    id = models.UUIDField(
        primary_key=True, unique=True, default=uuid.uuid4, editable=False
    )
    layout_id = models.IntegerField(blank=True, null=True)
    set_id = models.CharField(blank=True, null=True, max_length=45)
    more_style = models.JSONField(blank=True, null=True)
    company = models.ForeignKey(
        Company, on_delete=models.CASCADE, blank=True, null=True
    )
    reviews = models.ManyToManyField(Review, through='WidgetReivews', blank=True)
    domains = models.JSONField(blank=True, null=True)
    analytics = models.JSONField(blank=True, null=True)
    layout_type = models.CharField(blank=True, null=True, max_length=50)
    number_of_review = models.IntegerField(blank=True, null=True)
    order_by = models.CharField(
        max_length=50,
        choices=OrderBy.choices,
        default=OrderBy.TOP_RATING,
    )

    class Meta:
        verbose_name_plural = 'Widgets'


class WidgetReivews(models.Model):
    widget = models.ForeignKey(Widget, on_delete=models.CASCADE)
    review = models.ForeignKey(Review, on_delete=models.CASCADE)


class Seal(models.Model):
    class TypeSeal(models.TextChoices):
        TYPE_1 = 'TYPE_1'
        TYPE_2 = 'TYPE_2'
        TYPE_3 = 'TYPE_3'
        TYPE_4 = 'TYPE_4'
        TYPE_5 = 'TYPE_5'
        TYPE_6 = 'TYPE_6'
        TYPE_7 = 'TYPE_7'
        TYPE_8 = 'TYPE_8'
        TYPE_9 = 'TYPE_9'
        TYPE_10 = 'TYPE_10'
        TYPE_11 = 'TYPE_11'

    id = models.UUIDField(
        primary_key=True, unique=True, default=uuid.uuid4, editable=False
    )
    seal_type = models.CharField(
        max_length=50,
        choices=TypeSeal.choices,
        default=TypeSeal.TYPE_1,
    )
    company = models.ForeignKey(
        Company, on_delete=models.CASCADE, blank=True, null=True
    )

    class Meta:
        verbose_name_plural = 'Seal'
