import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import * as React from 'react';
import useEventCallback from '@mui/utils/useEventCallback';
import { unstable_useControlled as useControlled } from '@mui/utils';
var warnedOnceNotValidView = false;
export function useViews(_ref) {
  var _views, _views2;
  var onChange = _ref.onChange,
    onViewChange = _ref.onViewChange,
    openTo = _ref.openTo,
    inView = _ref.view,
    views = _ref.views,
    autoFocus = _ref.autoFocus,
    inFocusedView = _ref.focusedView,
    onFocusedViewChange = _ref.onFocusedViewChange;
  if (process.env.NODE_ENV !== 'production') {
    if (!warnedOnceNotValidView) {
      if (inView != null && !views.includes(inView)) {
        console.warn("MUI: `view=\"".concat(inView, "\"` is not a valid prop."), "It must be an element of `views=[\"".concat(views.join('", "'), "\"]`."));
        warnedOnceNotValidView = true;
      }
      if (inView == null && openTo != null && !views.includes(openTo)) {
        console.warn("MUI: `openTo=\"".concat(openTo, "\"` is not a valid prop."), "It must be an element of `views=[\"".concat(views.join('", "'), "\"]`."));
        warnedOnceNotValidView = true;
      }
    }
  }
  var previousOpenTo = React.useRef(openTo);
  var previousViews = React.useRef(views);
  var defaultView = React.useRef(views.includes(openTo) ? openTo : views[0]);
  var _useControlled = useControlled({
      name: 'useViews',
      state: 'view',
      controlled: inView,
      default: defaultView.current
    }),
    _useControlled2 = _slicedToArray(_useControlled, 2),
    view = _useControlled2[0],
    setView = _useControlled2[1];
  var defaultFocusedView = React.useRef(autoFocus ? view : null);
  var _useControlled3 = useControlled({
      name: 'useViews',
      state: 'focusedView',
      controlled: inFocusedView,
      default: defaultFocusedView.current
    }),
    _useControlled4 = _slicedToArray(_useControlled3, 2),
    focusedView = _useControlled4[0],
    setFocusedView = _useControlled4[1];
  React.useEffect(function () {
    // Update the current view when `openTo` or `views` props change
    if (previousOpenTo.current && previousOpenTo.current !== openTo || previousViews.current && previousViews.current.some(function (previousView) {
      return !views.includes(previousView);
    })) {
      setView(views.includes(openTo) ? openTo : views[0]);
      previousViews.current = views;
      previousOpenTo.current = openTo;
    }
  }, [openTo, setView, view, views]);
  var viewIndex = views.indexOf(view);
  var previousView = (_views = views[viewIndex - 1]) != null ? _views : null;
  var nextView = (_views2 = views[viewIndex + 1]) != null ? _views2 : null;
  var handleFocusedViewChange = useEventCallback(function (viewToFocus, hasFocus) {
    if (hasFocus) {
      // Focus event
      setFocusedView(viewToFocus);
    } else {
      // Blur event
      setFocusedView(function (prevFocusedView) {
        return viewToFocus === prevFocusedView ? null : prevFocusedView;
      } // If false the blur is due to view switching
      );
    }

    onFocusedViewChange == null ? void 0 : onFocusedViewChange(viewToFocus, hasFocus);
  });
  var handleChangeView = useEventCallback(function (newView) {
    if (newView === view) {
      return;
    }
    setView(newView);
    handleFocusedViewChange(newView, true);
    if (onViewChange) {
      onViewChange(newView);
    }
  });
  var goToNextView = useEventCallback(function () {
    if (nextView) {
      handleChangeView(nextView);
    }
    handleFocusedViewChange(nextView, true);
  });
  var setValueAndGoToNextView = useEventCallback(function (value, currentViewSelectionState, selectedView) {
    var isSelectionFinishedOnCurrentView = currentViewSelectionState === 'finish';
    var hasMoreViews = selectedView ?
    // handles case like `DateTimePicker`, where a view might return a `finish` selection state
    // but we it's not the final view given all `views` -> overall selection state should be `partial`.
    views.indexOf(selectedView) < views.length - 1 : Boolean(nextView);
    var globalSelectionState = isSelectionFinishedOnCurrentView && hasMoreViews ? 'partial' : currentViewSelectionState;
    onChange(value, globalSelectionState);
    if (isSelectionFinishedOnCurrentView) {
      goToNextView();
    }
  });
  var setValueAndGoToView = useEventCallback(function (value, newView, selectedView) {
    onChange(value, newView ? 'partial' : 'finish', selectedView);
    if (newView) {
      handleChangeView(newView);
      handleFocusedViewChange(newView, true);
    }
  });
  return {
    view: view,
    setView: handleChangeView,
    focusedView: focusedView,
    setFocusedView: handleFocusedViewChange,
    nextView: nextView,
    previousView: previousView,
    defaultView: defaultView.current,
    goToNextView: goToNextView,
    setValueAndGoToNextView: setValueAndGoToNextView,
    setValueAndGoToView: setValueAndGoToView
  };
}