import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
var _excluded = ["views", "format"];
import { resolveTimeFormat, isTimeView } from './time-utils';
import { resolveDateFormat } from './date-utils';
export var resolveDateTimeFormat = function resolveDateTimeFormat(utils, _ref) {
  var views = _ref.views,
    format = _ref.format,
    other = _objectWithoutProperties(_ref, _excluded);
  if (format) {
    return format;
  }
  var dateViews = [];
  var timeViews = [];
  views.forEach(function (view) {
    if (isTimeView(view)) {
      timeViews.push(view);
    } else {
      dateViews.push(view);
    }
  });
  if (timeViews.length === 0) {
    return resolveDateFormat(utils, _extends({
      views: dateViews
    }, other), false);
  }
  if (dateViews.length === 0) {
    return resolveTimeFormat(utils, _extends({
      views: timeViews
    }, other));
  }
  var timeFormat = resolveTimeFormat(utils, _extends({
    views: timeViews
  }, other));
  var dateFormat = resolveDateFormat(utils, _extends({
    views: dateViews
  }, other), false);
  return "".concat(dateFormat, " ").concat(timeFormat);
};