import { getPickersLocalization } from './utils/getPickersLocalization';
var views = {
  hours: 'les hores',
  minutes: 'els minuts',
  seconds: 'els segons',
  meridiem: 'meridiem'
};
var caESPickers = {
  // Calendar navigation
  previousMonth: 'Últim mes',
  nextMonth: 'Pròxim mes',
  // View navigation
  openPreviousView: "obrir l'última vista",
  openNextView: 'obrir la següent vista',
  calendarViewSwitchingButtonAriaLabel: function calendarViewSwitchingButtonAriaLabel(view) {
    return view === 'year' ? "la vista de l'any està oberta, canvie a la vista de calendari" : "la vista de calendari està oberta, canvie a la vista de l'any";
  },
  // DateRange placeholders
  start: 'Començar',
  end: 'Terminar',
  // Action bar
  cancelButtonLabel: 'Cancel·lar',
  clearButtonLabel: 'Netejar',
  okButtonLabel: 'OK',
  todayButtonLabel: 'Hui',
  // Toolbar titles
  datePickerToolbarTitle: 'Seleccionar data',
  dateTimePickerToolbarTitle: 'Seleccionar data i hora',
  timePickerToolbarTitle: 'Seleccionar hora',
  dateRangePickerToolbarTitle: 'Seleccionar rang de dates',
  // Clock labels
  clockLabelText: function clockLabelText(view, time, adapter) {
    return "Seleccione ".concat(views[view], ". ").concat(time === null ? 'Sense temps seleccionat' : "El temps seleccionat \xE9s ".concat(adapter.format(time, 'fullTime')));
  },
  hoursClockNumberText: function hoursClockNumberText(hours) {
    return "".concat(hours, " hores");
  },
  minutesClockNumberText: function minutesClockNumberText(minutes) {
    return "".concat(minutes, " minuts");
  },
  secondsClockNumberText: function secondsClockNumberText(seconds) {
    return "".concat(seconds, " segons");
  },
  // Digital clock labels
  selectViewText: function selectViewText(view) {
    return "Seleccionar ".concat(views[view]);
  },
  // Calendar labels
  calendarWeekNumberHeaderLabel: 'Número de setmana',
  calendarWeekNumberHeaderText: '#',
  calendarWeekNumberAriaLabelText: function calendarWeekNumberAriaLabelText(weekNumber) {
    return "Setmana ".concat(weekNumber);
  },
  calendarWeekNumberText: function calendarWeekNumberText(weekNumber) {
    return "".concat(weekNumber);
  },
  // Open picker labels
  openDatePickerDialogue: function openDatePickerDialogue(value, utils) {
    return value !== null && utils.isValid(value) ? "Tria la data, la data triada \xE9s ".concat(utils.format(value, 'fullDate')) : 'Tria la data';
  },
  openTimePickerDialogue: function openTimePickerDialogue(value, utils) {
    return value !== null && utils.isValid(value) ? "Tria l'hora, l'hora triada \xE9s ".concat(utils.format(value, 'fullTime')) : "Tria l'hora";
  },
  // Table labels
  timeTableLabel: 'tria la data',
  dateTableLabel: "tria l'hora",
  // Field section placeholders
  fieldYearPlaceholder: function fieldYearPlaceholder(params) {
    return 'Y'.repeat(params.digitAmount);
  },
  fieldMonthPlaceholder: function fieldMonthPlaceholder(params) {
    return params.contentType === 'letter' ? 'MMMM' : 'MM';
  },
  fieldDayPlaceholder: function fieldDayPlaceholder() {
    return 'DD';
  },
  fieldWeekDayPlaceholder: function fieldWeekDayPlaceholder(params) {
    return params.contentType === 'letter' ? 'EEEE' : 'EE';
  },
  fieldHoursPlaceholder: function fieldHoursPlaceholder() {
    return 'hh';
  },
  fieldMinutesPlaceholder: function fieldMinutesPlaceholder() {
    return 'mm';
  },
  fieldSecondsPlaceholder: function fieldSecondsPlaceholder() {
    return 'ss';
  },
  fieldMeridiemPlaceholder: function fieldMeridiemPlaceholder() {
    return 'aa';
  }
};
export var caES = getPickersLocalization(caESPickers);