import _extends from "@babel/runtime/helpers/esm/extends";
import createDescribe from '@mui/monorepo/test/utils/createDescribe';
import { testCalculations } from './testCalculations';
import { testLocalization } from './testLocalization';
import { testFormat } from './testFormat';
function innerGregorianDescribeAdapter(Adapter, params) {
  var _params$prepareAdapte;
  var prepareAdapter = (_params$prepareAdapte = params.prepareAdapter) != null ? _params$prepareAdapte : function (e) {
    return e;
  };
  var adapter = new Adapter();
  var adapterTZ = params.dateLibInstanceWithTimezoneSupport ? new Adapter({
    dateLibInstance: params.dateLibInstanceWithTimezoneSupport
  }) : new Adapter();
  var adapterFr = new Adapter({
    locale: params.frenchLocale,
    dateLibInstance: params.dateLibInstanceWithTimezoneSupport
  });
  prepareAdapter(adapter);
  prepareAdapter(adapterTZ);
  describe(adapter.lib, function () {
    var testSuitParams = _extends({}, params, {
      adapter: adapter,
      adapterTZ: adapterTZ,
      adapterFr: adapterFr
    });
    testCalculations(testSuitParams);
    testLocalization(testSuitParams);
    testFormat(testSuitParams);
  });
}
export var describeGregorianAdapter = createDescribe('Adapter methods', innerGregorianDescribeAdapter);