import { expect } from 'chai';
export var testFormat = function testFormat(_ref) {
  var adapter = _ref.adapter;
  var expectDate = function expectDate(format, expected) {
    var date = adapter.date('2020-01-01T23:44:00.000Z');
    var result = adapter.format(date, format);
    expect(result).to.equal(expected);
  };
  it('should correctly format standalone hardcoded formats', function () {
    expectDate('normalDate', '1 January');
    expectDate('normalDateWithWeekday', 'Wed, Jan 1');
    expectDate('shortDate', 'Jan 1');
    expectDate('year', '2020');
    expectDate('month', 'January');
    expectDate('monthAndDate', 'January 1');
    expectDate('weekday', 'Wednesday');
    expectDate('weekdayShort', 'Wed');
    expectDate('dayOfMonth', '1');
    expectDate('fullTime12h', '11:44 PM');
    expectDate('fullTime24h', '23:44');
    expectDate('hours12h', '11');
    expectDate('hours24h', '23');
    expectDate('minutes', '44');
    expectDate('seconds', '00');
  });
};