import { expect } from 'chai';
export var testLocalization = function testLocalization(_ref) {
  var adapter = _ref.adapter;
  it('Method: formatNumber', function () {
    expect(adapter.formatNumber('1')).to.equal('١');
    expect(adapter.formatNumber('2')).to.equal('٢');
  });
  it('Method: getMeridiemText', function () {
    expect(adapter.getMeridiemText('am')).to.equal('ص');
    expect(adapter.getMeridiemText('pm')).to.equal('م');
  });
  it('Method: getFormatHelperText', function () {
    expect(adapter.getFormatHelperText(adapter.formats.keyboardDate)).to.equal('yyyy/mm/dd');
    expect(adapter.getFormatHelperText(adapter.formats.keyboardDateTime12h)).to.equal('yyyy/mm/dd hh:mm (a|p)m');
  });
  it('Method: getCurrentLocaleCode', function () {
    // Returns the default locale
    expect(adapter.getCurrentLocaleCode()).to.match(/ar/);
  });
};