import _extends from "@babel/runtime/helpers/esm/extends";
import { expect } from 'chai';
import * as React from 'react';
import { screen } from '@mui/monorepo/test/utils';
import { adapterToUse } from 'test/utils/pickers-utils';
import { jsx as _jsx } from "react/jsx-runtime";
export var testMonthViewValidation = function testMonthViewValidation(ElementToTest, getOptions) {
  var _getOptions = getOptions(),
    views = _getOptions.views,
    componentFamily = _getOptions.componentFamily,
    render = _getOptions.render,
    clock = _getOptions.clock;
  if (componentFamily === 'field' || !views.includes('month')) {
    return;
  }
  describe('month view:', function () {
    var defaultProps = _extends({
      onChange: function onChange() {}
    }, views.length > 1 && {
      views: ['month'],
      view: 'month',
      openTo: 'month'
    }, componentFamily !== 'calendar' && {
      open: true,
      reduceAnimations: true,
      slotProps: {
        toolbar: {
          hidden: true
        }
      }
    });
    it('should apply shouldDisableMonth', function test() {
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: null,
        shouldDisableMonth: function shouldDisableMonth(date) {
          return adapterToUse.getMonth(date) === 3;
        }
      })));
      expect(screen.getByText('Apr')).to.have.attribute('disabled');
      expect(screen.getByText('Jan')).not.to.have.attribute('disabled');
      expect(screen.getByText('May')).not.to.have.attribute('disabled');
    });
    it('should apply disablePast', function test() {
      var now;
      function WithFakeTimer(props) {
        now = adapterToUse.date(new Date());
        return /*#__PURE__*/_jsx(ElementToTest, _extends({
          value: now
        }, props));
      }
      var _render = render( /*#__PURE__*/_jsx(WithFakeTimer, _extends({}, defaultProps, {
          disablePast: true
        }))),
        setProps = _render.setProps;
      var nextMonth = adapterToUse.addMonths(now, 1);
      var prevMonth = adapterToUse.addMonths(now, -1);
      expect(screen.getByText(adapterToUse.format(now, 'monthShort'))).not.to.have.attribute('disabled');
      if (!adapterToUse.isSameYear(now, nextMonth)) {
        setProps({
          value: nextMonth
        });
        clock.runToLast();
      }
      expect(screen.getByText(adapterToUse.format(nextMonth, 'monthShort'))).not.to.have.attribute('disabled');
      if (!adapterToUse.isSameYear(prevMonth, nextMonth)) {
        setProps({
          value: prevMonth
        });
        clock.runToLast();
      }
      expect(screen.getByText(adapterToUse.format(prevMonth, 'monthShort'))).to.have.attribute('disabled');

      // TODO: define what appends when value is `null`
    });

    it('should apply disableFuture', function test() {
      var now;
      function WithFakeTimer(props) {
        now = adapterToUse.date(new Date());
        return /*#__PURE__*/_jsx(ElementToTest, _extends({
          value: now
        }, props));
      }
      var _render2 = render( /*#__PURE__*/_jsx(WithFakeTimer, _extends({}, defaultProps, {
          disableFuture: true
        }))),
        setProps = _render2.setProps;
      var nextMonth = adapterToUse.addMonths(now, 1);
      var prevMonth = adapterToUse.addMonths(now, -1);
      expect(screen.getByText(adapterToUse.format(now, 'monthShort'))).not.to.have.attribute('disabled');
      if (!adapterToUse.isSameYear(now, nextMonth)) {
        setProps({
          value: nextMonth
        });
        clock.runToLast();
      }
      expect(screen.getByText(adapterToUse.format(nextMonth, 'monthShort'))).to.have.attribute('disabled');
      if (!adapterToUse.isSameYear(prevMonth, nextMonth)) {
        setProps({
          value: prevMonth
        });
        clock.runToLast();
      }
      expect(screen.getByText(adapterToUse.format(prevMonth, 'monthShort'))).not.to.have.attribute('disabled');

      // TODO: define what appends when value is `null`
    });

    it('should apply minDate', function test() {
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: adapterToUse.date(new Date(2019, 5, 15)),
        minDate: adapterToUse.date(new Date(2019, 5, 4))
      })));
      expect(screen.getByText('Jan')).to.have.attribute('disabled');
      expect(screen.getByText('May')).to.have.attribute('disabled');
      expect(screen.getByText('Jun')).not.to.have.attribute('disabled');
      expect(screen.getByText('Jul')).not.to.have.attribute('disabled');
      expect(screen.getByText('Dec')).not.to.have.attribute('disabled');

      // TODO: define what appends when value is `null`
    });

    it('should apply maxDate', function test() {
      render( /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, {
        value: adapterToUse.date(new Date(2019, 5, 15)),
        maxDate: adapterToUse.date(new Date(2019, 5, 4))
      })));
      expect(screen.getByText('Jan')).not.to.have.attribute('disabled');
      expect(screen.getByText('Jun')).not.to.have.attribute('disabled');
      expect(screen.getByText('Jul')).to.have.attribute('disabled');
      expect(screen.getByText('Dec')).to.have.attribute('disabled');

      // TODO: define what appends when value is `null`
    });
  });
};