import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
var _excluded = ["hook"];
import * as React from 'react';
import createDescribe from '@mui/monorepo/test/utils/createDescribe';
import { buildFieldInteractions } from 'test/utils/pickers-utils';
import { testControlledUnControlled } from './testControlledUnControlled';
import { testPickerOpenCloseLifeCycle } from './testPickerOpenCloseLifeCycle';
import { testPickerActionBar } from './testPickerActionBar';
import { jsx as _jsx } from "react/jsx-runtime";
var TEST_SUITES = [testControlledUnControlled, testPickerOpenCloseLifeCycle, testPickerActionBar];
function innerDescribeValue(ElementToTest, getOptions) {
  var options = getOptions();
  var defaultProps = options.defaultProps,
    render = options.render,
    clock = options.clock,
    componentFamily = options.componentFamily;
  function WrappedElementToTest(props) {
    var hook = props.hook,
      other = _objectWithoutProperties(props, _excluded);
    var hookResult = hook == null ? void 0 : hook(props);
    return /*#__PURE__*/_jsx(ElementToTest, _extends({}, defaultProps, other, hookResult));
  }
  var renderWithProps;
  if (componentFamily === 'field' || componentFamily === 'picker') {
    var interactions = buildFieldInteractions({
      clock: clock,
      render: render,
      Component: ElementToTest
    });
    renderWithProps = function renderWithProps(props, hook) {
      return interactions.renderWithProps(_extends({}, defaultProps, props), hook, componentFamily);
    };
  } else {
    renderWithProps = function renderWithProps(props, hook) {
      var response = render( /*#__PURE__*/_jsx(WrappedElementToTest, _extends({}, props, {
        hook: hook
      })));
      return _extends({}, response, {
        input: null,
        selectSection: function selectSection() {
          throw new Error('You can only select a section on components that render a field');
        }
      });
    };
  }
  TEST_SUITES.forEach(function (testSuite) {
    testSuite(WrappedElementToTest, _extends({}, options, {
      renderWithProps: renderWithProps
    }));
  });
}
/**
 * Tests various aspects of component value.
 */
export var describeValue = createDescribe('Value API', innerDescribeValue);