import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
var _excluded = ["componentFamily", "render", "renderWithProps", "values", "emptyValue", "setNewValue"];
import * as React from 'react';
import { expect } from 'chai';
import { spy } from 'sinon';
import { screen, userEvent } from '@mui/monorepo/test/utils';
import { adapterToUse, getExpectedOnChangeCount } from 'test/utils/pickers-utils';
import { jsx as _jsx } from "react/jsx-runtime";
export var testPickerActionBar = function testPickerActionBar(ElementToTest, options) {
  var componentFamily = options.componentFamily,
    render = options.render,
    renderWithProps = options.renderWithProps,
    values = options.values,
    emptyValue = options.emptyValue,
    setNewValue = options.setNewValue,
    pickerParams = _objectWithoutProperties(options, _excluded);
  if (componentFamily !== 'picker') {
    return;
  }
  describe('Picker action bar', function () {
    describe('clear action', function () {
      it('should call onClose, onChange with empty value and onAccept with empty value', function () {
        var onChange = spy();
        var onAccept = spy();
        var onClose = spy();
        render( /*#__PURE__*/_jsx(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          defaultValue: values[0],
          open: true,
          slotProps: {
            actionBar: {
              actions: ['clear']
            }
          }
        }));

        // Clear the date
        userEvent.mousePress(screen.getByText(/clear/i));
        expect(onChange.callCount).to.equal(1);
        if (pickerParams.type === 'date-range') {
          onChange.lastCall.args[0].forEach(function (value, index) {
            expect(value).to.deep.equal(emptyValue[index]);
          });
        } else {
          expect(onChange.lastCall.args[0]).to.deep.equal(emptyValue);
        }
        expect(onAccept.callCount).to.equal(1);
        if (pickerParams.type === 'date-range') {
          onAccept.lastCall.args[0].forEach(function (value, index) {
            expect(value).to.deep.equal(emptyValue[index]);
          });
        } else {
          expect(onAccept.lastCall.args[0]).to.deep.equal(emptyValue);
        }
        expect(onClose.callCount).to.equal(1);
      });
      it('should not call onChange or onAccept if the value is already empty value', function () {
        var onChange = spy();
        var onAccept = spy();
        var onClose = spy();
        render( /*#__PURE__*/_jsx(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          open: true,
          slotProps: {
            actionBar: {
              actions: ['clear']
            }
          },
          value: emptyValue
        }));

        // Clear the date
        userEvent.mousePress(screen.getByText(/clear/i));
        expect(onChange.callCount).to.equal(0);
        expect(onAccept.callCount).to.equal(0);
        expect(onClose.callCount).to.equal(1);
      });
    });
    describe('cancel action', function () {
      it('should call onClose and onChange with the initial value', function () {
        var onChange = spy();
        var onAccept = spy();
        var onClose = spy();
        var _renderWithProps = renderWithProps({
            onChange: onChange,
            onAccept: onAccept,
            onClose: onClose,
            open: true,
            value: values[0],
            slotProps: {
              actionBar: {
                actions: ['cancel']
              }
            },
            closeOnSelect: false
          }),
          selectSection = _renderWithProps.selectSection;

        // Change the value (already tested)
        setNewValue(values[0], {
          isOpened: true,
          selectSection: selectSection
        });

        // Cancel the modifications
        userEvent.mousePress(screen.getByText(/cancel/i));
        expect(onChange.callCount).to.equal(getExpectedOnChangeCount(componentFamily, pickerParams) + 1);
        if (pickerParams.type === 'date-range') {
          values[0].forEach(function (value, index) {
            expect(onChange.lastCall.args[0][index]).toEqualDateTime(value);
          });
        } else {
          expect(onChange.lastCall.args[0]).toEqualDateTime(values[0]);
        }
        expect(onAccept.callCount).to.equal(0);
        expect(onClose.callCount).to.equal(1);
      });
      it('should not call onChange if no prior value modification', function () {
        var onChange = spy();
        var onAccept = spy();
        var onClose = spy();
        render( /*#__PURE__*/_jsx(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          open: true,
          value: values[0],
          slotProps: {
            actionBar: {
              actions: ['cancel']
            }
          },
          closeOnSelect: false
        }));

        // Cancel the modifications
        userEvent.mousePress(screen.getByText(/cancel/i));
        expect(onChange.callCount).to.equal(0);
        expect(onAccept.callCount).to.equal(0);
        expect(onClose.callCount).to.equal(1);
      });
    });
    describe('confirm action', function () {
      it('should call onClose and onAccept with the live value', function () {
        var onChange = spy();
        var onAccept = spy();
        var onClose = spy();
        var _renderWithProps2 = renderWithProps({
            onChange: onChange,
            onAccept: onAccept,
            onClose: onClose,
            open: true,
            defaultValue: values[0],
            slotProps: {
              actionBar: {
                actions: ['accept']
              }
            },
            closeOnSelect: false
          }),
          selectSection = _renderWithProps2.selectSection;

        // Change the value (already tested)
        setNewValue(values[0], {
          isOpened: true,
          selectSection: selectSection
        });

        // Accept the modifications
        userEvent.mousePress(screen.getByText(/ok/i));
        expect(onChange.callCount).to.equal(getExpectedOnChangeCount(componentFamily, pickerParams)); // The accepted value as already been committed, don't call onChange again
        expect(onAccept.callCount).to.equal(1);
        expect(onClose.callCount).to.equal(1);
      });
      it('should call onChange, onClose and onAccept when validating the default value', function () {
        var onChange = spy();
        var onAccept = spy();
        var onClose = spy();
        render( /*#__PURE__*/_jsx(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          open: true,
          defaultValue: values[0],
          slotProps: {
            actionBar: {
              actions: ['accept']
            }
          },
          closeOnSelect: false
        }));

        // Accept the modifications
        userEvent.mousePress(screen.getByText(/ok/i));
        expect(onChange.callCount).to.equal(1);
        expect(onAccept.callCount).to.equal(1);
        expect(onClose.callCount).to.equal(1);
      });
      it('should call onClose but not onAccept when validating an already validated value', function () {
        var onChange = spy();
        var onAccept = spy();
        var onClose = spy();
        render( /*#__PURE__*/_jsx(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          open: true,
          value: values[0],
          slotProps: {
            actionBar: {
              actions: ['accept']
            }
          },
          closeOnSelect: false
        }));

        // Accept the modifications
        userEvent.mousePress(screen.getByText(/ok/i));
        expect(onChange.callCount).to.equal(0);
        expect(onAccept.callCount).to.equal(0);
        expect(onClose.callCount).to.equal(1);
      });
    });
    describe('today action', function () {
      it("should call onClose, onChange with today's value and onAccept with today's value", function () {
        var onChange = spy();
        var onAccept = spy();
        var onClose = spy();
        render( /*#__PURE__*/_jsx(ElementToTest, {
          onChange: onChange,
          onAccept: onAccept,
          onClose: onClose,
          defaultValue: values[0],
          open: true,
          slotProps: {
            actionBar: {
              actions: ['today']
            }
          }
        }));
        userEvent.mousePress(screen.getByText(/today/i));
        var startOfToday = pickerParams.type === 'date' ? adapterToUse.startOfDay(adapterToUse.date()) : adapterToUse.date();
        expect(onChange.callCount).to.equal(1);
        if (pickerParams.type === 'date-range') {
          onChange.lastCall.args[0].forEach(function (value) {
            expect(value).toEqualDateTime(startOfToday);
          });
        } else {
          expect(onChange.lastCall.args[0]).toEqualDateTime(startOfToday);
        }
        expect(onAccept.callCount).to.equal(1);
        if (pickerParams.type === 'date-range') {
          onAccept.lastCall.args[0].forEach(function (value) {
            expect(value).toEqualDateTime(startOfToday);
          });
        } else {
          expect(onAccept.lastCall.args[0]).toEqualDateTime(startOfToday);
        }
        expect(onClose.callCount).to.equal(1);
      });
    });
  });
};