"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderDesktopDateTimeView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var _Divider = _interopRequireDefault(require("@mui/material/Divider"));
var _utils = require("@mui/base/utils");
var _DateCalendar = require("../DateCalendar");
var _MultiSectionDigitalClock = require("../MultiSectionDigitalClock");
var _DateTimeViewWrapper = require("../internals/components/DateTimeViewWrapper");
var _timeUtils = require("../internals/utils/time-utils");
var _dateUtils = require("../internals/utils/date-utils");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const renderDesktopDateTimeView = ({
  view,
  onViewChange,
  views,
  focusedView,
  onFocusedViewChange,
  value,
  defaultValue,
  onChange,
  className,
  classes,
  disableFuture,
  disablePast,
  minDate,
  minTime,
  maxDate,
  maxTime,
  shouldDisableDate,
  shouldDisableMonth,
  shouldDisableYear,
  shouldDisableTime,
  shouldDisableClock,
  reduceAnimations,
  minutesStep,
  ampm,
  onMonthChange,
  monthsPerRow,
  onYearChange,
  yearsPerRow,
  defaultCalendarMonth,
  components,
  componentsProps,
  slots,
  slotProps,
  loading,
  renderLoading,
  disableHighlightToday,
  readOnly,
  disabled,
  showDaysOutsideCurrentMonth,
  dayOfWeekFormatter,
  sx,
  autoFocus,
  fixedWeekNumber,
  displayWeekNumber,
  timezone,
  disableIgnoringDatePartForTimeValidation,
  timeSteps,
  skipDisabled,
  timeViewsCount
}) => {
  const isActionBarVisible = !!(0, _utils.resolveComponentProps)(slotProps?.actionBar ?? componentsProps?.actionBar, {})?.actions?.length;
  return /*#__PURE__*/(0, _jsxRuntime.jsxs)(React.Fragment, {
    children: [/*#__PURE__*/(0, _jsxRuntime.jsxs)(_DateTimeViewWrapper.DateTimeViewWrapper, {
      children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_DateCalendar.DateCalendar, {
        view: (0, _dateUtils.isDatePickerView)(view) ? view : 'day',
        onViewChange: onViewChange,
        views: views.filter(_dateUtils.isDatePickerView),
        focusedView: focusedView && (0, _dateUtils.isDatePickerView)(focusedView) ? focusedView : null,
        onFocusedViewChange: onFocusedViewChange,
        value: value,
        defaultValue: defaultValue,
        onChange: onChange,
        className: className,
        classes: classes,
        disableFuture: disableFuture,
        disablePast: disablePast,
        minDate: minDate,
        maxDate: maxDate,
        shouldDisableDate: shouldDisableDate,
        shouldDisableMonth: shouldDisableMonth,
        shouldDisableYear: shouldDisableYear,
        reduceAnimations: reduceAnimations,
        onMonthChange: onMonthChange,
        monthsPerRow: monthsPerRow,
        onYearChange: onYearChange,
        yearsPerRow: yearsPerRow,
        defaultCalendarMonth: defaultCalendarMonth,
        components: components,
        componentsProps: componentsProps,
        slots: slots,
        slotProps: slotProps,
        loading: loading,
        renderLoading: renderLoading,
        disableHighlightToday: disableHighlightToday,
        readOnly: readOnly,
        disabled: disabled,
        showDaysOutsideCurrentMonth: showDaysOutsideCurrentMonth,
        dayOfWeekFormatter: dayOfWeekFormatter,
        sx: sx,
        autoFocus: autoFocus,
        fixedWeekNumber: fixedWeekNumber,
        displayWeekNumber: displayWeekNumber,
        timezone: timezone
      }), timeViewsCount > 0 && /*#__PURE__*/(0, _jsxRuntime.jsxs)(React.Fragment, {
        children: [/*#__PURE__*/(0, _jsxRuntime.jsx)(_Divider.default, {
          orientation: "vertical"
        }), /*#__PURE__*/(0, _jsxRuntime.jsx)(_MultiSectionDigitalClock.MultiSectionDigitalClock, {
          view: (0, _timeUtils.isInternalTimeView)(view) ? view : 'hours',
          onViewChange: onViewChange,
          focusedView: focusedView && (0, _timeUtils.isInternalTimeView)(focusedView) ? focusedView : null,
          onFocusedViewChange: onFocusedViewChange,
          views: views.filter(_timeUtils.isInternalTimeView),
          value: value,
          defaultValue: defaultValue,
          onChange: onChange,
          className: className,
          classes: classes,
          disableFuture: disableFuture,
          disablePast: disablePast,
          minTime: minTime,
          maxTime: maxTime,
          shouldDisableTime: shouldDisableTime,
          shouldDisableClock: shouldDisableClock,
          minutesStep: minutesStep,
          ampm: ampm,
          components: components,
          componentsProps: componentsProps,
          slots: slots,
          slotProps: slotProps,
          readOnly: readOnly,
          disabled: disabled,
          sx: (0, _extends2.default)({
            borderBottom: 0,
            width: 'auto',
            [`.${_MultiSectionDigitalClock.multiSectionDigitalClockSectionClasses.root}`]: {
              maxHeight: '100%'
            }
          }, Array.isArray(sx) ? sx : [sx]),
          autoFocus: autoFocus,
          disableIgnoringDatePartForTimeValidation: disableIgnoringDatePartForTimeValidation,
          timeSteps: timeSteps,
          skipDisabled: skipDisabled,
          timezone: timezone
        })]
      })]
    }), isActionBarVisible && /*#__PURE__*/(0, _jsxRuntime.jsx)(_Divider.default, {})]
  });
};
exports.renderDesktopDateTimeView = renderDesktopDateTimeView;