"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testLocalization = void 0;
var _chai = require("chai");
var _sinon = require("sinon");
var _pickersUtils = require("test/utils/pickers-utils");
var _describeGregorianAdapter = require("./describeGregorianAdapter.utils");
const testLocalization = ({
  adapter
}) => {
  const testDateIso = adapter.date(_describeGregorianAdapter.TEST_DATE_ISO_STRING);
  it('Method: formatNumber', () => {
    (0, _chai.expect)(adapter.formatNumber('1')).to.equal('1');
  });
  it('Method: getMeridiemText', () => {
    (0, _chai.expect)(adapter.getMeridiemText('am')).to.equal('AM');
    (0, _chai.expect)(adapter.getMeridiemText('pm')).to.equal('PM');

    // Moment only translates for 12-hour cycle.
    if (adapter.lib === 'moment') {
      const sinonStub = (0, _sinon.stub)(adapter, 'is12HourCycleInCurrentLocale').returns(false);
      (0, _chai.expect)(adapter.getMeridiemText('am')).to.equal('AM');
      (0, _chai.expect)(adapter.getMeridiemText('pm')).to.equal('PM');
      sinonStub.restore();
    }
  });
  it('Method: expandFormat', () => {
    const testFormat = formatKey => {
      const formatString = adapter.formats[formatKey];
      const expandedFormat = (0, _pickersUtils.cleanText)(adapter.expandFormat(formatString));
      if (expandedFormat === formatString) {
        return;
      }

      // The expanded format should be fully expanded
      (0, _chai.expect)((0, _pickersUtils.cleanText)(adapter.expandFormat(expandedFormat))).to.equal(expandedFormat);

      // Both format should be equivalent
      (0, _chai.expect)((0, _pickersUtils.cleanText)(adapter.formatByString(testDateIso, expandedFormat))).to.equal((0, _pickersUtils.cleanText)(adapter.format(testDateIso, formatKey)));
    };
    Object.keys(adapter.formats).forEach(formatKey => {
      testFormat(formatKey);
    });
  });
  it('Method: getFormatHelperText', () => {
    (0, _chai.expect)(adapter.getFormatHelperText(adapter.formats.keyboardDate)).to.equal(adapter.lib === 'luxon' ? 'm/d/yyyy' : 'mm/dd/yyyy');
    (0, _chai.expect)(adapter.getFormatHelperText(adapter.formats.keyboardDateTime12h)).to.equal(adapter.lib === 'luxon' ? 'm/d/yyyy hh:mm (a|p)m' : 'mm/dd/yyyy hh:mm (a|p)m');
  });
  it('Method: getCurrentLocaleCode', () => {
    // Returns the default locale
    (0, _chai.expect)(adapter.getCurrentLocaleCode()).to.match(/en/);
  });
};
exports.testLocalization = testLocalization;