"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testDayViewValidation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _chai = require("chai");
var React = _interopRequireWildcard(require("react"));
var _utils = require("@mui/monorepo/test/utils");
var _pickersUtils = require("test/utils/pickers-utils");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const testDayViewValidation = (ElementToTest, getOptions) => {
  const {
    componentFamily,
    views,
    render,
    clock,
    withDate,
    withTime
  } = getOptions();
  if (componentFamily === 'field' || !views.includes('day')) {
    return;
  }
  describe('day view:', () => {
    const defaultProps = {
      onChange: () => {},
      open: true,
      view: 'day',
      reduceAnimations: true,
      slotProps: {
        toolbar: {
          hidden: true
        }
      }
    };
    it('should apply shouldDisableDate', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2018, 2, 12)),
        shouldDisableDate: date => _pickersUtils.adapterToUse.isAfter(date, _pickersUtils.adapterToUse.date(new Date(2018, 2, 10)))
      })));
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '9'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '10'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '11'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '12'
      })).to.have.attribute('disabled');
    });
    it('should apply shouldDisableYear', function test() {
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2018, 2, 12)),
        shouldDisableYear: date => _pickersUtils.adapterToUse.getYear(date) === 2018
      })));
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '1'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '15'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '30'
      })).to.have.attribute('disabled');
      setProps({
        value: _pickersUtils.adapterToUse.date(new Date(2019, 0, 1))
      });
      clock.runToLast();
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '1'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '15'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '30'
      })).not.to.have.attribute('disabled');
    });
    it('should apply shouldDisableMonth', function test() {
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2018, 2, 12)),
        shouldDisableMonth: date => _pickersUtils.adapterToUse.getMonth(date) === 2
      })));
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '1'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '15'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '30'
      })).to.have.attribute('disabled');
      setProps({
        value: _pickersUtils.adapterToUse.date(new Date(2018, 1, 1))
      });
      clock.runToLast();
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '1'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '15'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '28'
      })).not.to.have.attribute('disabled');
    });
    it('should apply disablePast', function test() {
      let now;
      function WithFakeTimer(props) {
        now = _pickersUtils.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, (0, _extends2.default)({}, defaultProps, {
        disablePast: true
      })));
      const tomorrow = _pickersUtils.adapterToUse.addDays(now, 1);
      const yesterday = _pickersUtils.adapterToUse.addDays(now, -1);
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: _pickersUtils.adapterToUse.format(now, 'dayOfMonth')
      })).not.to.have.attribute('disabled');
      if (!_pickersUtils.adapterToUse.isSameMonth(now, tomorrow)) {
        setProps({
          value: tomorrow
        });
        clock.runToLast();
      }
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: _pickersUtils.adapterToUse.format(tomorrow, 'dayOfMonth')
      })).not.to.have.attribute('disabled');
      if (!_pickersUtils.adapterToUse.isSameMonth(yesterday, tomorrow)) {
        setProps({
          value: yesterday
        });
        clock.runToLast();
      }
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: _pickersUtils.adapterToUse.format(yesterday, 'dayOfMonth')
      })).to.have.attribute('disabled');
    });
    it('should apply disableFuture', function test() {
      let now;
      function WithFakeTimer(props) {
        now = _pickersUtils.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, (0, _extends2.default)({}, defaultProps, {
        disableFuture: true
      })));
      const tomorrow = _pickersUtils.adapterToUse.addDays(now, 1);
      const yesterday = _pickersUtils.adapterToUse.addDays(now, -1);
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: _pickersUtils.adapterToUse.format(now, 'dayOfMonth')
      })).not.to.have.attribute('disabled');
      if (!_pickersUtils.adapterToUse.isSameMonth(now, tomorrow)) {
        setProps({
          value: tomorrow
        });
        clock.runToLast();
      }
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: _pickersUtils.adapterToUse.format(tomorrow, 'dayOfMonth')
      })).to.have.attribute('disabled');
      if (!_pickersUtils.adapterToUse.isSameMonth(yesterday, tomorrow)) {
        setProps({
          value: yesterday
        });
        clock.runToLast();
      }
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: _pickersUtils.adapterToUse.format(yesterday, 'dayOfMonth')
      })).not.to.have.attribute('disabled');
    });
    it('should apply minDate', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2019, 5, 15)),
        minDate: _pickersUtils.adapterToUse.date(new Date(2019, 5, 4))
      })));
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '1'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '3'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '4'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '5'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '30'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByLabelText('Previous month')).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByLabelText('Next month')).not.to.have.attribute('disabled');
    });
    it('should apply maxDate', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2019, 5, 15)),
        maxDate: _pickersUtils.adapterToUse.date(new Date(2019, 5, 4))
      })));
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '1'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '3'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '4'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '5'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '30'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByLabelText('Previous month')).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByLabelText('Next month')).to.have.attribute('disabled');
    });
    it('should apply maxDateTime', function test() {
      if (!withDate || !withTime) {
        // prop only available on DateTime pickers
        return;
      }
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2019, 5, 15)),
        maxDateTime: _pickersUtils.adapterToUse.date(new Date(2019, 5, 4, 12, 0, 0))
      })));
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '1'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '3'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '4'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '5'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '30'
      })).to.have.attribute('disabled');
    });
    it('should apply minDateTime', function test() {
      if (!withDate || !withTime) {
        // prop only available on DateTime pickers
        return;
      }
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2019, 5, 15)),
        minDateTime: _pickersUtils.adapterToUse.date(new Date(2019, 5, 4, 12, 0, 0))
      })));
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '1'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '3'
      })).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '4'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '5'
      })).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByRole('gridcell', {
        name: '30'
      })).not.to.have.attribute('disabled');
    });
  });
};
exports.testDayViewValidation = testDayViewValidation;