"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testMonthViewValidation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _chai = require("chai");
var React = _interopRequireWildcard(require("react"));
var _utils = require("@mui/monorepo/test/utils");
var _pickersUtils = require("test/utils/pickers-utils");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const testMonthViewValidation = (ElementToTest, getOptions) => {
  const {
    views,
    componentFamily,
    render,
    clock
  } = getOptions();
  if (componentFamily === 'field' || !views.includes('month')) {
    return;
  }
  describe('month view:', () => {
    const defaultProps = (0, _extends2.default)({
      onChange: () => {}
    }, views.length > 1 && {
      views: ['month'],
      view: 'month',
      openTo: 'month'
    }, componentFamily !== 'calendar' && {
      open: true,
      reduceAnimations: true,
      slotProps: {
        toolbar: {
          hidden: true
        }
      }
    });
    it('should apply shouldDisableMonth', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: null,
        shouldDisableMonth: date => _pickersUtils.adapterToUse.getMonth(date) === 3
      })));
      (0, _chai.expect)(_utils.screen.getByText('Apr')).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByText('Jan')).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByText('May')).not.to.have.attribute('disabled');
    });
    it('should apply disablePast', function test() {
      let now;
      function WithFakeTimer(props) {
        now = _pickersUtils.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, (0, _extends2.default)({}, defaultProps, {
        disablePast: true
      })));
      const nextMonth = _pickersUtils.adapterToUse.addMonths(now, 1);
      const prevMonth = _pickersUtils.adapterToUse.addMonths(now, -1);
      (0, _chai.expect)(_utils.screen.getByText(_pickersUtils.adapterToUse.format(now, 'monthShort'))).not.to.have.attribute('disabled');
      if (!_pickersUtils.adapterToUse.isSameYear(now, nextMonth)) {
        setProps({
          value: nextMonth
        });
        clock.runToLast();
      }
      (0, _chai.expect)(_utils.screen.getByText(_pickersUtils.adapterToUse.format(nextMonth, 'monthShort'))).not.to.have.attribute('disabled');
      if (!_pickersUtils.adapterToUse.isSameYear(prevMonth, nextMonth)) {
        setProps({
          value: prevMonth
        });
        clock.runToLast();
      }
      (0, _chai.expect)(_utils.screen.getByText(_pickersUtils.adapterToUse.format(prevMonth, 'monthShort'))).to.have.attribute('disabled');

      // TODO: define what appends when value is `null`
    });

    it('should apply disableFuture', function test() {
      let now;
      function WithFakeTimer(props) {
        now = _pickersUtils.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      const {
        setProps
      } = render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, (0, _extends2.default)({}, defaultProps, {
        disableFuture: true
      })));
      const nextMonth = _pickersUtils.adapterToUse.addMonths(now, 1);
      const prevMonth = _pickersUtils.adapterToUse.addMonths(now, -1);
      (0, _chai.expect)(_utils.screen.getByText(_pickersUtils.adapterToUse.format(now, 'monthShort'))).not.to.have.attribute('disabled');
      if (!_pickersUtils.adapterToUse.isSameYear(now, nextMonth)) {
        setProps({
          value: nextMonth
        });
        clock.runToLast();
      }
      (0, _chai.expect)(_utils.screen.getByText(_pickersUtils.adapterToUse.format(nextMonth, 'monthShort'))).to.have.attribute('disabled');
      if (!_pickersUtils.adapterToUse.isSameYear(prevMonth, nextMonth)) {
        setProps({
          value: prevMonth
        });
        clock.runToLast();
      }
      (0, _chai.expect)(_utils.screen.getByText(_pickersUtils.adapterToUse.format(prevMonth, 'monthShort'))).not.to.have.attribute('disabled');

      // TODO: define what appends when value is `null`
    });

    it('should apply minDate', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2019, 5, 15)),
        minDate: _pickersUtils.adapterToUse.date(new Date(2019, 5, 4))
      })));
      (0, _chai.expect)(_utils.screen.getByText('Jan')).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByText('May')).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByText('Jun')).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByText('Jul')).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByText('Dec')).not.to.have.attribute('disabled');

      // TODO: define what appends when value is `null`
    });

    it('should apply maxDate', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2019, 5, 15)),
        maxDate: _pickersUtils.adapterToUse.date(new Date(2019, 5, 4))
      })));
      (0, _chai.expect)(_utils.screen.getByText('Jan')).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByText('Jun')).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByText('Jul')).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.getByText('Dec')).to.have.attribute('disabled');

      // TODO: define what appends when value is `null`
    });
  });
};
exports.testMonthViewValidation = testMonthViewValidation;