"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testYearViewValidation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var _chai = require("chai");
var _utils = require("@mui/monorepo/test/utils");
var _pickersUtils = require("test/utils/pickers-utils");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const testYearViewValidation = (ElementToTest, getOptions) => {
  const {
    views,
    componentFamily,
    render
  } = getOptions();
  if (componentFamily === 'field' || !views.includes('year')) {
    return;
  }
  describe('year view:', () => {
    const defaultProps = (0, _extends2.default)({
      onChange: () => {}
    }, views.length > 1 && {
      views: ['year'],
      view: 'year',
      openTo: 'year'
    }, componentFamily !== 'calendar' && {
      open: true,
      reduceAnimations: true,
      slotProps: {
        toolbar: {
          hidden: true
        }
      }
    });
    it('should apply shouldDisableYear', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: null,
        shouldDisableYear: date => _pickersUtils.adapterToUse.getYear(date) === 2018
      })));
      (0, _chai.expect)(_utils.screen.queryByText('2018')).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.queryByText('2019')).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.queryByText('2017')).not.to.have.attribute('disabled');
    });
    it('should apply disablePast', function test() {
      let now;
      function WithFakeTimer(props) {
        now = _pickersUtils.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, (0, _extends2.default)({}, defaultProps, {
        disablePast: true
      })));
      const nextYear = _pickersUtils.adapterToUse.addYears(now, 1);
      const prevYear = _pickersUtils.adapterToUse.addYears(now, -1);
      (0, _chai.expect)(_utils.screen.queryByText(_pickersUtils.adapterToUse.format(now, 'year'))).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.queryByText(_pickersUtils.adapterToUse.format(nextYear, 'year'))).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.queryByText(_pickersUtils.adapterToUse.format(prevYear, 'year'))).to.have.attribute('disabled');
    });
    it('should apply disableFuture', function test() {
      let now;
      function WithFakeTimer(props) {
        now = _pickersUtils.adapterToUse.date(new Date());
        return /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({
          value: now
        }, props));
      }
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(WithFakeTimer, (0, _extends2.default)({}, defaultProps, {
        disableFuture: true
      })));
      const nextYear = _pickersUtils.adapterToUse.addYears(now, 1);
      const prevYear = _pickersUtils.adapterToUse.addYears(now, -1);
      (0, _chai.expect)(_utils.screen.queryByText(_pickersUtils.adapterToUse.format(now, 'year'))).not.to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.queryByText(_pickersUtils.adapterToUse.format(nextYear, 'year'))).to.have.attribute('disabled');
      (0, _chai.expect)(_utils.screen.queryByText(_pickersUtils.adapterToUse.format(prevYear, 'year'))).not.to.have.attribute('disabled');
    });
    it('should apply minDate', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2019, 5, 15)),
        minDate: _pickersUtils.adapterToUse.date(new Date(2019, 5, 4))
      })));
      (0, _chai.expect)(_utils.screen.queryByText('2018')).to.equal(null);
      (0, _chai.expect)(_utils.screen.queryByText('2019')).not.to.equal(null);
      (0, _chai.expect)(_utils.screen.queryByText('2020')).not.to.equal(null);
    });
    it('should apply maxDate', function test() {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, (0, _extends2.default)({}, defaultProps, {
        value: _pickersUtils.adapterToUse.date(new Date(2019, 5, 15)),
        maxDate: _pickersUtils.adapterToUse.date(new Date(2019, 5, 4))
      })));
      (0, _chai.expect)(_utils.screen.queryByText('2018')).not.to.equal(null);
      (0, _chai.expect)(_utils.screen.queryByText('2019')).not.to.equal(null);
      (0, _chai.expect)(_utils.screen.queryByText('2020')).to.equal(null);
    });
  });
};
exports.testYearViewValidation = testYearViewValidation;