"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testPickerOpenCloseLifeCycle = void 0;
var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));
var React = _interopRequireWildcard(require("react"));
var _chai = require("chai");
var _sinon = require("sinon");
var _utils = require("@mui/monorepo/test/utils");
var _pickersUtils = require("test/utils/pickers-utils");
var _jsxRuntime = require("react/jsx-runtime");
const _excluded = ["componentFamily", "render", "renderWithProps", "values", "setNewValue"];
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const testPickerOpenCloseLifeCycle = (ElementToTest, options) => {
  const {
      componentFamily,
      render,
      renderWithProps,
      values,
      setNewValue
    } = options,
    pickerParams = (0, _objectWithoutPropertiesLoose2.default)(options, _excluded);
  if (componentFamily !== 'picker') {
    return;
  }
  const viewWrapperRole = pickerParams.type === 'date-range' && pickerParams.variant === 'desktop' ? 'tooltip' : 'dialog';
  describe('Picker open / close lifecycle', () => {
    it('should not open on mount if `props.open` is false', () => {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {}));
      (0, _chai.expect)(_utils.screen.queryByRole(viewWrapperRole)).to.equal(null);
    });
    it('should open on mount if `prop.open` is true', () => {
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        open: true
      }));
      (0, _chai.expect)(_utils.screen.queryByRole(viewWrapperRole)).toBeVisible();
    });
    it('should not open when `prop.disabled` is true ', () => {
      const onOpen = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        disabled: true,
        onOpen: onOpen
      }));
      (0, _pickersUtils.openPicker)(pickerParams);
      (0, _chai.expect)(onOpen.callCount).to.equal(0);
    });
    it('should not open when `prop.readOnly` is true ', () => {
      const onOpen = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        readOnly: true,
        onOpen: onOpen
      }));
      (0, _pickersUtils.openPicker)(pickerParams);
      (0, _chai.expect)(onOpen.callCount).to.equal(0);
    });
    it('should call onChange, onClose (if desktop) and onAccept (if desktop) when selecting a value', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      const {
        selectSection
      } = renderWithProps({
        onChange,
        onAccept,
        onClose,
        defaultValue: values[0],
        open: true
      });
      (0, _chai.expect)(onChange.callCount).to.equal(0);
      (0, _chai.expect)(onAccept.callCount).to.equal(0);
      (0, _chai.expect)(onClose.callCount).to.equal(0);

      // Change the value
      let newValue = setNewValue(values[0], {
        isOpened: true,
        selectSection
      });
      (0, _chai.expect)(onChange.callCount).to.equal((0, _pickersUtils.getExpectedOnChangeCount)(componentFamily, pickerParams));
      if (pickerParams.type === 'date-range') {
        newValue = setNewValue(newValue, {
          isOpened: true,
          setEndDate: true,
          selectSection
        });
        newValue.forEach((value, index) => {
          (0, _chai.expect)(onChange.lastCall.args[0][index]).toEqualDateTime(value);
        });
      } else {
        (0, _chai.expect)(onChange.lastCall.args[0]).toEqualDateTime(newValue);
      }
      (0, _chai.expect)(onAccept.callCount).to.equal(pickerParams.variant === 'mobile' ? 0 : 1);
      (0, _chai.expect)(onClose.callCount).to.equal(pickerParams.variant === 'mobile' ? 0 : 1);
    });
    it('should not select input content after closing on mobile', () => {
      if (pickerParams.variant !== 'mobile') {
        return;
      }
      const {
        selectSection
      } = renderWithProps({
        defaultValue: values[0]
      });

      // Change the value
      setNewValue(values[0], {
        selectSection
      });
      let textbox;
      if (pickerParams.type === 'date-range') {
        textbox = _utils.screen.getAllByRole('textbox')[0];
      } else {
        textbox = (0, _pickersUtils.getTextbox)();
      }
      (0, _chai.expect)(textbox.scrollLeft).to.be.equal(0);
    });
    it('should call onChange, onClose and onAccept when selecting a value and `props.closeOnSelect` is true', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      const {
        selectSection
      } = renderWithProps({
        onChange,
        onAccept,
        onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: true
      });
      (0, _chai.expect)(onChange.callCount).to.equal(0);
      (0, _chai.expect)(onAccept.callCount).to.equal(0);
      (0, _chai.expect)(onClose.callCount).to.equal(0);

      // Change the value
      let newValue = setNewValue(values[0], {
        isOpened: true,
        selectSection
      });
      (0, _chai.expect)(onChange.callCount).to.equal((0, _pickersUtils.getExpectedOnChangeCount)(componentFamily, pickerParams));
      if (pickerParams.type === 'date-range') {
        newValue = setNewValue(newValue, {
          isOpened: true,
          setEndDate: true,
          selectSection
        });
        newValue.forEach((value, index) => {
          (0, _chai.expect)(onChange.lastCall.args[0][index]).toEqualDateTime(value);
        });
      } else {
        (0, _chai.expect)(onChange.lastCall.args[0]).toEqualDateTime(newValue);
      }
      (0, _chai.expect)(onAccept.callCount).to.equal(1);
      (0, _chai.expect)(onClose.callCount).to.equal(1);
    });
    it('should not call onChange or onAccept when selecting the same value', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      const {
        selectSection
      } = renderWithProps({
        onChange,
        onAccept,
        onClose,
        open: true,
        value: values[0],
        closeOnSelect: true
      });

      // Change the value (same value)
      setNewValue(values[0], {
        isOpened: true,
        applySameValue: true,
        selectSection
      });
      if (pickerParams.type === 'date-range') {
        setNewValue(values[0], {
          isOpened: true,
          applySameValue: true,
          setEndDate: true,
          selectSection
        });
      }
      (0, _chai.expect)(onChange.callCount).to.equal(0);
      (0, _chai.expect)(onAccept.callCount).to.equal(0);
      (0, _chai.expect)(onClose.callCount).to.equal(1);
    });
    it('should not call onClose or onAccept when selecting a date and `props.closeOnSelect` is false', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      const {
        selectSection
      } = renderWithProps({
        onChange,
        onAccept,
        onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: false
      });

      // Change the value
      let newValue = setNewValue(values[0], {
        isOpened: true,
        selectSection
      });
      const initialChangeCount = (0, _pickersUtils.getExpectedOnChangeCount)(componentFamily, pickerParams);
      (0, _chai.expect)(onChange.callCount).to.equal(initialChangeCount);
      if (pickerParams.type === 'date-range') {
        newValue = setNewValue(newValue, {
          isOpened: true,
          setEndDate: true,
          selectSection
        });
        newValue.forEach((value, index) => {
          (0, _chai.expect)(onChange.lastCall.args[0][index]).toEqualDateTime(value);
        });
      } else {
        (0, _chai.expect)(onChange.lastCall.args[0]).toEqualDateTime(newValue);
      }
      (0, _chai.expect)(onAccept.callCount).to.equal(0);
      (0, _chai.expect)(onClose.callCount).to.equal(0);

      // Change the value
      let newValueBis = setNewValue(newValue, {
        isOpened: true,
        selectSection
      });
      if (pickerParams.type === 'date-range') {
        (0, _chai.expect)(onChange.callCount).to.equal(3);
        newValueBis = setNewValue(newValueBis, {
          isOpened: true,
          setEndDate: true,
          selectSection
        });
        newValueBis.forEach((value, index) => {
          (0, _chai.expect)(onChange.lastCall.args[0][index]).toEqualDateTime(value);
        });
      } else {
        (0, _chai.expect)(onChange.callCount).to.equal(initialChangeCount + (0, _pickersUtils.getExpectedOnChangeCount)(componentFamily, pickerParams) - (
        // meridiem does not change this time in case of multi section digital clock
        pickerParams.type === 'time' || pickerParams.type === 'date-time' ? 1 : 0));
        (0, _chai.expect)(onChange.lastCall.args[0]).toEqualDateTime(newValueBis);
      }
      (0, _chai.expect)(onAccept.callCount).to.equal(0);
      (0, _chai.expect)(onClose.callCount).to.equal(0);
    });
    it('should call onClose and onAccept with the live value when pressing Escape', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      const {
        selectSection
      } = renderWithProps({
        onChange,
        onAccept,
        onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: false
      });

      // Change the value (already tested)
      const newValue = setNewValue(values[0], {
        isOpened: true,
        selectSection
      });

      // Dismiss the picker
      _utils.userEvent.keyPress(document.activeElement, {
        key: 'Escape'
      });
      (0, _chai.expect)(onChange.callCount).to.equal((0, _pickersUtils.getExpectedOnChangeCount)(componentFamily, pickerParams));
      (0, _chai.expect)(onAccept.callCount).to.equal(1);
      if (pickerParams.type === 'date-range') {
        newValue.forEach((value, index) => {
          (0, _chai.expect)(onChange.lastCall.args[0][index]).toEqualDateTime(value);
        });
      } else {
        (0, _chai.expect)(onChange.lastCall.args[0]).toEqualDateTime(newValue);
      }
      (0, _chai.expect)(onClose.callCount).to.equal(1);
    });
    it('should call onClose when clicking outside of the picker without prior change', function test() {
      // TODO: Fix this test and enable it on mobile and date-range
      if (pickerParams.variant === 'mobile' || pickerParams.type === 'date-range') {
        this.skip();
      }
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        value: values[0],
        open: true,
        closeOnSelect: false
      }));

      // Dismiss the picker
      _utils.userEvent.mousePress(document.body);
      (0, _chai.expect)(onChange.callCount).to.equal(0);
      (0, _chai.expect)(onAccept.callCount).to.equal(0);
      (0, _chai.expect)(onClose.callCount).to.equal(1);
    });
    it('should call onClose and onAccept with the live value when clicking outside of the picker', function test() {
      // TODO: Fix this test and enable it on mobile and date-range
      if (pickerParams.variant === 'mobile' || pickerParams.type === 'date-range') {
        this.skip();
      }
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      const {
        selectSection
      } = renderWithProps({
        onChange,
        onAccept,
        onClose,
        defaultValue: values[0],
        open: true,
        closeOnSelect: false
      });

      // Change the value (already tested)
      const newValue = setNewValue(values[0], {
        isOpened: true,
        selectSection
      });

      // Dismiss the picker
      _utils.userEvent.mousePress(document.body);
      (0, _chai.expect)(onChange.callCount).to.equal((0, _pickersUtils.getExpectedOnChangeCount)(componentFamily, pickerParams));
      (0, _chai.expect)(onAccept.callCount).to.equal(1);
      (0, _chai.expect)(onAccept.lastCall.args[0]).toEqualDateTime(newValue);
      (0, _chai.expect)(onClose.callCount).to.equal(1);
    });
    it('should not call onClose or onAccept when clicking outside of the picker if not opened', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose,
        closeOnSelect: false
      }));

      // Dismiss the picker
      _utils.userEvent.mousePress(document.body);
      (0, _chai.expect)(onChange.callCount).to.equal(0);
      (0, _chai.expect)(onAccept.callCount).to.equal(0);
      (0, _chai.expect)(onClose.callCount).to.equal(0);
    });
    it('should not call onClose or onAccept when pressing escape when picker is not opened', () => {
      const onChange = (0, _sinon.spy)();
      const onAccept = (0, _sinon.spy)();
      const onClose = (0, _sinon.spy)();
      render( /*#__PURE__*/(0, _jsxRuntime.jsx)(ElementToTest, {
        onChange: onChange,
        onAccept: onAccept,
        onClose: onClose
      }));

      // Dismiss the picker
      _utils.userEvent.keyPress(document.body, {
        key: 'Escape'
      });
      (0, _chai.expect)(onChange.callCount).to.equal(0);
      (0, _chai.expect)(onAccept.callCount).to.equal(0);
      (0, _chai.expect)(onClose.callCount).to.equal(0);
    });
  });
};
exports.testPickerOpenCloseLifeCycle = testPickerOpenCloseLifeCycle;